var xmlSearchData = "";
xmlSearchData += '<?xml version=\"1.0\" encoding=\"utf-8\"?><index PreMerged=\"false\" SearchType=\"Stem\" NGramSize=\"1\"><urls><Url Source=\"../content/introduction.htm\" Title=\"Introduction\" Abstract=\"Introduction&#xA;         Welcome to the MrSID® Software Development Kit (SDK) for raster imagery.&#xA;This is the documentation for the  Decode version (DSDK) .  Digital images have become important to every aspect of business, industry, and government. Because of the enormous amounts of data involved, the ...\" /><Url Source=\"../content/features.htm\" Title=\"Features\" Abstract=\"The MrSID SDK is a toolkit for software developers. It is written in C++ to provide an object-oriented framework for working with images using MrSID and JPEG 2000 technology. The major features of the MrSID SDK include: Architecture The SDK uses a classical image-pipeline design, providing a single, ...\" /><Url Source=\"../content/how_to_read_this_manual.htm\" Title=\"How to Read this Manual\" Abstract=\"This User Manual gives a high-level view of the design, features and classes that make up the MrSID SDK. The chapter  Architecture and Design  describes the overall architecture of the image pipeline and strip-based decoding mechanism that this SDK implements. Further chapters briefly motivate and ...\" /><Url Source=\"../content/sdk_contents.htm\" Title=\"SDK Contents\" Abstract=\"The contents of the MrSID SDK include the following: Documentation Cover documentation In the top-level directory, the README.txt and CHANGES.txt files contain information about late changes to the SDK License In the top-level directory, the file LICENSE.txt contains the complete licensing ...\" /><Url Source=\"../content/getting_started.htm\" Title=\"Getting Started\" Abstract=\"This chapter provides some preliminary information to get you started using the MrSID SDK. At the least, we suggest you skim this User Manual and the accompanying  Reference Manual , then build and execute the provided example application. The example sources should give you enough information to ...\" /><Url Source=\"../content/system_requirements.htm\" Title=\"System Requirements\" Abstract=\"The MrSID SDK is a set of C++ libraries that must be used in conjunction with the specific development environment for your platform. The supported configurations are listed below. For optimal performance, verify that your system meets the following minimum recommended hardware requirements: 2 GHz ...\" /><Url Source=\"../content/installation.htm\" Title=\"Installation\" Abstract=\"Installation No specific installation is required to use the GeoExpress SDK beyond copying the SDK contents from the media provided (CD, ISO CD image, archive from FTP site, etc.) to your local computer.&#xA; See the file README.txt in your installation directory for complete instructions.&#xA;\" /><Url Source=\"../content/example_code.htm\" Title=\"Example Code\" Abstract=\"Example Code The GeoExpress SDK&#160;includes a number of examples that demonstrate the major features of the SDK. The table below shows which files to consult for various types of operations. &#160; &#160;\" /><Url Source=\"../content/technical_support.htm\" Title=\"Technical Support\" Abstract=\"Most technical issues can be resolved using the various resources you have available. In addition to the product documentation and the README file, LizardTech offers a knowledge base and product updates on the LizardTech website.&#xA; Knowledge Base  http://www.lizardtech.com/support/kb/ The LizardTech ...\" /><Url Source=\"../content/architecture_and_design.htm\" Title=\"Architecture and Design\" Abstract=\"This section describes some of the design principles used by the MrSID SDK, including the image pipeline model, strip-based decoding and some of the C++ conventions used by the main classes.&#xA;&#xA; Subsequent sections will describe the specific classes that make up the SDK.&#xA; Click any link below for more ...\" /><Url Source=\"../content/pipeline_design.htm\" Title=\"Pipeline Design\" Abstract=\"An image processing pipeline is a system in which each image “stage” performs one specific operation on an image or a piece of an image, and then passes the resulting image data on to the next stage. The MrSID SDK uses this model to provide the ability to construct workflows that read, write, and ...\" /><Url Source=\"../content/shrip_based_decoding.htm\" Title=\"Strip-Based Decoding\" Abstract=\"The MrSID SDK is designed for workflows involving large images. To accommodate large (gigabyte-sized) datasets, the image pipeline framework is designed to process images in advancing horizontal strips. This reduces the amount of memory required to process the image.&#xA;&#xA; To read a scene from an image, ...\" /><Url Source=\"../content/scenes.htm\" Title=\"Scenes\" Abstract=\"As implied in the previous section, when a read() call is made to an image stage, the scene of interest must be specified. A scene, implemented by the LTIScene class, has three basic properties:&#xA;&#xA; upper-left x- and y-position&#xA;&#xA; width and height&#xA;&#xA; magnification (resolution)&#xA;&#xA; The position is ...\" /><Url Source=\"../content/multi-threading.htm\" Title=\"Multi-Threading\" Abstract=\"&#160;If you run the SDK on a machine with a multi-core processor or on a machine with multiple processors, the SDK&#160;creates multiple threads to run decoding operations more quickly. By default, the SDK&#160;uses the maximum number of threads available for optimal performance. The maximum number of threads ...\" /><Url Source=\"../content/other_design_considerations.htm\" Title=\"Other Design Considerations\" Abstract=\"The C++ classes and functions that make up the MrSID SDK follow a few other general principles and conventions. They are explained here to motivate their usage. For other, less central principles, see  &quot;Coding Conventions&quot; .&#xA;&#xA; &#xA;&#xA; Status Codes &#xA;&#xA; Many of the SDK member functions return status codes ...\" /><Url Source=\"../content/the_support_classes.htm\" Title=\"The Support Classes\" Abstract=\"We begin with the set of types, classes and functions that underlie the entire SDK. These do not provide any specific imaging functionality, but they are used as primitives for all the other classes that follow in subsequent chapters. The names of the types, classes, etc. described in this chapter ...\" /><Url Source=\"../content/preprocessor_constants_and_basic_typedefs.htm\" Title=\"Preprocessor Constants and Basic Typedefs\" Abstract=\"The C header file lt_base.h should be included by all source files using the MrSID SDK. It includes four other C headers (lt_define.h, lt_platform.h, lt_status.h, and lt_types.h), which contain definitions for the following:&#xA;&#xA; miscellaneous preprocessor constants and macros used throughout the SDK&#xA;&#xA; ...\" /><Url Source=\"../content/status_strings.htm\" Title=\"Status Strings\" Abstract=\"The file lt_utilStatusStrings.h declares several functions useful for mapping LT_STATUS values into text strings that indicate the nature of the error condition encountered. Most applications will want to use either the getRawStatusString() or getLastStatusString() function for retrieving error ...\" /><Url Source=\"../content/the_ltifilespec_class.htm\" Title=\"The LTIFileSpec Class\" Abstract=\"For portability between Unix and Windows systems and ease of use in internationalized environments, the SDK uses the class LTFileSpec to represent file names and paths.&#xA;&#xA; In all cases where the SDK requires use of a file name, for example as a function parameter, an LTFileSpec will be used. It is ...\" /><Url Source=\"../content/streams.htm\" Title=\"Streams\" Abstract=\"The MrSID SDK provides an abstract stream class, LTIOStreamInf, which provides a Unix stdio-like interface for working with data in files or file-like objects. Rather than relying on the application to provide a file name or a FILE*, many of the SDK functions are designed to operate on LTIOStreamInf ...\" /><Url Source=\"../content/the_sdk_base_classes.htm\" Title=\"The SDK Base Classes\" Abstract=\"The image pipeline reader, writer, and filter classes that support the MrSID SDK’s image pipeline system all rely on a set of base or “core” classes. This chapter introduces these classes, which represent such constructs as pixels, geographic positions, scenes, buffers, and so on. The names of the ...\" /><Url Source=\"../content/base_enums.htm\" Title=\"Base Enums\" Abstract=\"Base Enums The lti_types.h header contains a number of enums used throughout the SDK, including LTIColorSpace and LTIColor, for indicating pixel color spaces, e.g. RGB or multispectral, and LTIDataTypes, for indicating pixel datatypes, e.g. 8-bit unsigned integers or 32-bit floats.\" /><Url Source=\"../content/base_classes.htm\" Title=\"Base Classes\" Abstract=\"A number of lightweight classes are used to represent primitive objects in support of the imaging framework. The LTISample class represents a single sample of a pixel; the properties of a sample include datatype, color, and an optional value. The LTIPixel class represents a set of samples; the ...\" /><Url Source=\"../content/the_image_classes.htm\" Title=\"The Image Classes\" Abstract=\"As described in the previous chapter, a hierarchy of several classes is used to represent images, image stages, and the image pipeline. See Figure 1.&#xA; Inheritance &#xA;&#xA; &#xA;&#xA; The LTIImage class represents the properties of an image, including:&#xA;&#xA; width and height&#xA;&#xA; pixel type (number of bands, colorspace, ...\" /><Url Source=\"../content/the_raw_readers_and_writers.htm\" Title=\"The Raw Readers and Writers\" Abstract=\"Because they are the foundation of many other readers and writers, as well as being useful for development and debugging, the SDK base classes include “raw” reader and writer classes, LTIRawImageReader and LTIRawImageWriter.&#xA;&#xA; The two raw classes read and write image data directly to binary files ...\" /><Url Source=\"../content/scene_and_buffer_management.htm\" Title=\"Scene and Buffer Management\" Abstract=\"The two parameters to the LTIImageStage::read() function are an LTIScene object and an LTISceneBuffer object. These together specify the region of the image to be decoded and the buffer to put the data into.&#xA;&#xA; The properties of an LTIScene are the upper-left point, dimensions, and magnification of ...\" /><Url Source=\"../content/concrete_image_readers_filters_and_writers.htm\" Title=\"Concrete Image Filters and Writers\" Abstract=\"Concrete Image Filters and Writers The MrSID SDK uses two types of classes – image filters and image writers – for transforming and encoding images.  Click any link below for more information. Image Filters Image Writers\" /><Url Source=\"../content/image_filters.htm\" Title=\"Image Filters\" Abstract=\"The LTIImageFilter class is derived from the LTIImageStage class and is used as the base class for implementing specific (and generally simple) image transformations. The following image readers are supplied with this SDK: LTIAddAlphaFilter:&#160;This class adds an alpha band to an image that does not ...\" /><Url Source=\"../content/image_writers.htm\" Title=\"Image Writers\" Abstract=\"The LTIImageWriter class is the base class for implementing specific file format writers. While not derived from any of the other LTIImage classes, it is nonetheless designed to act as an “end” of the image pipeline in order to support writing out an image in a stripwise fashion. The following image ...\" /><Url Source=\"../content/mrsid_support.htm\" Title=\"MrSID Support\" Abstract=\"MrSID offers a solution to the challenges and a toolkit for the opportunities digital imaging presents. Because encoding to MrSID results in a lossless, single-source image, MrSID yields better storage economy, more efficient transfer of data, and improved workflow. A single, highly compressed, ...\" /><Url Source=\"../content/mg2_mg3_and_mg4.htm\" Title=\"MG2, MG3 and MG4\" Abstract=\"The most current version of the MrSID technology and file format is known as MrSID Generation 4 (MG4). Its predecessors were known as MG3 and MG2.  MG2 was the first commercial version of the compression technology and file format originally developed at Los Alamos National Laboratory. MG2 supports ...\" /><Url Source=\"../content/key_features_of_mrsid.htm\" Title=\"Key Features of MrSID\" Abstract=\"In this section we describe in more detail some of the features and capabilities of the MrSID technology for raster image data. The MrSID&#160;format also supports LiDAR data, but a separate set of tools and libraries is used in supporting LiDAR data in the MrSID format, and separate documentation is ...\" /><Url Source=\"../content/mrsid_readers.htm\" Title=\"MrSID Readers\" Abstract=\"The MrSID SDK provides a class for reading MrSID imagery.&#xA;&#xA;The MrSIDImageReader class supports reading from any MrSID image, MG2, MG3 or MG4.  (If the image is a composite, all tiles in the image will be used.)&#xA;This class provides an interface for querying the tile contents of composite images. This ...\" /><Url Source=\"../content/jpeg_2000_support.htm\" Title=\"JPEG 2000 Support\" Abstract=\"JPEG 2000 is the state-of-the-art successor to the popular JPEG compression standard. The original JPEG was based on the discrete cosine transform (DCT) and Huffman encoding and is not suitable for current workflows relying on high quality imaging, lossless encoding, or very large images.&#xA;&#xA; ...\" /><Url Source=\"../content/the_jpeg_2000_reader.htm\" Title=\"The JPEG 2000 Reader\" Abstract=\"The J2KImageReader class is used to read JPEG 2000 files or streams. This class supports a number of query functions to find information about how the image was encoded with JPEG 2000, as well as some decode-time functions to control how the image will be decoded. Please consult the  Reference ...\" /><Url Source=\"../content/nitf_support.htm\" Title=\"NITF Support\" Abstract=\"The National Imagery Transmission Format (NITF) standard was created by the Department of Defense as a means of formatting digital imagery and imagery-related products and exchanging them among members of the intelligence community, the Department of Defense (DOD), and other government departments ...\" /><Url Source=\"../content/nitf_reader.htm\" Title=\"The NITF Reader\" Abstract=\"The NITFImageManager and NITFImageReader classes are used to read NITF files. Unlike the other image readers, the NITFImageManager class must be used to construct an NITFImageReader object for a given image segment via the createReader method.  The NITFImageReader object behaves like any other image ...\" /><Url Source=\"../content/nitf_input_metadata.htm\" Title=\"NITF Input Metadata\" Abstract=\"The following discussion assumes familiarity with the NITF specification.&#xA;&#xA; When reading a NITF file, the SDK&#160;stores many NITF fields as metadata, for example as tag/value pairs in MrSID imagery (see  &quot;Metadata Tags&quot; ). In general, the tag name is of the form NITF::xxnnn::field where xx is a two ...\" /><Url Source=\"../content/metadata_support.htm\" Title=\"Metadata Support\" Abstract=\"Metadata is data about an image, as distinct from the actual image data (pixels). This includes everything from the basic width/height and datatype information up to geospatial information, background colors, creation dates, etc. The MrSID SDK uses a key/value pair system for recording tags and ...\" /><Url Source=\"../content/the_metadata_record.htm\" Title=\"The Metadata Record\" Abstract=\"A single key/value pair is represented by the LTIMetadataRecord class. This class has several properties:&#xA;&#xA; tag name &#xA; datatype &#xA; dimension information (number of dimensions and dimension array)  data pointer  The tag name is represented as an ASCII string. The well-known strings (those for common ...\" /><Url Source=\"../content/the_metadata_database.htm\" Title=\"The Metadata Database\" Abstract=\"Each image stage has an associated LTIMetadataDatabase object. This database supports several types of operations:&#xA;&#xA; query for a record &#xA; add a record &#xA; retrieve a record &#xA; remove a record &#xA; Records may be accessed via tag name or (positional) record number.&#xA;&#xA; Each image stage is responsible for ...\" /><Url Source=\"../content/the_tags.htm\" Title=\"The Tags\" Abstract=\"Certain metadata tags are set by almost all image stages and are known as the “classical” metadata tags:&#xA;&#xA; width and height &#xA; datatype  colorspace &#xA; dynamic range &#xA; background and nodata pixel values &#xA; geospatial (x,y) origin, x- and y-resolution, and rotation &#xA; original file size  original filename ...\" /><Url Source=\"../content/the_c_api.htm\" Title=\"The C API\" Abstract=\"The MrSID SDK is a large set of C++ classes containing many features and designed for many different needs and workflows. There is a corresponding cost in learning and development time to working with the full SDK. Recognizing this cost, the SDK also provides a small, C-based API for developers who ...\" /><Url Source=\"../content/image_support.htm\" Title=\"Image Support\" Abstract=\"The functions for opening and closing existing MrSID, JPEG 2000 and NITF images are:&#xA;&#xA; ltic_openMrSIDImageFile() ltic_openMrSIDImageStream() ltic_openJP2ImageFile() ltic_openJP2ImageStream() ltic_openNITFImageFile() ltic_closeImage() These functions all take either a filename or a stream, denoting ...\" /><Url Source=\"../content/decode_support.htm\" Title=\"Decode Support\" Abstract=\"To decode a scene from an image only one function call is required:&#xA;&#xA; LT_STATUS ltic_decode(LTICImageH image, xxxxxxxxxxxxxxxxxxxxxxdouble xUpperLeft, xxxxxxxxxxxxxxxxxxxxxxdouble yUpperLeft, xxxxxxxxxxxxxxxxxxxxxxdouble width, xxxxxxxxxxxxxxxxxxxxxxdouble height, xxxxxxxxxxxxxxxxxxxxxxdouble ...\" /><Url Source=\"../content/metadata_support2.htm\" Title=\"Metadata Support\" Abstract=\"The metadata of an image is accessed via two functions. The ltic_getNumMetadataRecords() function returns the number of metadata records in the image. The ltic_metadataRecord() function is used to extract the actual data values of a specific record.&#xA;&#xA; As with the ltic_decode() call, the parameters ...\" /><Url Source=\"../content/streams2.htm\" Title=\"Streams\" Abstract=\"An image may be opened either with a filename (const char*) or a stream. The MrSID SDK provides a class derived from LTIOStreamInf, called LTIOCallbackStream, which is designed for third-party streams and stream-like data structures. The file lt_ioCStream.h contains a set of C interfaces for ...\" /><Url Source=\"../content/command_line_applications.htm\" Title=\"Command Line Applications\" Abstract=\"Command Line Applications Several simple command line applications are included in this SDK to aid in development and testing.  Click any link below for more information.&#xA;&#xA; Switches Common to All Tools mrsidinfo mrsiddecode mrsidviewer\" /><Url Source=\"../content/switches_common_to_all_tools.htm\" Title=\"Switches Common to All Tools\" Abstract=\"The following switches are common to mrsidinfo, mrsiddecode, mrsidencode, mrsidoptimize and mrsidtile.&#xA; -h or -? Show short usage message -help Show detailed usage message -v or -version Show version information -credits Show credits and copyrights -quiet Don\'t show informational messages. This does ...\" /><Url Source=\"../content/mrsidinfo.htm\" Title=\"mrsidinfo\" Abstract=\"The mrsidinfo tool displays basic information about an image, such as width, height, etc. Various image formats are supported.&#xA; File Control&#xA; -if or -inputFormat STRING Input image type: tif | ras | jpg | nitf | doq | doq_nc | bbb | lan | bmp | img | jp2 | sid -mos or -mosaic Image format is mosaic ...\" /><Url Source=\"../content/mrsiddecode.htm\" Title=\"mrsiddecode\" Abstract=\"The mrsiddecode tool extracts (decodes) all or a portion of a MrSID or JPEG 2000 image to one of several image formats.&#xA;&#xA; &#xA;&#xA; Switches&#xA;&#xA; &#xA;&#xA; File Control&#xA; &#160; -i or -inputFile STRING Input file (required) -o or -outputFile STRING Output file (required) -of or -outputFormat STRING Output image format: ...\" /><Url Source=\"../content/mrsidviewer.htm\" Title=\"mrsidviewer\" Abstract=\"The mrsidviewer application is a very simple Windows application for viewing images in all of the formats supported by the SDK, including MrSID and JPEG 2000.&#xA;&#xA; The mrsidviewer application is available on Windows SDKs only.&#xA;&#xA; &#xA;&#xA; Operations&#xA;&#xA; zoom in:  left-click&#xA;&#xA; zoom out: shift + left-click&#xA;&#xA; pan: ...\" /><Url Source=\"../content/appendix_a_technical_notes.htm\" Title=\"Appendix A - Technical Notes\" Abstract=\"This chapter contains several articles providing background information on specific issues and questions frequently asked by some SDK developers. Please check LizardTech’s Developer website ( http://developer.lizardtech.com ) for additional and updated technical notes.&#xA; Click any link below for more ...\" /><Url Source=\"../content/zoom_levels.htm\" Title=\"Zoom Levels\" Abstract=\"The following describes the MrSID SDK’s handling of zoom levels for MG2, MG3, MG4 and JP2. In the code below, assume the following:&#xA;&#xA; &#xA;&#xA; W = image width (constant)&#xA;&#xA; H = image height (constant)&#xA;&#xA; n = number of levels&#xA;&#xA; &#xA;&#xA; &#xA;&#xA; MG2 Behavior&#xA; &#xA;&#xA; The default number of zoom levels is computed by initially ...\" /><Url Source=\"../content/coding_conventions.htm\" Title=\"Coding Conventions\" Abstract=\"The developers of the MrSID SDK follow a general set of coding conventions and guidelines. While we certainly don\'t expect third-party developers to adhere to these conventions, they are described here as an aid to understanding and working with the SDK, both at the syntactic and semantic level.&#xA;&#xA; ...\" /><Url Source=\"../content/overrides.htm\" Title=\"Overrides\" Abstract=\"The SDK uses a system of “mixins” to simplify the overriding of LTIImageStage properties.  Specifically, LTIImageStage defines an abstract interface that needs to be implemented by derived class of LTIImageFilter; LTIImageFilter implements the LTIImageStage interface by forwarding the method call to ...\" /><Url Source=\"../content/reference_counting.htm\" Title=\"Reference Counting\" Abstract=\"LTIImageStage objects are now reference counted. Use ClassName::create() to create a new object of type ClassName.&#xA; Use object-&gt;retain() when you want to keep an object around (but not if you created it)&#xA; Use object-&gt;release() when you are done using the object.&#xA; As a rule of thumb, if you create or ...\" /><Url Source=\"../content/notes_on_streams.htm\" Title=\"Notes on Streams\" Abstract=\"The LTIOStreamInf class, and streams derived from it, provide an abstraction for performing I/O in a variety of ways, including &quot;large file&quot; I/O, buffered I/O, memory-based I/O, etc. As it is a well-known model, the semantics of the stream operations are very similar to those of the Unix stdio ...\" /><Url Source=\"../content/notes_on_world_files.htm\" Title=\"Notes on World Files\" Abstract=\"A &quot;world file&quot; is a simple text file containing auxilliary georeferencing information for an image. It can be used to georeference an image that has no georeferencing information within it, or to override existing georeferencing information.&#xA;&#xA; By convention, the filename for a world file is the same ...\" /><Url Source=\"../content/notes_on_bbb_files.htm\" Title=\"Notes on BBB Files\" Abstract=\"A BBB image consists of two files, a binary file containing only the raw sample values of the image and a text file describing the image properties. The raw data may be organized in one of three layouts: &quot;band-interleaved by pixel&quot; (BIP), &quot;band-interleaved by line&quot; (BIL), and &quot;band sequential&quot; ...\" /><Url Source=\"../content/geotiff_metadata_for_jpeg_2000.htm\" Title=\"GeoTIFF Metadata for JPEG 2000\" Abstract=\"Following is a copy of the first draft of The &quot;GeoTIFF Box&quot; Specification for JPEG 2000 Metadata. &#160; *** DRAFT ***&#xA;&#xA; &#xA;&#xA; &#xA;&#xA;          The &quot;GeoTIFF Box&quot; Specification for JPEG 2000 Metadata&#xA;&#xA; &#xA;&#xA; &#xA;&#xA;                              Version 0.0&#xA;&#xA;                               30 April 2004&#xA;&#xA;                   ...\" /><Url Source=\"../content/georeferencing_of_nitf_imagery.htm\" Title=\"Georeferencing of NITF Imagery\" Abstract=\"Typically, TREs are used to provide the necessary georeferencing. As the current SDK release does NOT provide TRE support, however, some additional documentation may be helpful to some developers.&#xA;&#xA; This technical note provides commentary on how the SDK reads and writes “positioning information” in ...\" /><Url Source=\"../content/metadata_tags.htm\" Title=\"Metadata Tags\" Abstract=\"Encoded within each MrSID (and JPEG 2000) file is a set of metadata tags, used to convey additional information about the image. These tags are similar to TIFF tags, although the actual encoding mechanism is different. The mrsidinfo tool can be used to dump the metadata for an image.&#xA;&#xA; The standard ...\" /><Url Source=\"../content/negative_y_resolutions.htm\" Title=\"Negative y-Resolutions\" Abstract=\"The y-resolution (&quot;YRES&quot; or &quot;YDIM&quot;) of an image can be either positive or negative, depending on what type of image is being used and which interface is being used to query the resolution. This note provides some background on this issue.&#xA;&#xA; First, some definitions:&#xA;&#xA; By &quot;negative YDIM&quot; (hereafter, ...\" /><Url Source=\"../content/nodata_and_background_pixels.htm\" Title=\"Nodata and Background Pixels\" Abstract=\"This note describes how the MrSID SDK implements the concepts of &quot;nodata&quot; and &quot;background&quot; pixelsPixels. The following is not applicable to the MG4 format, in which transparency is implemented through the use of alpha bands.  Definitions&#xA; Nodata The nodata pixel of an image is used to indicate which ...\" /><Url Source=\"../content/appendix_b_company_and_product_information.htm\" Title=\"Appendix B - Company and Product Information\" Abstract=\"This chapter contains information about LizardTech and its products as well as copyrights, trademarks and other information pertaining to this LizardTech software.&#xA;&#xA; Click any link below for more information&#xA; &#xA;&#xA;&#xA; About LizardTech Other LizardTech Products Copyrights, Trademarks and Credits\" /><Url Source=\"../content/about_lizardtech.htm\" Title=\"About LizardTech\" Abstract=\"Since 1992, LizardTech has delivered state-of-the-art software products for managing and distributing massive, high-resolution geospatial data such as aerial and satellite imagery and LiDAR data. LizardTech pioneered the MrSID® technology, a powerful wavelet-based image encoder, viewer, and file ...\" /><Url Source=\"../content/other_lizardtech_products.htm\" Title=\"Other LizardTech Products\" Abstract=\"Thank you for using LizardTech® software. We at LizardTech are glad to have you as a customer. While you’re “in the shop,” explore LizardTech’s other products for managing high-quality geospatial images and LiDAR data. GeoViewer   Efficient Viewing and Exporting of MrSID and JPEG 2000 Layers ...\" /><Url Source=\"../content/printed_copyright_page.htm\" Title=\"Printed Copyright Page\" Abstract=\"Copyright © 2009–2015 Celartem, Inc., doing business as LizardTech. All rights reserved. Information in this document is subject to change without notice. The software described in this document is furnished under a license agreement or nondisclosure agreement. The software may be used or copied ...\" /><Url Source=\"../content/glossary.htm\" Title=\"Glossary\" Abstract=\"Following are descriptions of some terms, phrases and acronyms used in this documentation that you may not be familiar with. Background color&#xA;&#xA; The pixel value that defines the color of the image outside the pixel extents of the image. This property is most often used in mosaicking. See also &quot;Nodata ...\" /><Url Source=\"../content/reference_manual.htm\" Title=\"Reference Manual\" Abstract=\"Reference Manual  The  Reference Manual , containing detailed information about each class and method, can be found at doc/ReferenceManual/index.html.\" /></urls><ents><stem n=\"introduct\" chunk=\"Search_Chunk1.xml\" /><stem n=\"welcom\" chunk=\"Search_Chunk1.xml\" /><stem n=\"mrsid\" chunk=\"Search_Chunk1.xml\" /><stem n=\"®\" chunk=\"Search_Chunk1.xml\" /><stem n=\"softwar\" chunk=\"Search_Chunk1.xml\" /><stem n=\"develop\" chunk=\"Search_Chunk1.xml\" /><stem n=\"kit\" chunk=\"Search_Chunk1.xml\" /><stem n=\"sdk\" chunk=\"Search_Chunk1.xml\" /><stem n=\"raster\" chunk=\"Search_Chunk1.xml\" /><stem n=\"imageri\" chunk=\"Search_Chunk1.xml\" /><stem n=\"document\" chunk=\"Search_Chunk1.xml\" /><stem n=\"decod\" chunk=\"Search_Chunk1.xml\" /><stem n=\"version\" chunk=\"Search_Chunk1.xml\" /><stem n=\"dsdk\" chunk=\"Search_Chunk1.xml\" /><stem n=\"digit\" chunk=\"Search_Chunk1.xml\" /><stem n=\"imag\" chunk=\"Search_Chunk1.xml\" /><stem n=\"becom\" chunk=\"Search_Chunk2.xml\" /><stem n=\"import\" chunk=\"Search_Chunk2.xml\" /><stem n=\"everi\" chunk=\"Search_Chunk2.xml\" /><stem n=\"aspect\" chunk=\"Search_Chunk2.xml\" /><stem n=\"busi\" chunk=\"Search_Chunk2.xml\" /><stem n=\"industri\" chunk=\"Search_Chunk2.xml\" /><stem n=\"govern\" chunk=\"Search_Chunk2.xml\" /><stem n=\"enorm\" chunk=\"Search_Chunk2.xml\" /><stem n=\"amount\" chunk=\"Search_Chunk2.xml\" /><stem n=\"data\" chunk=\"Search_Chunk2.xml\" /><stem n=\"involv\" chunk=\"Search_Chunk2.xml\" /><stem n=\"high\" chunk=\"Search_Chunk2.xml\" /><stem n=\"qualiti\" chunk=\"Search_Chunk2.xml\" /><stem n=\"hinder\" chunk=\"Search_Chunk2.xml\" /><stem n=\"storag\" chunk=\"Search_Chunk2.xml\" /><stem n=\"bandwidth\" chunk=\"Search_Chunk2.xml\" /><stem n=\"constraint\" chunk=\"Search_Chunk2.xml\" /><stem n=\"lizardtech\" chunk=\"Search_Chunk2.xml\" /><stem n=\"technolog\" chunk=\"Search_Chunk2.xml\" /><stem n=\"product\" chunk=\"Search_Chunk2.xml\" /><stem n=\"solv\" chunk=\"Search_Chunk2.xml\" /><stem n=\"problem\" chunk=\"Search_Chunk2.xml\" /><stem n=\"lay\" chunk=\"Search_Chunk2.xml\" /><stem n=\"foundat\" chunk=\"Search_Chunk2.xml\" /><stem n=\"truli\" chunk=\"Search_Chunk2.xml\" /><stem n=\"dynam\" chunk=\"Search_Chunk2.xml\" /><stem n=\"access\" chunk=\"Search_Chunk2.xml\" /><stem n=\"use\" chunk=\"Search_Chunk2.xml\" /><stem n=\"s\" chunk=\"Search_Chunk2.xml\" /><stem n=\"geospati\" chunk=\"Search_Chunk2.xml\" /><stem n=\"includ\" chunk=\"Search_Chunk2.xml\" /><stem n=\"geoexpress\" chunk=\"Search_Chunk2.xml\" /><stem n=\"expressserv\" chunk=\"Search_Chunk2.xml\" /><stem n=\"expressview\" chunk=\"Search_Chunk2.xml\" /><stem n=\"browser\" chunk=\"Search_Chunk2.xml\" /><stem n=\"plug\" chunk=\"Search_Chunk2.xml\" /><stem n=\"applic\" chunk=\"Search_Chunk2.xml\" /><stem n=\"robust\" chunk=\"Search_Chunk3.xml\" /><stem n=\"toolkit\" chunk=\"Search_Chunk3.xml\" /><stem n=\"suitabl\" chunk=\"Search_Chunk3.xml\" /><stem n=\"complex\" chunk=\"Search_Chunk3.xml\" /><stem n=\"need\" chunk=\"Search_Chunk3.xml\" /><stem n=\"provid\" chunk=\"Search_Chunk3.xml\" /><stem n=\"framework\" chunk=\"Search_Chunk3.xml\" /><stem n=\"creat\" chunk=\"Search_Chunk3.xml\" /><stem n=\"pipelin\" chunk=\"Search_Chunk3.xml\" /><stem n=\"enabl\" chunk=\"Search_Chunk3.xml\" /><stem n=\"effici\" chunk=\"Search_Chunk3.xml\" /><stem n=\"read\" chunk=\"Search_Chunk3.xml\" /><stem n=\"write\" chunk=\"Search_Chunk3.xml\" /><stem n=\"manipul\" chunk=\"Search_Chunk3.xml\" /><stem n=\"varieti\" chunk=\"Search_Chunk3.xml\" /><stem n=\"format\" chunk=\"Search_Chunk3.xml\" /><stem n=\"jpeg\" chunk=\"Search_Chunk3.xml\" /><stem n=\"2000\" chunk=\"Search_Chunk3.xml\" /><stem n=\"common\" chunk=\"Search_Chunk3.xml\" /><stem n=\"doe\" chunk=\"Search_Chunk3.xml\" /><stem n=\"support\" chunk=\"Search_Chunk3.xml\" /><stem n=\"sid\" chunk=\"Search_Chunk3.xml\" /><stem n=\"jp2\" chunk=\"Search_Chunk3.xml\" /><stem n=\"inform\" chunk=\"Search_Chunk4.xml\" /><stem n=\"kind\" chunk=\"Search_Chunk4.xml\" /><stem n=\"contact\" chunk=\"Search_Chunk4.xml\" /><stem n=\"region\" chunk=\"Search_Chunk4.xml\" /><stem n=\"offic\" chunk=\"Search_Chunk4.xml\" /><stem n=\"lidar\" chunk=\"Search_Chunk4.xml\" /><stem n=\"well\" chunk=\"Search_Chunk4.xml\" /><stem n=\"separ\" chunk=\"Search_Chunk4.xml\" /><stem n=\"set\" chunk=\"Search_Chunk4.xml\" /><stem n=\"tool\" chunk=\"Search_Chunk4.xml\" /><stem n=\"librari\" chunk=\"Search_Chunk4.xml\" /><stem n=\"avail\" chunk=\"Search_Chunk4.xml\" /><stem n=\"instal\" chunk=\"Search_Chunk4.xml\" /><stem n=\"integr\" chunk=\"Search_Chunk4.xml\" /><stem n=\"encod\" chunk=\"Search_Chunk4.xml\" /><stem n=\"file\" chunk=\"Search_Chunk4.xml\" /><stem n=\"pdf\" chunk=\"Search_Chunk4.xml\" /><stem n=\"copi\" chunk=\"Search_Chunk4.xml\" /><stem n=\"end\" chunk=\"Search_Chunk4.xml\" /><stem n=\"user\" chunk=\"Search_Chunk4.xml\" /><stem n=\"licens\" chunk=\"Search_Chunk4.xml\" /><stem n=\"agreement\" chunk=\"Search_Chunk4.xml\" /><stem n=\"eula\" chunk=\"Search_Chunk4.xml\" /><stem n=\"readm\" chunk=\"Search_Chunk4.xml\" /><stem n=\"copyright\" chunk=\"Search_Chunk4.xml\" /><stem n=\"click\" chunk=\"Search_Chunk4.xml\" /><stem n=\"here\" chunk=\"Search_Chunk4.xml\" /><stem n=\"uniqu\" chunk=\"Search_Chunk4.xml\" /><stem n=\"enhanc\" chunk=\"Search_Chunk4.xml\" /><stem n=\"workflow\" chunk=\"Search_Chunk4.xml\" /><stem n=\"compress\" chunk=\"Search_Chunk4.xml\" /><stem n=\"resolut\" chunk=\"Search_Chunk4.xml\" /><stem n=\"fraction\" chunk=\"Search_Chunk5.xml\" /><stem n=\"origin\" chunk=\"Search_Chunk5.xml\" /><stem n=\"size\" chunk=\"Search_Chunk5.xml\" /><stem n=\"while\" chunk=\"Search_Chunk5.xml\" /><stem n=\"maintain\" chunk=\"Search_Chunk5.xml\" /><stem n=\"scalabl\" chunk=\"Search_Chunk5.xml\" /><stem n=\"reduc\" chunk=\"Search_Chunk5.xml\" /><stem n=\"enlarg\" chunk=\"Search_Chunk5.xml\" /><stem n=\"zoom\" chunk=\"Search_Chunk5.xml\" /><stem n=\"pan\" chunk=\"Search_Chunk5.xml\" /><stem n=\"print\" chunk=\"Search_Chunk5.xml\" /><stem n=\"without\" chunk=\"Search_Chunk5.xml\" /><stem n=\"compromis\" chunk=\"Search_Chunk5.xml\" /><stem n=\"select\" chunk=\"Search_Chunk5.xml\" /><stem n=\"capabl\" chunk=\"Search_Chunk5.xml\" /><stem n=\"view\" chunk=\"Search_Chunk5.xml\" /><stem n=\"ani\" chunk=\"Search_Chunk5.xml\" /><stem n=\"differ\" chunk=\"Search_Chunk5.xml\" /><stem n=\"optim\" chunk=\"Search_Chunk5.xml\" /><stem n=\"give\" chunk=\"Search_Chunk5.xml\" /><stem n=\"flexibl\" chunk=\"Search_Chunk5.xml\" /><stem n=\"deliv\" chunk=\"Search_Chunk5.xml\" /><stem n=\"resourc\" chunk=\"Search_Chunk5.xml\" /><stem n=\"mainstay\" chunk=\"Search_Chunk5.xml\" /><stem n=\"communiti\" chunk=\"Search_Chunk5.xml\" /><stem n=\"year\" chunk=\"Search_Chunk5.xml\" /><stem n=\"implement\" chunk=\"Search_Chunk5.xml\" /><stem n=\"hundr\" chunk=\"Search_Chunk5.xml\" /><stem n=\"latest\" chunk=\"Search_Chunk5.xml\" /><stem n=\"generat\" chunk=\"Search_Chunk5.xml\" /><stem n=\"4\" chunk=\"Search_Chunk5.xml\" /><stem n=\"mg4\" chunk=\"Search_Chunk5.xml\" /><stem n=\"band\" chunk=\"Search_Chunk5.xml\" /><stem n=\"critic\" chunk=\"Search_Chunk5.xml\" /><stem n=\"if\" chunk=\"Search_Chunk5.xml\" /><stem n=\"be\" chunk=\"Search_Chunk5.xml\" /><stem n=\"multispectr\" chunk=\"Search_Chunk5.xml\" /><stem n=\"multi\" chunk=\"Search_Chunk5.xml\" /><stem n=\"hyperspectr\" chunk=\"Search_Chunk5.xml\" /><stem n=\"don\'t\" chunk=\"Search_Chunk5.xml\" /><stem n=\"wish\" chunk=\"Search_Chunk5.xml\" /><stem n=\"onc\" chunk=\"Search_Chunk5.xml\" /><stem n=\"so\" chunk=\"Search_Chunk5.xml\" /><stem n=\"them\" chunk=\"Search_Chunk5.xml\" /><stem n=\"mean\" chunk=\"Search_Chunk5.xml\" /><stem n=\"will\" chunk=\"Search_Chunk5.xml\" /><stem n=\"save\" chunk=\"Search_Chunk6.xml\" /><stem n=\"time\" chunk=\"Search_Chunk6.xml\" /><stem n=\"better\" chunk=\"Search_Chunk6.xml\" /><stem n=\"experi\" chunk=\"Search_Chunk6.xml\" /><stem n=\"standard\" chunk=\"Search_Chunk6.xml\" /><stem n=\"offer\" chunk=\"Search_Chunk6.xml\" /><stem n=\"same\" chunk=\"Search_Chunk6.xml\" /><stem n=\"advantag\" chunk=\"Search_Chunk6.xml\" /><stem n=\"plus\" chunk=\"Search_Chunk6.xml\" /><stem n=\"ad\" chunk=\"Search_Chunk6.xml\" /><stem n=\"benefit\" chunk=\"Search_Chunk6.xml\" /><stem n=\"intern\" chunk=\"Search_Chunk6.xml\" /><stem n=\"iso\" chunk=\"Search_Chunk6.xml\" /><stem n=\"iec\" chunk=\"Search_Chunk6.xml\" /><stem n=\"15444\" chunk=\"Search_Chunk6.xml\" /><stem n=\"allow\" chunk=\"Search_Chunk6.xml\" /><stem n=\"level\" chunk=\"Search_Chunk6.xml\" /><stem n=\"metadata\" chunk=\"Search_Chunk6.xml\" /><stem n=\"larg\" chunk=\"Search_Chunk6.xml\" /><stem n=\"alreadi\" chunk=\"Search_Chunk6.xml\" /><stem n=\"featur\" chunk=\"Search_Chunk6.xml\" /><stem n=\"written\" chunk=\"Search_Chunk6.xml\" /><stem n=\"c++\" chunk=\"Search_Chunk6.xml\" /><stem n=\"object\" chunk=\"Search_Chunk6.xml\" /><stem n=\"orient\" chunk=\"Search_Chunk6.xml\" /><stem n=\"work\" chunk=\"Search_Chunk6.xml\" /><stem n=\"major\" chunk=\"Search_Chunk6.xml\" /><stem n=\"architectur\" chunk=\"Search_Chunk6.xml\" /><stem n=\"classic\" chunk=\"Search_Chunk6.xml\" /><stem n=\"design\" chunk=\"Search_Chunk6.xml\" /><stem n=\"singl\" chunk=\"Search_Chunk6.xml\" /><stem n=\"unifi\" chunk=\"Search_Chunk6.xml\" /><stem n=\"model\" chunk=\"Search_Chunk6.xml\" /><stem n=\"transform\" chunk=\"Search_Chunk6.xml\" /><stem n=\"easili\" chunk=\"Search_Chunk6.xml\" /><stem n=\"exist\" chunk=\"Search_Chunk6.xml\" /><stem n=\"compon\" chunk=\"Search_Chunk6.xml\" /><stem n=\"deriv\" chunk=\"Search_Chunk6.xml\" /><stem n=\"own\" chunk=\"Search_Chunk6.xml\" /><stem n=\"addit\" chunk=\"Search_Chunk6.xml\" /><stem n=\"function\" chunk=\"Search_Chunk6.xml\" /><stem n=\"class\" chunk=\"Search_Chunk6.xml\" /><stem n=\"basic\" chunk=\"Search_Chunk7.xml\" /><stem n=\"represent\" chunk=\"Search_Chunk7.xml\" /><stem n=\"scene\" chunk=\"Search_Chunk7.xml\" /><stem n=\"extent\" chunk=\"Search_Chunk7.xml\" /><stem n=\"memori\" chunk=\"Search_Chunk7.xml\" /><stem n=\"buffer\" chunk=\"Search_Chunk7.xml\" /><stem n=\"pixel\" chunk=\"Search_Chunk7.xml\" /><stem n=\"etc\" chunk=\"Search_Chunk7.xml\" /><stem n=\"full\" chunk=\"Search_Chunk7.xml\" /><stem n=\"2\" chunk=\"Search_Chunk7.xml\" /><stem n=\"mg2\" chunk=\"Search_Chunk7.xml\" /><stem n=\"3\" chunk=\"Search_Chunk7.xml\" /><stem n=\"mg3\" chunk=\"Search_Chunk7.xml\" /><stem n=\"abil\" chunk=\"Search_Chunk7.xml\" /><stem n=\"composit\" chunk=\"Search_Chunk7.xml\" /><stem n=\"oper\" chunk=\"Search_Chunk7.xml\" /><stem n=\"nitf\" chunk=\"Search_Chunk7.xml\" /><stem n=\"wkts\" chunk=\"Search_Chunk7.xml\" /><stem n=\"spatial\" chunk=\"Search_Chunk7.xml\" /><stem n=\"refer\" chunk=\"Search_Chunk7.xml\" /><stem n=\"system\" chunk=\"Search_Chunk7.xml\" /><stem n=\"georeferenc\" chunk=\"Search_Chunk8.xml\" /><stem n=\"simpl\" chunk=\"Search_Chunk8.xml\" /><stem n=\"c\" chunk=\"Search_Chunk8.xml\" /><stem n=\"api\" chunk=\"Search_Chunk8.xml\" /><stem n=\"those\" chunk=\"Search_Chunk8.xml\" /><stem n=\"want\" chunk=\"Search_Chunk8.xml\" /><stem n=\"rudimentari\" chunk=\"Search_Chunk8.xml\" /><stem n=\"interfac\" chunk=\"Search_Chunk8.xml\" /><stem n=\"limit\" chunk=\"Search_Chunk8.xml\" /><stem n=\"properti\" chunk=\"Search_Chunk8.xml\" /><stem n=\"writer\" chunk=\"Search_Chunk8.xml\" /><stem n=\"number\" chunk=\"Search_Chunk8.xml\" /><stem n=\"bip\" chunk=\"Search_Chunk8.xml\" /><stem n=\"bil\" chunk=\"Search_Chunk8.xml\" /><stem n=\"bsq\" chunk=\"Search_Chunk8.xml\" /><stem n=\"raw\" chunk=\"Search_Chunk8.xml\" /><stem n=\"window\" chunk=\"Search_Chunk8.xml\" /><stem n=\"bmp\" chunk=\"Search_Chunk8.xml\" /><stem n=\"tiff\" chunk=\"Search_Chunk8.xml\" /><stem n=\"geotiff\" chunk=\"Search_Chunk8.xml\" /><stem n=\"filter\" chunk=\"Search_Chunk8.xml\" /><stem n=\"crop\" chunk=\"Search_Chunk8.xml\" /><stem n=\"watermark\" chunk=\"Search_Chunk8.xml\" /><stem n=\"mosaick\" chunk=\"Search_Chunk8.xml\" /><stem n=\"scale\" chunk=\"Search_Chunk8.xml\" /><stem n=\"rang\" chunk=\"Search_Chunk8.xml\" /><stem n=\"adjust\" chunk=\"Search_Chunk8.xml\" /><stem n=\"datatyp\" chunk=\"Search_Chunk8.xml\" /><stem n=\"convers\" chunk=\"Search_Chunk8.xml\" /><stem n=\"colorspac\" chunk=\"Search_Chunk8.xml\" /><stem n=\"both\" chunk=\"Search_Chunk8.xml\" /><stem n=\"manual\" chunk=\"Search_Chunk8.xml\" /><stem n=\"exampl\" chunk=\"Search_Chunk8.xml\" /><stem n=\"show\" chunk=\"Search_Chunk9.xml\" /><stem n=\"how\" chunk=\"Search_Chunk9.xml\" /><stem n=\"task\" chunk=\"Search_Chunk9.xml\" /><stem n=\"platform\" chunk=\"Search_Chunk9.xml\" /><stem n=\"linux\" chunk=\"Search_Chunk9.xml\" /><stem n=\"x86\" chunk=\"Search_Chunk9.xml\" /><stem n=\"mac\" chunk=\"Search_Chunk9.xml\" /><stem n=\"os\" chunk=\"Search_Chunk9.xml\" /><stem n=\"x\" chunk=\"Search_Chunk9.xml\" /><stem n=\"dlls\" chunk=\"Search_Chunk9.xml\" /><stem n=\"32\" chunk=\"Search_Chunk9.xml\" /><stem n=\"64\" chunk=\"Search_Chunk9.xml\" /><stem n=\"bit\" chunk=\"Search_Chunk9.xml\" /><stem n=\"interoper\" chunk=\"Search_Chunk9.xml\" /><stem n=\"public\" chunk=\"Search_Chunk9.xml\" /><stem n=\"code\" chunk=\"Search_Chunk9.xml\" /><stem n=\"clean\" chunk=\"Search_Chunk9.xml\" /><stem n=\"subset\" chunk=\"Search_Chunk9.xml\" /><stem n=\"languag\" chunk=\"Search_Chunk9.xml\" /><stem n=\"avoid\" chunk=\"Search_Chunk9.xml\" /><stem n=\"often\" chunk=\"Search_Chunk9.xml\" /><stem n=\"encount\" chunk=\"Search_Chunk9.xml\" /><stem n=\"stl\" chunk=\"Search_Chunk9.xml\" /><stem n=\"incompat\" chunk=\"Search_Chunk9.xml\" /><stem n=\"except\" chunk=\"Search_Chunk9.xml\" /><stem n=\"alloc\" chunk=\"Search_Chunk9.xml\" /><stem n=\"cross\" chunk=\"Search_Chunk9.xml\" /><stem n=\"boundari\" chunk=\"Search_Chunk9.xml\" /><stem n=\"advanc\" chunk=\"Search_Chunk9.xml\" /><stem n=\"templat\" chunk=\"Search_Chunk9.xml\" /><stem n=\"compil\" chunk=\"Search_Chunk9.xml\" /><stem n=\"make\" chunk=\"Search_Chunk9.xml\" /><stem n=\"up\" chunk=\"Search_Chunk9.xml\" /><stem n=\"chapter\" chunk=\"Search_Chunk9.xml\" /><stem n=\"describ\" chunk=\"Search_Chunk9.xml\" /><stem n=\"overal\" chunk=\"Search_Chunk9.xml\" /><stem n=\"strip\" chunk=\"Search_Chunk9.xml\" /><stem n=\"base\" chunk=\"Search_Chunk9.xml\" /><stem n=\"mechan\" chunk=\"Search_Chunk9.xml\" /><stem n=\"further\" chunk=\"Search_Chunk9.xml\" /><stem n=\"briefli\" chunk=\"Search_Chunk9.xml\" /><stem n=\"motiv\" chunk=\"Search_Chunk9.xml\" /><stem n=\"various\" chunk=\"Search_Chunk9.xml\" /><stem n=\"note\" chunk=\"Search_Chunk9.xml\" /><stem n=\"descript\" chunk=\"Search_Chunk9.xml\" /><stem n=\"introduc\" chunk=\"Search_Chunk9.xml\" /><stem n=\"detail\" chunk=\"Search_Chunk9.xml\" /><stem n=\"specif\" chunk=\"Search_Chunk9.xml\" /><stem n=\"method\" chunk=\"Search_Chunk9.xml\" /><stem n=\"pleas\" chunk=\"Search_Chunk9.xml\" /><stem n=\"command\" chunk=\"Search_Chunk9.xml\" /><stem n=\"line\" chunk=\"Search_Chunk9.xml\" /><stem n=\"glossari\" chunk=\"Search_Chunk9.xml\" /><stem n=\"appendix\" chunk=\"Search_Chunk9.xml\" /><stem n=\"technic\" chunk=\"Search_Chunk9.xml\" /><stem n=\"explain\" chunk=\"Search_Chunk10.xml\" /><stem n=\"minutia\" chunk=\"Search_Chunk10.xml\" /><stem n=\"might\" chunk=\"Search_Chunk10.xml\" /><stem n=\"curious\" chunk=\"Search_Chunk10.xml\" /><stem n=\"content\" chunk=\"Search_Chunk10.xml\" /><stem n=\"follow\" chunk=\"Search_Chunk10.xml\" /><stem n=\"cover\" chunk=\"Search_Chunk10.xml\" /><stem n=\"top\" chunk=\"Search_Chunk10.xml\" /><stem n=\"directori\" chunk=\"Search_Chunk10.xml\" /><stem n=\"txt\" chunk=\"Search_Chunk10.xml\" /><stem n=\"chang\" chunk=\"Search_Chunk10.xml\" /><stem n=\"contain\" chunk=\"Search_Chunk10.xml\" /><stem n=\"complet\" chunk=\"Search_Chunk10.xml\" /><stem n=\"doc\" chunk=\"Search_Chunk10.xml\" /><stem n=\"usermanu\" chunk=\"Search_Chunk10.xml\" /><stem n=\"index\" chunk=\"Search_Chunk10.xml\" /><stem n=\"htm\" chunk=\"Search_Chunk10.xml\" /><stem n=\"referencemanu\" chunk=\"Search_Chunk10.xml\" /><stem n=\"html\" chunk=\"Search_Chunk10.xml\" /><stem n=\"header\" chunk=\"Search_Chunk10.xml\" /><stem n=\"locat\" chunk=\"Search_Chunk10.xml\" /><stem n=\"lib\" chunk=\"Search_Chunk10.xml\" /><stem n=\"suppli\" chunk=\"Search_Chunk10.xml\" /><stem n=\"3rd\" chunk=\"Search_Chunk10.xml\" /><stem n=\"parti\" chunk=\"Search_Chunk10.xml\" /><stem n=\"sampl\" chunk=\"Search_Chunk10.xml\" /><stem n=\"bin\" chunk=\"Search_Chunk10.xml\" /><stem n=\"aid\" chunk=\"Search_Chunk10.xml\" /><stem n=\"debug\" chunk=\"Search_Chunk10.xml\" /><stem n=\"test\" chunk=\"Search_Chunk10.xml\" /><stem n=\"src\" chunk=\"Search_Chunk10.xml\" /><stem n=\"get\" chunk=\"Search_Chunk10.xml\" /><stem n=\"start\" chunk=\"Search_Chunk10.xml\" /><stem n=\"preliminari\" chunk=\"Search_Chunk10.xml\" /><stem n=\"least\" chunk=\"Search_Chunk10.xml\" /><stem n=\"suggest\" chunk=\"Search_Chunk10.xml\" /><stem n=\"skim\" chunk=\"Search_Chunk10.xml\" /><stem n=\"accompani\" chunk=\"Search_Chunk10.xml\" /><stem n=\"build\" chunk=\"Search_Chunk10.xml\" /><stem n=\"execut\" chunk=\"Search_Chunk10.xml\" /><stem n=\"sourc\" chunk=\"Search_Chunk10.xml\" /><stem n=\"should\" chunk=\"Search_Chunk10.xml\" /><stem n=\"enough\" chunk=\"Search_Chunk10.xml\" /><stem n=\"determin\" chunk=\"Search_Chunk10.xml\" /><stem n=\"what\" chunk=\"Search_Chunk10.xml\" /><stem n=\"requir\" chunk=\"Search_Chunk10.xml\" /><stem n=\"point\" chunk=\"Search_Chunk10.xml\" /><stem n=\"go\" chunk=\"Search_Chunk10.xml\" /><stem n=\"back\" chunk=\"Search_Chunk10.xml\" /><stem n=\"reread\" chunk=\"Search_Chunk10.xml\" /><stem n=\"close\" chunk=\"Search_Chunk10.xml\" /><stem n=\"focus\" chunk=\"Search_Chunk10.xml\" /><stem n=\"area\" chunk=\"Search_Chunk10.xml\" /><stem n=\"appropri\" chunk=\"Search_Chunk10.xml\" /><stem n=\"situat\" chunk=\"Search_Chunk10.xml\" /><stem n=\"compat\" chunk=\"Search_Chunk10.xml\" /><stem n=\"previous\" chunk=\"Search_Chunk10.xml\" /><stem n=\"7\" chunk=\"Search_Chunk10.xml\" /><stem n=\"seri\" chunk=\"Search_Chunk10.xml\" /><stem n=\"releas\" chunk=\"Search_Chunk10.xml\" /><stem n=\"call\" chunk=\"Search_Chunk10.xml\" /><stem n=\"must\" chunk=\"Search_Chunk10.xml\" /><stem n=\"conjunct\" chunk=\"Search_Chunk10.xml\" /><stem n=\"environ\" chunk=\"Search_Chunk10.xml\" /><stem n=\"configur\" chunk=\"Search_Chunk10.xml\" /><stem n=\"list\" chunk=\"Search_Chunk10.xml\" /><stem n=\"below\" chunk=\"Search_Chunk11.xml\" /><stem n=\"perform\" chunk=\"Search_Chunk11.xml\" /><stem n=\"verifi\" chunk=\"Search_Chunk11.xml\" /><stem n=\"meet\" chunk=\"Search_Chunk11.xml\" /><stem n=\"minimum\" chunk=\"Search_Chunk11.xml\" /><stem n=\"recommend\" chunk=\"Search_Chunk11.xml\" /><stem n=\"hardwar\" chunk=\"Search_Chunk11.xml\" /><stem n=\"ghz\" chunk=\"Search_Chunk11.xml\" /><stem n=\"processor\" chunk=\"Search_Chunk11.xml\" /><stem n=\"gb\" chunk=\"Search_Chunk11.xml\" /><stem n=\"ram\" chunk=\"Search_Chunk11.xml\" /><stem n=\"distribut\" chunk=\"Search_Chunk11.xml\" /><stem n=\"target\" chunk=\"Search_Chunk11.xml\" /><stem n=\"visual\" chunk=\"Search_Chunk11.xml\" /><stem n=\"studio\" chunk=\"Search_Chunk11.xml\" /><stem n=\"2017\" chunk=\"Search_Chunk11.xml\" /><stem n=\"server\" chunk=\"Search_Chunk11.xml\" /><stem n=\"2008\" chunk=\"Search_Chunk11.xml\" /><stem n=\"newer\" chunk=\"Search_Chunk11.xml\" /><stem n=\"8\" chunk=\"Search_Chunk11.xml\" /><stem n=\"10\" chunk=\"Search_Chunk11.xml\" /><stem n=\"2012\" chunk=\"Search_Chunk11.xml\" /><stem n=\"2016\" chunk=\"Search_Chunk11.xml\" /><stem n=\"14\" chunk=\"Search_Chunk11.xml\" /><stem n=\"0\" chunk=\"Search_Chunk11.xml\" /><stem n=\"vc14\" chunk=\"Search_Chunk11.xml\" /><stem n=\"updat\" chunk=\"Search_Chunk11.xml\" /><stem n=\"greater\" chunk=\"Search_Chunk11.xml\" /><stem n=\"2015\" chunk=\"Search_Chunk11.xml\" /><stem n=\"2013\" chunk=\"Search_Chunk11.xml\" /><stem n=\"vista\" chunk=\"Search_Chunk11.xml\" /><stem n=\"2003\" chunk=\"Search_Chunk11.xml\" /><stem n=\"12\" chunk=\"Search_Chunk11.xml\" /><stem n=\"vc12\" chunk=\"Search_Chunk11.xml\" /><stem n=\"gcc\" chunk=\"Search_Chunk11.xml\" /><stem n=\"5\" chunk=\"Search_Chunk11.xml\" /><stem n=\"1\" chunk=\"Search_Chunk11.xml\" /><stem n=\"rhel\" chunk=\"Search_Chunk11.xml\" /><stem n=\"6\" chunk=\"Search_Chunk11.xml\" /><stem n=\"cento\" chunk=\"Search_Chunk11.xml\" /><stem n=\"red\" chunk=\"Search_Chunk11.xml\" /><stem n=\"hat\" chunk=\"Search_Chunk11.xml\" /><stem n=\"built\" chunk=\"Search_Chunk11.xml\" /><stem n=\"toolset\" chunk=\"Search_Chunk11.xml\" /><stem n=\"enterpris\" chunk=\"Search_Chunk11.xml\" /><stem n=\"collect\" chunk=\"Search_Chunk11.xml\" /><stem n=\"macintosh\" chunk=\"Search_Chunk11.xml\" /><stem n=\"clang\" chunk=\"Search_Chunk11.xml\" /><stem n=\"part\" chunk=\"Search_Chunk11.xml\" /><stem n=\"xcode\" chunk=\"Search_Chunk11.xml\" /><stem n=\"maco\" chunk=\"Search_Chunk11.xml\" /><stem n=\"univers\" chunk=\"Search_Chunk11.xml\" /><stem n=\"darwin\" chunk=\"Search_Chunk11.xml\" /><stem n=\"16\" chunk=\"Search_Chunk11.xml\" /><stem n=\"11\" chunk=\"Search_Chunk11.xml\" /><stem n=\"15\" chunk=\"Search_Chunk11.xml\" /><stem n=\"io\" chunk=\"Search_Chunk11.xml\" /><stem n=\"higher\" chunk=\"Search_Chunk11.xml\" /><stem n=\"armv7\" chunk=\"Search_Chunk11.xml\" /><stem n=\"arm64\" chunk=\"Search_Chunk11.xml\" /><stem n=\"simul\" chunk=\"Search_Chunk11.xml\" /><stem n=\"android\" chunk=\"Search_Chunk11.xml\" /><stem n=\"ndk\" chunk=\"Search_Chunk11.xml\" /><stem n=\"13b\" chunk=\"Search_Chunk11.xml\" /><stem n=\"ubuntu\" chunk=\"Search_Chunk11.xml\" /><stem n=\"desktop\" chunk=\"Search_Chunk11.xml\" /><stem n=\"04\" chunk=\"Search_Chunk11.xml\" /><stem n=\"armeabi\" chunk=\"Search_Chunk11.xml\" /><stem n=\"v7a\" chunk=\"Search_Chunk11.xml\" /><stem n=\"v8a\" chunk=\"Search_Chunk11.xml\" /><stem n=\"x86_64\" chunk=\"Search_Chunk11.xml\" /><stem n=\"9\" chunk=\"Search_Chunk11.xml\" /><stem n=\"beyond\" chunk=\"Search_Chunk12.xml\" /><stem n=\"media\" chunk=\"Search_Chunk12.xml\" /><stem n=\"cd\" chunk=\"Search_Chunk12.xml\" /><stem n=\"archiv\" chunk=\"Search_Chunk12.xml\" /><stem n=\"ftp\" chunk=\"Search_Chunk12.xml\" /><stem n=\"site\" chunk=\"Search_Chunk12.xml\" /><stem n=\"local\" chunk=\"Search_Chunk12.xml\" /><stem n=\"comput\" chunk=\"Search_Chunk12.xml\" /><stem n=\"see\" chunk=\"Search_Chunk12.xml\" /><stem n=\"instruct\" chunk=\"Search_Chunk12.xml\" /><stem n=\"demonstr\" chunk=\"Search_Chunk12.xml\" /><stem n=\"tabl\" chunk=\"Search_Chunk12.xml\" /><stem n=\"consult\" chunk=\"Search_Chunk12.xml\" /><stem n=\"type\" chunk=\"Search_Chunk12.xml\" /><stem n=\"open\" chunk=\"Search_Chunk12.xml\" /><stem n=\"decodejp2tobbb\" chunk=\"Search_Chunk12.xml\" /><stem n=\"cpp\" chunk=\"Search_Chunk12.xml\" /><stem n=\"decodejp2tojpg\" chunk=\"Search_Chunk12.xml\" /><stem n=\"decodejp2tomemori\" chunk=\"Search_Chunk12.xml\" /><stem n=\"decodemrsidbandselect\" chunk=\"Search_Chunk12.xml\" /><stem n=\"decodemrsidtomemori\" chunk=\"Search_Chunk12.xml\" /><stem n=\"decodemrsidtoraw\" chunk=\"Search_Chunk12.xml\" /><stem n=\"decodemrsidtotiff\" chunk=\"Search_Chunk12.xml\" /><stem n=\"decodenitftobbb\" chunk=\"Search_Chunk12.xml\" /><stem n=\"thread\" chunk=\"Search_Chunk12.xml\" /><stem n=\"imageinfo\" chunk=\"Search_Chunk12.xml\" /><stem n=\"metadatadump\" chunk=\"Search_Chunk12.xml\" /><stem n=\"ltiscenebuff\" chunk=\"Search_Chunk12.xml\" /><stem n=\"derivedimagefilt\" chunk=\"Search_Chunk12.xml\" /><stem n=\"convert\" chunk=\"Search_Chunk12.xml\" /><stem n=\"derivedimageread\" chunk=\"Search_Chunk12.xml\" /><stem n=\"derivedimagewrit\" chunk=\"Search_Chunk12.xml\" /><stem n=\"sub\" chunk=\"Search_Chunk12.xml\" /><stem n=\"scenebuff\" chunk=\"Search_Chunk12.xml\" /><stem n=\"alpha\" chunk=\"Search_Chunk12.xml\" /><stem n=\"custom\" chunk=\"Search_Chunk12.xml\" /><stem n=\"progress\" chunk=\"Search_Chunk12.xml\" /><stem n=\"interrupt\" chunk=\"Search_Chunk12.xml\" /><stem n=\"deleg\" chunk=\"Search_Chunk12.xml\" /><stem n=\"progressdeleg\" chunk=\"Search_Chunk12.xml\" /><stem n=\"interruptdeleg\" chunk=\"Search_Chunk12.xml\" /><stem n=\"geo\" chunk=\"Search_Chunk12.xml\" /><stem n=\"interest\" chunk=\"Search_Chunk12.xml\" /><stem n=\"ltiscen\" chunk=\"Search_Chunk12.xml\" /><stem n=\"geoscen\" chunk=\"Search_Chunk12.xml\" /><stem n=\"check\" chunk=\"Search_Chunk12.xml\" /><stem n=\"decodemrsidlidar\" chunk=\"Search_Chunk12.xml\" /><stem n=\"look\" chunk=\"Search_Chunk12.xml\" /><stem n=\"error\" chunk=\"Search_Chunk12.xml\" /><stem n=\"messag\" chunk=\"Search_Chunk12.xml\" /><stem n=\"errorhandl\" chunk=\"Search_Chunk12.xml\" /><stem n=\"ltiostreaminf\" chunk=\"Search_Chunk12.xml\" /><stem n=\"derivedstream\" chunk=\"Search_Chunk12.xml\" /><stem n=\"usingstream\" chunk=\"Search_Chunk12.xml\" /><stem n=\"ltiimagestag\" chunk=\"Search_Chunk12.xml\" /><stem n=\"ltiimageread\" chunk=\"Search_Chunk12.xml\" /><stem n=\"ltiimagefilt\" chunk=\"Search_Chunk12.xml\" /><stem n=\"ltiimagewrit\" chunk=\"Search_Chunk12.xml\" /><stem n=\"issu\" chunk=\"Search_Chunk12.xml\" /><stem n=\"resolv\" chunk=\"Search_Chunk12.xml\" /><stem n=\"knowledg\" chunk=\"Search_Chunk12.xml\" /><stem n=\"websit\" chunk=\"Search_Chunk12.xml\" /><stem n=\"http\" chunk=\"Search_Chunk12.xml\" /><stem n=\"www\" chunk=\"Search_Chunk12.xml\" /><stem n=\"com\" chunk=\"Search_Chunk12.xml\" /><stem n=\"kb\" chunk=\"Search_Chunk12.xml\" /><stem n=\"articl\" chunk=\"Search_Chunk12.xml\" /><stem n=\"known\" chunk=\"Search_Chunk12.xml\" /><stem n=\"usag\" chunk=\"Search_Chunk12.xml\" /><stem n=\"frequent\" chunk=\"Search_Chunk12.xml\" /><stem n=\"within\" chunk=\"Search_Chunk12.xml\" /><stem n=\"download\" chunk=\"Search_Chunk12.xml\" /><stem n=\"sdks\" chunk=\"Search_Chunk12.xml\" /><stem n=\"link\" chunk=\"Search_Chunk12.xml\" /><stem n=\"email\" chunk=\"Search_Chunk12.xml\" /><stem n=\"forum\" chunk=\"Search_Chunk12.xml\" /><stem n=\"fora\" chunk=\"Search_Chunk12.xml\" /><stem n=\"place\" chunk=\"Search_Chunk12.xml\" /><stem n=\"engag\" chunk=\"Search_Chunk12.xml\" /><stem n=\"intellig\" chunk=\"Search_Chunk12.xml\" /><stem n=\"discours\" chunk=\"Search_Chunk12.xml\" /><stem n=\"ask\" chunk=\"Search_Chunk12.xml\" /><stem n=\"question\" chunk=\"Search_Chunk12.xml\" /><stem n=\"answer\" chunk=\"Search_Chunk12.xml\" /><stem n=\"share\" chunk=\"Search_Chunk12.xml\" /><stem n=\"tip\" chunk=\"Search_Chunk12.xml\" /><stem n=\"around\" chunk=\"Search_Chunk12.xml\" /><stem n=\"world\" chunk=\"Search_Chunk12.xml\" /><stem n=\"viewer\" chunk=\"Search_Chunk12.xml\" /><stem n=\"cost\" chunk=\"Search_Chunk12.xml\" /><stem n=\"plan\" chunk=\"Search_Chunk12.xml\" /><stem n=\"purchas\" chunk=\"Search_Chunk12.xml\" /><stem n=\"php\" chunk=\"Search_Chunk12.xml\" /><stem n=\"protect\" chunk=\"Search_Chunk12.xml\" /><stem n=\"invest\" chunk=\"Search_Chunk12.xml\" /><stem n=\"particip\" chunk=\"Search_Chunk12.xml\" /><stem n=\"lizarttech\" chunk=\"Search_Chunk12.xml\" /><stem n=\"visit\" chunk=\"Search_Chunk12.xml\" /><stem n=\"abov\" chunk=\"Search_Chunk12.xml\" /><stem n=\"url\" chunk=\"Search_Chunk12.xml\" /><stem n=\"activ\" chunk=\"Search_Chunk12.xml\" /><stem n=\"page\" chunk=\"Search_Chunk12.xml\" /><stem n=\"form\" chunk=\"Search_Chunk12.xml\" /><stem n=\"assist\" chunk=\"Search_Chunk12.xml\" /><stem n=\"emerg\" chunk=\"Search_Chunk12.xml\" /><stem n=\"206\" chunk=\"Search_Chunk13.xml\" /><stem n=\"902\" chunk=\"Search_Chunk13.xml\" /><stem n=\"2845\" chunk=\"Search_Chunk13.xml\" /><stem n=\"hour\" chunk=\"Search_Chunk13.xml\" /><stem n=\"am\" chunk=\"Search_Chunk13.xml\" /><stem n=\"pm\" chunk=\"Search_Chunk13.xml\" /><stem n=\"pacif\" chunk=\"Search_Chunk13.xml\" /><stem n=\"befor\" chunk=\"Search_Chunk13.xml\" /><stem n=\"us\" chunk=\"Search_Chunk13.xml\" /><stem n=\"run\" chunk=\"Search_Chunk13.xml\" /><stem n=\"much\" chunk=\"Search_Chunk13.xml\" /><stem n=\"free\" chunk=\"Search_Chunk13.xml\" /><stem n=\"hard\" chunk=\"Search_Chunk13.xml\" /><stem n=\"drive\" chunk=\"Search_Chunk13.xml\" /><stem n=\"space\" chunk=\"Search_Chunk13.xml\" /><stem n=\"simplifi\" chunk=\"Search_Chunk13.xml\" /><stem n=\"possibl\" chunk=\"Search_Chunk13.xml\" /><stem n=\"relev\" chunk=\"Search_Chunk13.xml\" /><stem n=\"reproduc\" chunk=\"Search_Chunk13.xml\" /><stem n=\"section\" chunk=\"Search_Chunk13.xml\" /><stem n=\"principl\" chunk=\"Search_Chunk13.xml\" /><stem n=\"convent\" chunk=\"Search_Chunk13.xml\" /><stem n=\"main\" chunk=\"Search_Chunk13.xml\" /><stem n=\"subsequ\" chunk=\"Search_Chunk13.xml\" /><stem n=\"consider\" chunk=\"Search_Chunk13.xml\" /><stem n=\"process\" chunk=\"Search_Chunk13.xml\" /><stem n=\"stage\" chunk=\"Search_Chunk13.xml\" /><stem n=\"one\" chunk=\"Search_Chunk13.xml\" /><stem n=\"piec\" chunk=\"Search_Chunk13.xml\" /><stem n=\"pass\" chunk=\"Search_Chunk13.xml\" /><stem n=\"result\" chunk=\"Search_Chunk13.xml\" /><stem n=\"next\" chunk=\"Search_Chunk13.xml\" /><stem n=\"construct\" chunk=\"Search_Chunk13.xml\" /><stem n=\"way\" chunk=\"Search_Chunk13.xml\" /><stem n=\"reader\" chunk=\"Search_Chunk13.xml\" /><stem n=\"three\" chunk=\"Search_Chunk13.xml\" /><stem n=\"extern\" chunk=\"Search_Chunk13.xml\" /><stem n=\"serv\" chunk=\"Search_Chunk13.xml\" /><stem n=\"initi\" chunk=\"Search_Chunk13.xml\" /><stem n=\"successor\" chunk=\"Search_Chunk13.xml\" /><stem n=\"receiv\" chunk=\"Search_Chunk13.xml\" /><stem n=\"predecessor\" chunk=\"Search_Chunk13.xml\" /><stem n=\"new\" chunk=\"Search_Chunk13.xml\" /><stem n=\"combin\" chunk=\"Search_Chunk13.xml\" /><stem n=\"multipl\" chunk=\"Search_Chunk13.xml\" /><stem n=\"histogram\" chunk=\"Search_Chunk13.xml\" /><stem n=\"stretcher\" chunk=\"Search_Chunk13.xml\" /><stem n=\"valu\" chunk=\"Search_Chunk13.xml\" /><stem n=\"numer\" chunk=\"Search_Chunk13.xml\" /><stem n=\"produc\" chunk=\"Search_Chunk13.xml\" /><stem n=\"final\" chunk=\"Search_Chunk13.xml\" /><stem n=\"opposit\" chunk=\"Search_Chunk13.xml\" /><stem n=\"simplest\" chunk=\"Search_Chunk13.xml\" /><stem n=\"consist\" chunk=\"Search_Chunk13.xml\" /><stem n=\"trivial\" chunk=\"Search_Chunk13.xml\" /><stem n=\"just\" chunk=\"Search_Chunk13.xml\" /><stem n=\"connect\" chunk=\"Search_Chunk13.xml\" /><stem n=\"figur\" chunk=\"Search_Chunk13.xml\" /><stem n=\"shown\" chunk=\"Search_Chunk13.xml\" /><stem n=\"given\" chunk=\"Search_Chunk13.xml\" /><stem n=\"filenam\" chunk=\"Search_Chunk13.xml\" /><stem n=\"presum\" chunk=\"Search_Chunk13.xml\" /><stem n=\"rgb\" chunk=\"Search_Chunk13.xml\" /><stem n=\"grayscal\" chunk=\"Search_Chunk13.xml\" /><stem n=\"color\" chunk=\"Search_Chunk14.xml\" /><stem n=\"out\" chunk=\"Search_Chunk14.xml\" /><stem n=\"again\" chunk=\"Search_Chunk14.xml\" /><stem n=\"massag\" chunk=\"Search_Chunk14.xml\" /><stem n=\"display\" chunk=\"Search_Chunk14.xml\" /><stem n=\"two\" chunk=\"Search_Chunk14.xml\" /><stem n=\"turn\" chunk=\"Search_Chunk14.xml\" /><stem n=\"sens\" chunk=\"Search_Chunk14.xml\" /><stem n=\"insert\" chunk=\"Search_Chunk14.xml\" /><stem n=\"onto\" chunk=\"Search_Chunk14.xml\" /><stem n=\"diagram\" chunk=\"Search_Chunk14.xml\" /><stem n=\"structur\" chunk=\"Search_Chunk14.xml\" /><stem n=\"similar\" chunk=\"Search_Chunk14.xml\" /><stem n=\"ltiimag\" chunk=\"Search_Chunk14.xml\" /><stem n=\"abstract\" chunk=\"Search_Chunk14.xml\" /><stem n=\"width\" chunk=\"Search_Chunk14.xml\" /><stem n=\"height\" chunk=\"Search_Chunk14.xml\" /><stem n=\"extend\" chunk=\"Search_Chunk14.xml\" /><stem n=\"constructor\" chunk=\"Search_Chunk14.xml\" /><stem n=\"take\" chunk=\"Search_Chunk14.xml\" /><stem n=\"inherit\" chunk=\"Search_Chunk14.xml\" /><stem n=\"sink\" chunk=\"Search_Chunk14.xml\" /><stem n=\"i\" chunk=\"Search_Chunk14.xml\" /><stem n=\"e\" chunk=\"Search_Chunk14.xml\" /><stem n=\"export\" chunk=\"Search_Chunk14.xml\" /><stem n=\"would\" chunk=\"Search_Chunk14.xml\" /><stem n=\"ltiimagestagemanag\" chunk=\"Search_Chunk14.xml\" /><stem n=\"anoth\" chunk=\"Search_Chunk14.xml\" /><stem n=\"manag\" chunk=\"Search_Chunk14.xml\" /><stem n=\"thought\" chunk=\"Search_Chunk14.xml\" /><stem n=\"array\" chunk=\"Search_Chunk14.xml\" /><stem n=\"certain\" chunk=\"Search_Chunk14.xml\" /><stem n=\"mosaic\" chunk=\"Search_Chunk14.xml\" /><stem n=\"wrap\" chunk=\"Search_Chunk14.xml\" /><stem n=\"hold\" chunk=\"Search_Chunk14.xml\" /><stem n=\"accommod\" chunk=\"Search_Chunk14.xml\" /><stem n=\"gigabyt\" chunk=\"Search_Chunk14.xml\" /><stem n=\"dataset\" chunk=\"Search_Chunk14.xml\" /><stem n=\"horizont\" chunk=\"Search_Chunk14.xml\" /><stem n=\"general\" chunk=\"Search_Chunk14.xml\" /><stem n=\"begin\" chunk=\"Search_Chunk14.xml\" /><stem n=\"foreach\" chunk=\"Search_Chunk14.xml\" /><stem n=\"xxxxx\" chunk=\"Search_Chunk14.xml\" /><stem n=\"done\" chunk=\"Search_Chunk14.xml\" /><stem n=\"phase\" chunk=\"Search_Chunk14.xml\" /><stem n=\"readbegin\" chunk=\"Search_Chunk14.xml\" /><stem n=\"readstrip\" chunk=\"Search_Chunk14.xml\" /><stem n=\"readend\" chunk=\"Search_Chunk14.xml\" /><stem n=\"handl\" chunk=\"Search_Chunk14.xml\" /><stem n=\"logic\" chunk=\"Search_Chunk14.xml\" /><stem n=\"decompos\" chunk=\"Search_Chunk14.xml\" /><stem n=\"sequenti\" chunk=\"Search_Chunk14.xml\" /><stem n=\"correspond\" chunk=\"Search_Chunk14.xml\" /><stem n=\"pure\" chunk=\"Search_Chunk14.xml\" /><stem n=\"virtual\" chunk=\"Search_Chunk14.xml\" /><stem n=\"decodebegin\" chunk=\"Search_Chunk14.xml\" /><stem n=\"decodestrip\" chunk=\"Search_Chunk14.xml\" /><stem n=\"decodeend\" chunk=\"Search_Chunk14.xml\" /><stem n=\"accomplish\" chunk=\"Search_Chunk14.xml\" /><stem n=\"via\" chunk=\"Search_Chunk14.xml\" /><stem n=\"subsect\" chunk=\"Search_Chunk14.xml\" /><stem n=\"intermedi\" chunk=\"Search_Chunk14.xml\" /><stem n=\"entir\" chunk=\"Search_Chunk14.xml\" /><stem n=\"store\" chunk=\"Search_Chunk14.xml\" /><stem n=\"specifi\" chunk=\"Search_Chunk14.xml\" /><stem n=\"typic\" chunk=\"Search_Chunk14.xml\" /><stem n=\"creation\" chunk=\"Search_Chunk14.xml\" /><stem n=\"excess\" chunk=\"Search_Chunk14.xml\" /><stem n=\"clear\" chunk=\"Search_Chunk14.xml\" /><stem n=\"inappropri\" chunk=\"Search_Chunk14.xml\" /><stem n=\"case\" chunk=\"Search_Chunk14.xml\" /><stem n=\"client\" chunk=\"Search_Chunk14.xml\" /><stem n=\"choos\" chunk=\"Search_Chunk14.xml\" /><stem n=\"explicit\" chunk=\"Search_Chunk14.xml\" /><stem n=\"pull\" chunk=\"Search_Chunk14.xml\" /><stem n=\"worth\" chunk=\"Search_Chunk14.xml\" /><stem n=\"resid\" chunk=\"Search_Chunk14.xml\" /><stem n=\"impli\" chunk=\"Search_Chunk14.xml\" /><stem n=\"upper\" chunk=\"Search_Chunk14.xml\" /><stem n=\"left\" chunk=\"Search_Chunk14.xml\" /><stem n=\"y\" chunk=\"Search_Chunk15.xml\" /><stem n=\"posit\" chunk=\"Search_Chunk15.xml\" /><stem n=\"magnif\" chunk=\"Search_Chunk15.xml\" /><stem n=\"express\" chunk=\"Search_Chunk15.xml\" /><stem n=\"relat\" chunk=\"Search_Chunk15.xml\" /><stem n=\"w\" chunk=\"Search_Chunk15.xml\" /><stem n=\"h\" chunk=\"Search_Chunk15.xml\" /><stem n=\"lower\" chunk=\"Search_Chunk15.xml\" /><stem n=\"right\" chunk=\"Search_Chunk15.xml\" /><stem n=\"corner\" chunk=\"Search_Chunk15.xml\" /><stem n=\"term\" chunk=\"Search_Chunk15.xml\" /><stem n=\"repres\" chunk=\"Search_Chunk15.xml\" /><stem n=\"dimens\" chunk=\"Search_Chunk15.xml\" /><stem n=\"output\" chunk=\"Search_Chunk15.xml\" /><stem n=\"float\" chunk=\"Search_Chunk15.xml\" /><stem n=\"downsampl\" chunk=\"Search_Chunk15.xml\" /><stem n=\"half\" chunk=\"Search_Chunk15.xml\" /><stem n=\"upsampl\" chunk=\"Search_Chunk15.xml\" /><stem n=\"twice\" chunk=\"Search_Chunk15.xml\" /><stem n=\"power\" chunk=\"Search_Chunk15.xml\" /><stem n=\"although\" chunk=\"Search_Chunk15.xml\" /><stem n=\"arbitrari\" chunk=\"Search_Chunk15.xml\" /><stem n=\"resampl\" chunk=\"Search_Chunk15.xml\" /><stem n=\"consid\" chunk=\"Search_Chunk15.xml\" /><stem n=\"625x625\" chunk=\"Search_Chunk15.xml\" /><stem n=\"input\" chunk=\"Search_Chunk15.xml\" /><stem n=\"625\" chunk=\"Search_Chunk15.xml\" /><stem n=\"mag\" chunk=\"Search_Chunk15.xml\" /><stem n=\"middl\" chunk=\"Search_Chunk15.xml\" /><stem n=\"rectangl\" chunk=\"Search_Chunk15.xml\" /><stem n=\"200x200\" chunk=\"Search_Chunk15.xml\" /><stem n=\"taken\" chunk=\"Search_Chunk15.xml\" /><stem n=\"200\" chunk=\"Search_Chunk15.xml\" /><stem n=\"inner\" chunk=\"Search_Chunk15.xml\" /><stem n=\"blue\" chunk=\"Search_Chunk15.xml\" /><stem n=\"extract\" chunk=\"Search_Chunk15.xml\" /><stem n=\"footprint\" chunk=\"Search_Chunk15.xml\" /><stem n=\"100x100\" chunk=\"Search_Chunk15.xml\" /><stem n=\"outer\" chunk=\"Search_Chunk15.xml\" /><stem n=\"green\" chunk=\"Search_Chunk15.xml\" /><stem n=\"400x400\" chunk=\"Search_Chunk15.xml\" /><stem n=\"effect\" chunk=\"Search_Chunk15.xml\" /><stem n=\"1250x1250\" chunk=\"Search_Chunk15.xml\" /><stem n=\"likewis\" chunk=\"Search_Chunk15.xml\" /><stem n=\"313x313\" chunk=\"Search_Chunk15.xml\" /><stem n=\"nativ\" chunk=\"Search_Chunk15.xml\" /><stem n=\"multiresolut\" chunk=\"Search_Chunk15.xml\" /><stem n=\"wavelet\" chunk=\"Search_Chunk15.xml\" /><stem n=\"order\" chunk=\"Search_Chunk15.xml\" /><stem n=\"achiev\" chunk=\"Search_Chunk15.xml\" /><stem n=\"appli\" chunk=\"Search_Chunk15.xml\" /><stem n=\"machin\" chunk=\"Search_Chunk15.xml\" /><stem n=\"core\" chunk=\"Search_Chunk15.xml\" /><stem n=\"quick\" chunk=\"Search_Chunk15.xml\" /><stem n=\"default\" chunk=\"Search_Chunk15.xml\" /><stem n=\"maximum\" chunk=\"Search_Chunk15.xml\" /><stem n=\"equal\" chunk=\"Search_Chunk15.xml\" /><stem n=\"worker\" chunk=\"Search_Chunk15.xml\" /><stem n=\"setmaxworkerthread\" chunk=\"Search_Chunk15.xml\" /><stem n=\"defin\" chunk=\"Search_Chunk15.xml\" /><stem n=\"mrsidimageread\" chunk=\"Search_Chunk15.xml\" /><stem n=\"block\" chunk=\"Search_Chunk15.xml\" /><stem n=\"intel\" chunk=\"Search_Chunk15.xml\" /><stem n=\"tbb\" chunk=\"Search_Chunk15.xml\" /><stem n=\"program\" chunk=\"Search_Chunk15.xml\" /><stem n=\"dll\" chunk=\"Search_Chunk15.xml\" /><stem n=\"https\" chunk=\"Search_Chunk15.xml\" /><stem n=\"threadingbuildingblock\" chunk=\"Search_Chunk15.xml\" /><stem n=\"org\" chunk=\"Search_Chunk15.xml\" /><stem n=\"few\" chunk=\"Search_Chunk15.xml\" /><stem n=\"less\" chunk=\"Search_Chunk15.xml\" /><stem n=\"central\" chunk=\"Search_Chunk16.xml\" /><stem n=\"status\" chunk=\"Search_Chunk16.xml\" /><stem n=\"member\" chunk=\"Search_Chunk16.xml\" /><stem n=\"return\" chunk=\"Search_Chunk16.xml\" /><stem n=\"report\" chunk=\"Search_Chunk16.xml\" /><stem n=\"success\" chunk=\"Search_Chunk16.xml\" /><stem n=\"failur\" chunk=\"Search_Chunk16.xml\" /><stem n=\"condit\" chunk=\"Search_Chunk16.xml\" /><stem n=\"instead\" chunk=\"Search_Chunk16.xml\" /><stem n=\"throw\" chunk=\"Search_Chunk16.xml\" /><stem n=\"lt_status\" chunk=\"Search_Chunk16.xml\" /><stem n=\"typedef\" chunk=\"Search_Chunk16.xml\" /><stem n=\"d\" chunk=\"Search_Chunk16.xml\" /><stem n=\"unsign\" chunk=\"Search_Chunk16.xml\" /><stem n=\"integ\" chunk=\"Search_Chunk16.xml\" /><stem n=\"heavi\" chunk=\"Search_Chunk16.xml\" /><stem n=\"weight\" chunk=\"Search_Chunk16.xml\" /><stem n=\"nontrivi\" chunk=\"Search_Chunk16.xml\" /><stem n=\"immedi\" chunk=\"Search_Chunk16.xml\" /><stem n=\"invok\" chunk=\"Search_Chunk16.xml\" /><stem n=\"extra\" chunk=\"Search_Chunk16.xml\" /><stem n=\"caller\" chunk=\"Search_Chunk16.xml\" /><stem n=\"reli\" chunk=\"Search_Chunk16.xml\" /><stem n=\"thrown\" chunk=\"Search_Chunk16.xml\" /><stem n=\"creator\" chunk=\"Search_Chunk16.xml\" /><stem n=\"delet\" chunk=\"Search_Chunk16.xml\" /><stem n=\"rule\" chunk=\"Search_Chunk16.xml\" /><stem n=\"heap\" chunk=\"Search_Chunk16.xml\" /><stem n=\"respons\" chunk=\"Search_Chunk16.xml\" /><stem n=\"ownership\" chunk=\"Search_Chunk16.xml\" /><stem n=\"across\" chunk=\"Search_Chunk16.xml\" /><stem n=\"count\" chunk=\"Search_Chunk16.xml\" /><stem n=\"rc\" chunk=\"Search_Chunk16.xml\" /><stem n=\"address\" chunk=\"Search_Chunk16.xml\" /><stem n=\"magic\" chunk=\"Search_Chunk16.xml\" /><stem n=\"tend\" chunk=\"Search_Chunk16.xml\" /><stem n=\"attempt\" chunk=\"Search_Chunk16.xml\" /><stem n=\"silent\" chunk=\"Search_Chunk16.xml\" /><stem n=\"guess\" chunk=\"Search_Chunk16.xml\" /><stem n=\"otherwis\" chunk=\"Search_Chunk16.xml\" /><stem n=\"thing\" chunk=\"Search_Chunk16.xml\" /><stem n=\"correct\" chunk=\"Search_Chunk16.xml\" /><stem n=\"occasion\" chunk=\"Search_Chunk16.xml\" /><stem n=\"easier\" chunk=\"Search_Chunk16.xml\" /><stem n=\"incorrect\" chunk=\"Search_Chunk16.xml\" /><stem n=\"mask\" chunk=\"Search_Chunk16.xml\" /><stem n=\"deeper\" chunk=\"Search_Chunk16.xml\" /><stem n=\"ineffici\" chunk=\"Search_Chunk16.xml\" /><stem n=\"implicit\" chunk=\"Search_Chunk16.xml\" /><stem n=\"g\" chunk=\"Search_Chunk16.xml\" /><stem n=\"lifespan\" chunk=\"Search_Chunk16.xml\" /><stem n=\"compris\" chunk=\"Search_Chunk16.xml\" /><stem n=\"spirit\" chunk=\"Search_Chunk16.xml\" /><stem n=\"smart\" chunk=\"Search_Chunk16.xml\" /><stem n=\"auto\" chunk=\"Search_Chunk16.xml\" /><stem n=\"pointer\" chunk=\"Search_Chunk16.xml\" /><stem n=\"static\" chunk=\"Search_Chunk16.xml\" /><stem n=\"instanc\" chunk=\"Search_Chunk16.xml\" /><stem n=\"goe\" chunk=\"Search_Chunk16.xml\" /><stem n=\"scope\" chunk=\"Search_Chunk16.xml\" /><stem n=\"retain\" chunk=\"Search_Chunk16.xml\" /><stem n=\"increment\" chunk=\"Search_Chunk16.xml\" /><stem n=\"last\" chunk=\"Search_Chunk16.xml\" /><stem n=\"itself\" chunk=\"Search_Chunk16.xml\" /><stem n=\"underli\" chunk=\"Search_Chunk16.xml\" /><stem n=\"primit\" chunk=\"Search_Chunk16.xml\" /><stem n=\"name\" chunk=\"Search_Chunk16.xml\" /><stem n=\"prefix\" chunk=\"Search_Chunk16.xml\" /><stem n=\"letter\" chunk=\"Search_Chunk16.xml\" /><stem n=\"lt\" chunk=\"Search_Chunk16.xml\" /><stem n=\"preprocessor\" chunk=\"Search_Chunk16.xml\" /><stem n=\"constant\" chunk=\"Search_Chunk16.xml\" /><stem n=\"string\" chunk=\"Search_Chunk16.xml\" /><stem n=\"ltifilespec\" chunk=\"Search_Chunk16.xml\" /><stem n=\"stream\" chunk=\"Search_Chunk16.xml\" /><stem n=\"lt_base\" chunk=\"Search_Chunk16.xml\" /><stem n=\"four\" chunk=\"Search_Chunk16.xml\" /><stem n=\"lt_defin\" chunk=\"Search_Chunk16.xml\" /><stem n=\"lt_platform\" chunk=\"Search_Chunk16.xml\" /><stem n=\"lt_type\" chunk=\"Search_Chunk16.xml\" /><stem n=\"definit\" chunk=\"Search_Chunk16.xml\" /><stem n=\"miscellan\" chunk=\"Search_Chunk16.xml\" /><stem n=\"macro\" chunk=\"Search_Chunk16.xml\" /><stem n=\"throughout\" chunk=\"Search_Chunk16.xml\" /><stem n=\"current\" chunk=\"Search_Chunk16.xml\" /><stem n=\"lt_utilstatusstr\" chunk=\"Search_Chunk16.xml\" /><stem n=\"declar\" chunk=\"Search_Chunk16.xml\" /><stem n=\"map\" chunk=\"Search_Chunk16.xml\" /><stem n=\"text\" chunk=\"Search_Chunk16.xml\" /><stem n=\"indic\" chunk=\"Search_Chunk16.xml\" /><stem n=\"natur\" chunk=\"Search_Chunk16.xml\" /><stem n=\"either\" chunk=\"Search_Chunk16.xml\" /><stem n=\"getrawstatusstr\" chunk=\"Search_Chunk16.xml\" /><stem n=\"getlaststatusstr\" chunk=\"Search_Chunk16.xml\" /><stem n=\"retriev\" chunk=\"Search_Chunk16.xml\" /><stem n=\"textual\" chunk=\"Search_Chunk16.xml\" /><stem n=\"search\" chunk=\"Search_Chunk16.xml\" /><stem n=\"particular\" chunk=\"Search_Chunk16.xml\" /><stem n=\"help\" chunk=\"Search_Chunk16.xml\" /><stem n=\"portabl\" chunk=\"Search_Chunk16.xml\" /><stem n=\"unix\" chunk=\"Search_Chunk16.xml\" /><stem n=\"eas\" chunk=\"Search_Chunk16.xml\" /><stem n=\"internation\" chunk=\"Search_Chunk16.xml\" /><stem n=\"ltfilespec\" chunk=\"Search_Chunk16.xml\" /><stem n=\"path\" chunk=\"Search_Chunk16.xml\" /><stem n=\"paramet\" chunk=\"Search_Chunk16.xml\" /><stem n=\"translat\" chunk=\"Search_Chunk16.xml\" /><stem n=\"app\" chunk=\"Search_Chunk16.xml\" /><stem n=\"char\" chunk=\"Search_Chunk16.xml\" /><stem n=\"multibyt\" chunk=\"Search_Chunk16.xml\" /><stem n=\"utf\" chunk=\"Search_Chunk16.xml\" /><stem n=\"wchar_t\" chunk=\"Search_Chunk16.xml\" /><stem n=\"style\" chunk=\"Search_Chunk17.xml\" /><stem n=\"dirnam\" chunk=\"Search_Chunk17.xml\" /><stem n=\"basenam\" chunk=\"Search_Chunk17.xml\" /><stem n=\"extens\" chunk=\"Search_Chunk17.xml\" /><stem n=\"replac\" chunk=\"Search_Chunk17.xml\" /><stem n=\"differenti\" chunk=\"Search_Chunk17.xml\" /><stem n=\"absolut\" chunk=\"Search_Chunk17.xml\" /><stem n=\"stdio\" chunk=\"Search_Chunk17.xml\" /><stem n=\"like\" chunk=\"Search_Chunk17.xml\" /><stem n=\"rather\" chunk=\"Search_Chunk17.xml\" /><stem n=\"small\" chunk=\"Search_Chunk17.xml\" /><stem n=\"byte\" chunk=\"Search_Chunk17.xml\" /><stem n=\"seek\" chunk=\"Search_Chunk17.xml\" /><stem n=\"tell\" chunk=\"Search_Chunk17.xml\" /><stem n=\"offset\" chunk=\"Search_Chunk17.xml\" /><stem n=\"isopen\" chunk=\"Search_Chunk17.xml\" /><stem n=\"iseof\" chunk=\"Search_Chunk17.xml\" /><stem n=\"precis\" chunk=\"Search_Chunk17.xml\" /><stem n=\"semant\" chunk=\"Search_Chunk17.xml\" /><stem n=\"socket\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltiofilestream\" chunk=\"Search_Chunk17.xml\" /><stem n=\"2gb\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltiomemstream\" chunk=\"Search_Chunk17.xml\" /><stem n=\"fix\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltiodynamicmemstream\" chunk=\"Search_Chunk17.xml\" /><stem n=\"grow\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltiobufferedstream\" chunk=\"Search_Chunk17.xml\" /><stem n=\"under\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltiocallbackstream\" chunk=\"Search_Chunk17.xml\" /><stem n=\"callback\" chunk=\"Search_Chunk17.xml\" /><stem n=\"geograph\" chunk=\"Search_Chunk17.xml\" /><stem n=\"lti\" chunk=\"Search_Chunk17.xml\" /><stem n=\"actual\" chunk=\"Search_Chunk17.xml\" /><stem n=\"enum\" chunk=\"Search_Chunk17.xml\" /><stem n=\"lti_typ\" chunk=\"Search_Chunk17.xml\" /><stem n=\"lticolorspac\" chunk=\"Search_Chunk17.xml\" /><stem n=\"lticolor\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltidatatyp\" chunk=\"Search_Chunk17.xml\" /><stem n=\"lightweight\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltisampl\" chunk=\"Search_Chunk17.xml\" /><stem n=\"option\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltipixel\" chunk=\"Search_Chunk17.xml\" /><stem n=\"themselv\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltipixellookupt\" chunk=\"Search_Chunk17.xml\" /><stem n=\"concept\" chunk=\"Search_Chunk17.xml\" /><stem n=\"lookup\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltigeocoord\" chunk=\"Search_Chunk17.xml\" /><stem n=\"analog\" chunk=\"Search_Chunk17.xml\" /><stem n=\"aux\" chunk=\"Search_Chunk17.xml\" /><stem n=\"gis\" chunk=\"Search_Chunk17.xml\" /><stem n=\"project\" chunk=\"Search_Chunk17.xml\" /><stem n=\"wkt\" chunk=\"Search_Chunk17.xml\" /><stem n=\"rotat\" chunk=\"Search_Chunk17.xml\" /><stem n=\"associ\" chunk=\"Search_Chunk17.xml\" /><stem n=\"prove\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltiinterruptdeleg\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltiprogressdeleg\" chunk=\"Search_Chunk17.xml\" /><stem n=\"potenti\" chunk=\"Search_Chunk17.xml\" /><stem n=\"long\" chunk=\"Search_Chunk17.xml\" /><stem n=\"request\" chunk=\"Search_Chunk17.xml\" /><stem n=\"abort\" chunk=\"Search_Chunk17.xml\" /><stem n=\"notif\" chunk=\"Search_Chunk17.xml\" /><stem n=\"percent\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltiutil\" chunk=\"Search_Chunk17.xml\" /><stem n=\"hierarchi\" chunk=\"Search_Chunk17.xml\" /><stem n=\"background\" chunk=\"Search_Chunk17.xml\" /><stem n=\"nodata\" chunk=\"Search_Chunk17.xml\" /><stem n=\"coordin\" chunk=\"Search_Chunk17.xml\" /><stem n=\"reflect\" chunk=\"Search_Chunk17.xml\" /><stem n=\"discuss\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltigeofileimagewrit\" chunk=\"Search_Chunk17.xml\" /><stem n=\"replic\" chunk=\"Search_Chunk17.xml\" /><stem n=\"control\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltiimagemosaicfilt\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltirawimageread\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltirawimagewrit\" chunk=\"Search_Chunk17.xml\" /><stem n=\"direct\" chunk=\"Search_Chunk17.xml\" /><stem n=\"binari\" chunk=\"Search_Chunk17.xml\" /><stem n=\"big\" chunk=\"Search_Chunk17.xml\" /><stem n=\"littl\" chunk=\"Search_Chunk17.xml\" /><stem n=\"host\" chunk=\"Search_Chunk17.xml\" /><stem n=\"endian\" chunk=\"Search_Chunk17.xml\" /><stem n=\"usual\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltibbbimageread\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltibbbimagewrit\" chunk=\"Search_Chunk17.xml\" /><stem n=\"bbb\" chunk=\"Search_Chunk17.xml\" /><stem n=\"syntax\" chunk=\"Search_Chunk17.xml\" /><stem n=\"togeth\" chunk=\"Search_Chunk17.xml\" /><stem n=\"put\" chunk=\"Search_Chunk17.xml\" /><stem n=\"embodi\" chunk=\"Search_Chunk17.xml\" /><stem n=\"ltinavig\" chunk=\"Search_Chunk17.xml\" /><stem n=\"move\" chunk=\"Search_Chunk17.xml\" /><stem n=\"best\" chunk=\"Search_Chunk17.xml\" /><stem n=\"fit\" chunk=\"Search_Chunk17.xml\" /><stem n=\"center\" chunk=\"Search_Chunk17.xml\" /><stem n=\"oppos\" chunk=\"Search_Chunk17.xml\" /><stem n=\"navig\" chunk=\"Search_Chunk17.xml\" /><stem n=\"proper\" chunk=\"Search_Chunk17.xml\" /><stem n=\"round\" chunk=\"Search_Chunk17.xml\" /><stem n=\"keep\" chunk=\"Search_Chunk17.xml\" /><stem n=\"transpar\" chunk=\"Search_Chunk17.xml\" /><stem n=\"depend\" chunk=\"Search_Chunk17.xml\" /><stem n=\"it\" chunk=\"Search_Chunk17.xml\" /><stem n=\"visibl\" chunk=\"Search_Chunk17.xml\" /><stem n=\"expos\" chunk=\"Search_Chunk17.xml\" /><stem n=\"larger\" chunk=\"Search_Chunk17.xml\" /><stem n=\"total\" chunk=\"Search_Chunk17.xml\" /><stem n=\"200x100\" chunk=\"Search_Chunk17.xml\" /><stem n=\"20\" chunk=\"Search_Chunk17.xml\" /><stem n=\"000\" chunk=\"Search_Chunk17.xml\" /><stem n=\"160x60\" chunk=\"Search_Chunk17.xml\" /><stem n=\"600\" chunk=\"Search_Chunk17.xml\" /><stem n=\"40\" chunk=\"Search_Chunk17.xml\" /><stem n=\"20+40\" chunk=\"Search_Chunk17.xml\" /><stem n=\"assum\" chunk=\"Search_Chunk17.xml\" /><stem n=\"pack\" chunk=\"Search_Chunk18.xml\" /><stem n=\"layout\" chunk=\"Search_Chunk18.xml\" /><stem n=\"organ\" chunk=\"Search_Chunk18.xml\" /><stem n=\"fashion\" chunk=\"Search_Chunk18.xml\" /><stem n=\"pad\" chunk=\"Search_Chunk18.xml\" /><stem n=\"row\" chunk=\"Search_Chunk18.xml\" /><stem n=\"satisfi\" chunk=\"Search_Chunk18.xml\" /><stem n=\"align\" chunk=\"Search_Chunk18.xml\" /><stem n=\"held\" chunk=\"Search_Chunk18.xml\" /><stem n=\"individu\" chunk=\"Search_Chunk18.xml\" /><stem n=\"concret\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltiaddalphafilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"add\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltibandselectfilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"remap\" chunk=\"Search_Chunk18.xml\" /><stem n=\"former\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltisamplemapfilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"merg\" chunk=\"Search_Chunk18.xml\" /><stem n=\"greyscal\" chunk=\"Search_Chunk18.xml\" /><stem n=\"lticolorcompositefilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"lticolortransform\" chunk=\"Search_Chunk18.xml\" /><stem n=\"cmyk\" chunk=\"Search_Chunk18.xml\" /><stem n=\"lticropfilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"smaller\" chunk=\"Search_Chunk18.xml\" /><stem n=\"reduct\" chunk=\"Search_Chunk18.xml\" /><stem n=\"true\" chunk=\"Search_Chunk18.xml\" /><stem n=\"lost\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltidynamicrangefilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"preprocess\" chunk=\"Search_Chunk18.xml\" /><stem n=\"step\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltiembeddedimag\" chunk=\"Search_Chunk18.xml\" /><stem n=\"embed\" chunk=\"Search_Chunk18.xml\" /><stem n=\"increas\" chunk=\"Search_Chunk18.xml\" /><stem n=\"stretch\" chunk=\"Search_Chunk18.xml\" /><stem n=\"canva\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltimosaicfilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"grid\" chunk=\"Search_Chunk18.xml\" /><stem n=\"shape\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltimultiresfilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"normal\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltistaticzoomfilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"magnifi\" chunk=\"Search_Chunk18.xml\" /><stem n=\"simpli\" chunk=\"Search_Chunk18.xml\" /><stem n=\"life\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltitranslationfilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltiviewerimagefilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"readili\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltidatatypetransform\" chunk=\"Search_Chunk18.xml\" /><stem n=\"engin\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ltiwatermarkfilt\" chunk=\"Search_Chunk18.xml\" /><stem n=\"nonetheless\" chunk=\"Search_Chunk18.xml\" /><stem n=\"act\" chunk=\"Search_Chunk18.xml\" /><stem n=\"stripwis\" chunk=\"Search_Chunk18.xml\" /><stem n=\"bbbimagewrit\" chunk=\"Search_Chunk18.xml\" /><stem n=\"bmpimagewrit\" chunk=\"Search_Chunk18.xml\" /><stem n=\"geotiffimagewrit\" chunk=\"Search_Chunk18.xml\" /><stem n=\"jpegimagewrit\" chunk=\"Search_Chunk18.xml\" /><stem n=\"tiffimagewrit\" chunk=\"Search_Chunk18.xml\" /><stem n=\"solut\" chunk=\"Search_Chunk18.xml\" /><stem n=\"challeng\" chunk=\"Search_Chunk18.xml\" /><stem n=\"opportun\" chunk=\"Search_Chunk18.xml\" /><stem n=\"present\" chunk=\"Search_Chunk18.xml\" /><stem n=\"lossless\" chunk=\"Search_Chunk18.xml\" /><stem n=\"yield\" chunk=\"Search_Chunk18.xml\" /><stem n=\"economi\" chunk=\"Search_Chunk18.xml\" /><stem n=\"transfer\" chunk=\"Search_Chunk18.xml\" /><stem n=\"improv\" chunk=\"Search_Chunk18.xml\" /><stem n=\"instant\" chunk=\"Search_Chunk18.xml\" /><stem n=\"devic\" chunk=\"Search_Chunk18.xml\" /><stem n=\"acquir\" chunk=\"Search_Chunk18.xml\" /><stem n=\"los\" chunk=\"Search_Chunk18.xml\" /><stem n=\"alamo\" chunk=\"Search_Chunk18.xml\" /><stem n=\"nation\" chunk=\"Search_Chunk18.xml\" /><stem n=\"laboratori\" chunk=\"Search_Chunk18.xml\" /><stem n=\"lanl\" chunk=\"Search_Chunk18.xml\" /><stem n=\"aegi\" chunk=\"Search_Chunk18.xml\" /><stem n=\"u\" chunk=\"Search_Chunk18.xml\" /><stem n=\"fingerprint\" chunk=\"Search_Chunk18.xml\" /><stem n=\"fbi\" chunk=\"Search_Chunk18.xml\" /><stem n=\"commerci\" chunk=\"Search_Chunk18.xml\" /><stem n=\"today\" chunk=\"Search_Chunk18.xml\" /><stem n=\"key\" chunk=\"Search_Chunk18.xml\" /><stem n=\"first\" chunk=\"Search_Chunk18.xml\" /><stem n=\"unlik\" chunk=\"Search_Chunk18.xml\" /><stem n=\"tile\" chunk=\"Search_Chunk18.xml\" /><stem n=\"somewhat\" chunk=\"Search_Chunk18.xml\" /><stem n=\"inferior\" chunk=\"Search_Chunk18.xml\" /><stem n=\"valid\" chunk=\"Search_Chunk18.xml\" /><stem n=\"unto\" chunk=\"Search_Chunk18.xml\" /><stem n=\"inspect\" chunk=\"Search_Chunk18.xml\" /><stem n=\"overview\" chunk=\"Search_Chunk18.xml\" /><stem n=\"naip\" chunk=\"Search_Chunk18.xml\" /><stem n=\"landsat\" chunk=\"Search_Chunk18.xml\" /><stem n=\"even\" chunk=\"Search_Chunk18.xml\" /><stem n=\"224\" chunk=\"Search_Chunk18.xml\" /><stem n=\"aviri\" chunk=\"Search_Chunk18.xml\" /><stem n=\"shapefil\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ever\" chunk=\"Search_Chunk18.xml\" /><stem n=\"evolv\" chunk=\"Search_Chunk18.xml\" /><stem n=\"sign\" chunk=\"Search_Chunk18.xml\" /><stem n=\"flat\" chunk=\"Search_Chunk18.xml\" /><stem n=\"alway\" chunk=\"Search_Chunk18.xml\" /><stem n=\"continu\" chunk=\"Search_Chunk18.xml\" /><stem n=\"mind\" chunk=\"Search_Chunk18.xml\" /><stem n=\"sinc\" chunk=\"Search_Chunk18.xml\" /><stem n=\"older\" chunk=\"Search_Chunk18.xml\" /><stem n=\"kept\" chunk=\"Search_Chunk18.xml\" /><stem n=\"agnost\" chunk=\"Search_Chunk18.xml\" /><stem n=\"respect\" chunk=\"Search_Chunk18.xml\" /><stem n=\"imagin\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ecw\" chunk=\"Search_Chunk18.xml\" /><stem n=\"per\" chunk=\"Search_Chunk18.xml\" /><stem n=\"almost\" chunk=\"Search_Chunk18.xml\" /><stem n=\"elev\" chunk=\"Search_Chunk18.xml\" /><stem n=\"dted\" chunk=\"Search_Chunk18.xml\" /><stem n=\"our\" chunk=\"Search_Chunk18.xml\" /><stem n=\"sort\" chunk=\"Search_Chunk18.xml\" /><stem n=\"perhap\" chunk=\"Search_Chunk18.xml\" /><stem n=\"terrain\" chunk=\"Search_Chunk18.xml\" /><stem n=\"layer\" chunk=\"Search_Chunk18.xml\" /><stem n=\"255\" chunk=\"Search_Chunk18.xml\" /><stem n=\"excel\" chunk=\"Search_Chunk18.xml\" /><stem n=\"ratio\" chunk=\"Search_Chunk18.xml\" /><stem n=\"50\" chunk=\"Search_Chunk18.xml\" /><stem n=\"preserv\" chunk=\"Search_Chunk18.xml\" /><stem n=\"uncommon\" chunk=\"Search_Chunk18.xml\" /><stem n=\"loss\" chunk=\"Search_Chunk18.xml\" /><stem n=\"accept\" chunk=\"Search_Chunk18.xml\" /><stem n=\"master\" chunk=\"Search_Chunk18.xml\" /><stem n=\"appear\" chunk=\"Search_Chunk18.xml\" /><stem n=\"analysi\" chunk=\"Search_Chunk18.xml\" /><stem n=\"exploit\" chunk=\"Search_Chunk18.xml\" /><stem n=\"lossi\" chunk=\"Search_Chunk18.xml\" /><stem n=\"degrad\" chunk=\"Search_Chunk18.xml\" /><stem n=\"artifact\" chunk=\"Search_Chunk18.xml\" /><stem n=\"too\" chunk=\"Search_Chunk18.xml\" /><stem n=\"signific\" chunk=\"Search_Chunk18.xml\" /><stem n=\"speed\" chunk=\"Search_Chunk18.xml\" /><stem n=\"decompress\" chunk=\"Search_Chunk18.xml\" /><stem n=\"cpu\" chunk=\"Search_Chunk18.xml\" /><stem n=\"o\" chunk=\"Search_Chunk18.xml\" /><stem n=\"concern\" chunk=\"Search_Chunk18.xml\" /><stem n=\"deal\" chunk=\"Search_Chunk18.xml\" /><stem n=\"veri\" chunk=\"Search_Chunk18.xml\" /><stem n=\"algorithm\" chunk=\"Search_Chunk18.xml\" /><stem n=\"partit\" chunk=\"Search_Chunk18.xml\" /><stem n=\"independ\" chunk=\"Search_Chunk18.xml\" /><stem n=\"proceed\" chunk=\"Search_Chunk18.xml\" /><stem n=\"slow\" chunk=\"Search_Chunk18.xml\" /><stem n=\"down\" chunk=\"Search_Chunk18.xml\" /><stem n=\"due\" chunk=\"Search_Chunk18.xml\" /><stem n=\"disk\" chunk=\"Search_Chunk18.xml\" /><stem n=\"especi\" chunk=\"Search_Chunk18.xml\" /><stem n=\"cannot\" chunk=\"Search_Chunk18.xml\" /><stem n=\"whose\" chunk=\"Search_Chunk18.xml\" /><stem n=\"resort\" chunk=\"Search_Chunk18.xml\" /><stem n=\"scheme\" chunk=\"Search_Chunk18.xml\" /><stem n=\"therefor\" chunk=\"Search_Chunk18.xml\" /><stem n=\"inher\" chunk=\"Search_Chunk18.xml\" /><stem n=\"decid\" chunk=\"Search_Chunk18.xml\" /><stem n=\"physic\" chunk=\"Search_Chunk18.xml\" /><stem n=\"screen\" chunk=\"Search_Chunk18.xml\" /><stem n=\"portion\" chunk=\"Search_Chunk18.xml\" /><stem n=\"rough\" chunk=\"Search_Chunk18.xml\" /><stem n=\"compar\" chunk=\"Search_Chunk18.xml\" /><stem n=\"earlier\" chunk=\"Search_Chunk18.xml\" /><stem n=\"reason\" chunk=\"Search_Chunk19.xml\" /><stem n=\"faster\" chunk=\"Search_Chunk19.xml\" /><stem n=\"bring\" chunk=\"Search_Chunk19.xml\" /><stem n=\"purpos\" chunk=\"Search_Chunk19.xml\" /><stem n=\"re\" chunk=\"Search_Chunk19.xml\" /><stem n=\"bottom\" chunk=\"Search_Chunk19.xml\" /><stem n=\"baselin\" chunk=\"Search_Chunk19.xml\" /><stem n=\"remov\" chunk=\"Search_Chunk19.xml\" /><stem n=\"foot\" chunk=\"Search_Chunk19.xml\" /><stem n=\"six\" chunk=\"Search_Chunk19.xml\" /><stem n=\"inch\" chunk=\"Search_Chunk19.xml\" /><stem n=\"dvd\" chunk=\"Search_Chunk19.xml\" /><stem n=\"neighborhood\" chunk=\"Search_Chunk19.xml\" /><stem n=\"whole\" chunk=\"Search_Chunk19.xml\" /><stem n=\"citi\" chunk=\"Search_Chunk19.xml\" /><stem n=\"fast\" chunk=\"Search_Chunk19.xml\" /><stem n=\"referenc\" chunk=\"Search_Chunk19.xml\" /><stem n=\"crs\" chunk=\"Search_Chunk19.xml\" /><stem n=\"tag\" chunk=\"Search_Chunk19.xml\" /><stem n=\"reproject\" chunk=\"Search_Chunk19.xml\" /><stem n=\"accord\" chunk=\"Search_Chunk19.xml\" /><stem n=\"record\" chunk=\"Search_Chunk19.xml\" /><stem n=\"still\" chunk=\"Search_Chunk19.xml\" /><stem n=\"modifi\" chunk=\"Search_Chunk19.xml\" /><stem n=\"third\" chunk=\"Search_Chunk19.xml\" /><stem n=\"recent\" chunk=\"Search_Chunk19.xml\" /><stem n=\"wide\" chunk=\"Search_Chunk19.xml\" /><stem n=\"2011\" chunk=\"Search_Chunk19.xml\" /><stem n=\"usda\" chunk=\"Search_Chunk19.xml\" /><stem n=\"state\" chunk=\"Search_Chunk19.xml\" /><stem n=\"fourth\" chunk=\"Search_Chunk19.xml\" /><stem n=\"infrar\" chunk=\"Search_Chunk19.xml\" /><stem n=\"ir\" chunk=\"Search_Chunk19.xml\" /><stem n=\"digitalglob\" chunk=\"Search_Chunk19.xml\" /><stem n=\"launch\" chunk=\"Search_Chunk19.xml\" /><stem n=\"worldview\" chunk=\"Search_Chunk19.xml\" /><stem n=\"satellit\" chunk=\"Search_Chunk19.xml\" /><stem n=\"five\" chunk=\"Search_Chunk19.xml\" /><stem n=\"yellow\" chunk=\"Search_Chunk19.xml\" /><stem n=\"coastal\" chunk=\"Search_Chunk19.xml\" /><stem n=\"nasa\" chunk=\"Search_Chunk19.xml\" /><stem n=\"modi\" chunk=\"Search_Chunk19.xml\" /><stem n=\"now\" chunk=\"Search_Chunk19.xml\" /><stem n=\"36\" chunk=\"Search_Chunk19.xml\" /><stem n=\"remot\" chunk=\"Search_Chunk19.xml\" /><stem n=\"narrow\" chunk=\"Search_Chunk19.xml\" /><stem n=\"chosen\" chunk=\"Search_Chunk19.xml\" /><stem n=\"classif\" chunk=\"Search_Chunk19.xml\" /><stem n=\"discrimin\" chunk=\"Search_Chunk19.xml\" /><stem n=\"veget\" chunk=\"Search_Chunk19.xml\" /><stem n=\"shallow\" chunk=\"Search_Chunk19.xml\" /><stem n=\"water\" chunk=\"Search_Chunk19.xml\" /><stem n=\"bathymetri\" chunk=\"Search_Chunk19.xml\" /><stem n=\"man\" chunk=\"Search_Chunk19.xml\" /><stem n=\"richer\" chunk=\"Search_Chunk19.xml\" /><stem n=\"cours\" chunk=\"Search_Chunk19.xml\" /><stem n=\"5kx5k\" chunk=\"Search_Chunk19.xml\" /><stem n=\"linear\" chunk=\"Search_Chunk19.xml\" /><stem n=\"minut\" chunk=\"Search_Chunk19.xml\" /><stem n=\"vari\" chunk=\"Search_Chunk19.xml\" /><stem n=\"familiar\" chunk=\"Search_Chunk19.xml\" /><stem n=\"sentinel\" chunk=\"Search_Chunk19.xml\" /><stem n=\"black\" chunk=\"Search_Chunk19.xml\" /><stem n=\"past\" chunk=\"Search_Chunk19.xml\" /><stem n=\"notic\" chunk=\"Search_Chunk19.xml\" /><stem n=\"slight\" chunk=\"Search_Chunk19.xml\" /><stem n=\"subject\" chunk=\"Search_Chunk19.xml\" /><stem n=\"indistinguish\" chunk=\"Search_Chunk19.xml\" /><stem n=\"context\" chunk=\"Search_Chunk19.xml\" /><stem n=\"longer\" chunk=\"Search_Chunk19.xml\" /><stem n=\"worst\" chunk=\"Search_Chunk19.xml\" /><stem n=\"caus\" chunk=\"Search_Chunk19.xml\" /><stem n=\"speckl\" chunk=\"Search_Chunk19.xml\" /><stem n=\"affect\" chunk=\"Search_Chunk19.xml\" /><stem n=\"putat\" chunk=\"Search_Chunk19.xml\" /><stem n=\"honor\" chunk=\"Search_Chunk19.xml\" /><stem n=\"treat\" chunk=\"Search_Chunk19.xml\" /><stem n=\"never\" chunk=\"Search_Chunk19.xml\" /><stem n=\"sequenc\" chunk=\"Search_Chunk19.xml\" /><stem n=\"zero\" chunk=\"Search_Chunk19.xml\" /><stem n=\"extrem\" chunk=\"Search_Chunk19.xml\" /><stem n=\"overhead\" chunk=\"Search_Chunk19.xml\" /><stem n=\"dozen\" chunk=\"Search_Chunk19.xml\" /><stem n=\"flight\" chunk=\"Search_Chunk19.xml\" /><stem n=\"accuraci\" chunk=\"Search_Chunk19.xml\" /><stem n=\"automat\" chunk=\"Search_Chunk19.xml\" /><stem n=\"account\" chunk=\"Search_Chunk19.xml\" /><stem n=\"wherea\" chunk=\"Search_Chunk19.xml\" /><stem n=\"restrict\" chunk=\"Search_Chunk19.xml\" /><stem n=\"special\" chunk=\"Search_Chunk19.xml\" /><stem n=\"span\" chunk=\"Search_Chunk19.xml\" /><stem n=\"compos\" chunk=\"Search_Chunk19.xml\" /><stem n=\"queri\" chunk=\"Search_Chunk19.xml\" /><stem n=\"whether\" chunk=\"Search_Chunk19.xml\" /><stem n=\"slower\" chunk=\"Search_Chunk19.xml\" /><stem n=\"simultan\" chunk=\"Search_Chunk19.xml\" /><stem n=\"mode\" chunk=\"Search_Chunk19.xml\" /><stem n=\"art\" chunk=\"Search_Chunk19.xml\" /><stem n=\"popular\" chunk=\"Search_Chunk19.xml\" /><stem n=\"discret\" chunk=\"Search_Chunk19.xml\" /><stem n=\"cosin\" chunk=\"Search_Chunk19.xml\" /><stem n=\"dct\" chunk=\"Search_Chunk19.xml\" /><stem n=\"huffman\" chunk=\"Search_Chunk19.xml\" /><stem n=\"arithmet\" chunk=\"Search_Chunk19.xml\" /><stem n=\"quit\" chunk=\"Search_Chunk19.xml\" /><stem n=\"interchang\" chunk=\"Search_Chunk19.xml\" /><stem n=\"valuabl\" chunk=\"Search_Chunk19.xml\" /><stem n=\"geographi\" chunk=\"Search_Chunk19.xml\" /><stem n=\"markup\" chunk=\"Search_Chunk19.xml\" /><stem n=\"gml\" chunk=\"Search_Chunk19.xml\" /><stem n=\"choic\" chunk=\"Search_Chunk19.xml\" /><stem n=\"great\" chunk=\"Search_Chunk19.xml\" /><stem n=\"anticip\" chunk=\"Search_Chunk19.xml\" /><stem n=\"j2kimageread\" chunk=\"Search_Chunk19.xml\" /><stem n=\"find\" chunk=\"Search_Chunk19.xml\" /><stem n=\"old\" chunk=\"Search_Chunk19.xml\" /><stem n=\"complianc\" chunk=\"Search_Chunk19.xml\" /><stem n=\"transmiss\" chunk=\"Search_Chunk19.xml\" /><stem n=\"depart\" chunk=\"Search_Chunk19.xml\" /><stem n=\"defens\" chunk=\"Search_Chunk19.xml\" /><stem n=\"exchang\" chunk=\"Search_Chunk19.xml\" /><stem n=\"dod\" chunk=\"Search_Chunk19.xml\" /><stem n=\"agenc\" chunk=\"Search_Chunk19.xml\" /><stem n=\"segment\" chunk=\"Search_Chunk19.xml\" /><stem n=\"tre\" chunk=\"Search_Chunk19.xml\" /><stem n=\"label\" chunk=\"Search_Chunk19.xml\" /><stem n=\"symbol\" chunk=\"Search_Chunk19.xml\" /><stem n=\"mil\" chunk=\"Search_Chunk19.xml\" /><stem n=\"std\" chunk=\"Search_Chunk19.xml\" /><stem n=\"2500c\" chunk=\"Search_Chunk19.xml\" /><stem n=\"draft\" chunk=\"Search_Chunk19.xml\" /><stem n=\"april\" chunk=\"Search_Chunk19.xml\" /><stem n=\"2004\" chunk=\"Search_Chunk19.xml\" /><stem n=\"biif\" chunk=\"Search_Chunk19.xml\" /><stem n=\"profil\" chunk=\"Search_Chunk19.xml\" /><stem n=\"bpj2k01\" chunk=\"Search_Chunk19.xml\" /><stem n=\"00\" chunk=\"Search_Chunk19.xml\" /><stem n=\"januari\" chunk=\"Search_Chunk19.xml\" /><stem n=\"j2klra\" chunk=\"Search_Chunk19.xml\" /><stem n=\"v1\" chunk=\"Search_Chunk19.xml\" /><stem n=\"yet\" chunk=\"Search_Chunk19.xml\" /><stem n=\"ratifi\" chunk=\"Search_Chunk19.xml\" /><stem n=\"futur\" chunk=\"Search_Chunk19.xml\" /><stem n=\"track\" chunk=\"Search_Chunk19.xml\" /><stem n=\"evolut\" chunk=\"Search_Chunk19.xml\" /><stem n=\"ensur\" chunk=\"Search_Chunk19.xml\" /><stem n=\"simpler\" chunk=\"Search_Chunk19.xml\" /><stem n=\"learn\" chunk=\"Search_Chunk19.xml\" /><stem n=\"nitfimagemanag\" chunk=\"Search_Chunk19.xml\" /><stem n=\"nitfimageread\" chunk=\"Search_Chunk19.xml\" /><stem n=\"createread\" chunk=\"Search_Chunk19.xml\" /><stem n=\"behav\" chunk=\"Search_Chunk19.xml\" /><stem n=\"uncompress\" chunk=\"Search_Chunk19.xml\" /><stem n=\"quantiz\" chunk=\"Search_Chunk19.xml\" /><stem n=\"n\" chunk=\"Search_Chunk19.xml\" /><stem n=\"lut\" chunk=\"Search_Chunk19.xml\" /><stem n=\"clevel\" chunk=\"Search_Chunk19.xml\" /><stem n=\"graphic\" chunk=\"Search_Chunk19.xml\" /><stem n=\"des\" chunk=\"Search_Chunk19.xml\" /><stem n=\"res\" chunk=\"Search_Chunk19.xml\" /><stem n=\"recogn\" chunk=\"Search_Chunk19.xml\" /><stem n=\"pars\" chunk=\"Search_Chunk19.xml\" /><stem n=\"field\" chunk=\"Search_Chunk19.xml\" /><stem n=\"pair\" chunk=\"Search_Chunk19.xml\" /><stem n=\"tres\" chunk=\"Search_Chunk19.xml\" /><stem n=\"constitu\" chunk=\"Search_Chunk19.xml\" /><stem n=\"use00a\" chunk=\"Search_Chunk19.xml\" /><stem n=\"stdidc\" chunk=\"Search_Chunk19.xml\" /><stem n=\"piaimc\" chunk=\"Search_Chunk19.xml\" /><stem n=\"rpc00a\" chunk=\"Search_Chunk19.xml\" /><stem n=\"b\" chunk=\"Search_Chunk19.xml\" /><stem n=\"xxnnn\" chunk=\"Search_Chunk19.xml\" /><stem n=\"xx\" chunk=\"Search_Chunk19.xml\" /><stem n=\"im\" chunk=\"Search_Chunk20.xml\" /><stem n=\"fh\" chunk=\"Search_Chunk20.xml\" /><stem n=\"nnn\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tre_\" chunk=\"Search_Chunk20.xml\" /><stem n=\"fhdr\" chunk=\"Search_Chunk20.xml\" /><stem n=\"fh000\" chunk=\"Search_Chunk20.xml\" /><stem n=\"fver\" chunk=\"Search_Chunk20.xml\" /><stem n=\"stype\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ostaid\" chunk=\"Search_Chunk20.xml\" /><stem n=\"fdt\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ftitl\" chunk=\"Search_Chunk20.xml\" /><stem n=\"onam\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ophon\" chunk=\"Search_Chunk20.xml\" /><stem n=\"numi\" chunk=\"Search_Chunk20.xml\" /><stem n=\"num\" chunk=\"Search_Chunk20.xml\" /><stem n=\"numl\" chunk=\"Search_Chunk20.xml\" /><stem n=\"numt\" chunk=\"Search_Chunk20.xml\" /><stem n=\"numd\" chunk=\"Search_Chunk20.xml\" /><stem n=\"numr\" chunk=\"Search_Chunk20.xml\" /><stem n=\"secur\" chunk=\"Search_Chunk20.xml\" /><stem n=\"unless\" chunk=\"Search_Chunk20.xml\" /><stem n=\"blank\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sclas\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sclsi\" chunk=\"Search_Chunk20.xml\" /><stem n=\"scode\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sctlh\" chunk=\"Search_Chunk20.xml\" /><stem n=\"srel\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sdctp\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sdcdt\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sdcxm\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sdg\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sdgdt\" chunk=\"Search_Chunk20.xml\" /><stem n=\"scltx\" chunk=\"Search_Chunk20.xml\" /><stem n=\"scatp\" chunk=\"Search_Chunk20.xml\" /><stem n=\"scaut\" chunk=\"Search_Chunk20.xml\" /><stem n=\"scrsn\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ssrdt\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sctln\" chunk=\"Search_Chunk20.xml\" /><stem n=\"iid1\" chunk=\"Search_Chunk20.xml\" /><stem n=\"im001\" chunk=\"Search_Chunk20.xml\" /><stem n=\"idatim\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tgtid\" chunk=\"Search_Chunk20.xml\" /><stem n=\"iid2\" chunk=\"Search_Chunk20.xml\" /><stem n=\"isorc\" chunk=\"Search_Chunk20.xml\" /><stem n=\"icord\" chunk=\"Search_Chunk20.xml\" /><stem n=\"igeolo\" chunk=\"Search_Chunk20.xml\" /><stem n=\"nicom\" chunk=\"Search_Chunk20.xml\" /><stem n=\"icom1\" chunk=\"Search_Chunk20.xml\" /><stem n=\"icom9\" chunk=\"Search_Chunk20.xml\" /><stem n=\"detect\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tre_use00a\" chunk=\"Search_Chunk20.xml\" /><stem n=\"entri\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tre_piaimc_cloudcvr\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tre_piaimc_srp\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tre_piaimc_sensmod\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tre_piaimc_sensnam\" chunk=\"Search_Chunk20.xml\" /><stem n=\"distinct\" chunk=\"Search_Chunk20.xml\" /><stem n=\"everyth\" chunk=\"Search_Chunk20.xml\" /><stem n=\"date\" chunk=\"Search_Chunk20.xml\" /><stem n=\"databas\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltimetadatarecord\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ascii\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltimetadatatag\" chunk=\"Search_Chunk20.xml\" /><stem n=\"element\" chunk=\"Search_Chunk20.xml\" /><stem n=\"void\" chunk=\"Search_Chunk20.xml\" /><stem n=\"scalar\" chunk=\"Search_Chunk20.xml\" /><stem n=\"vector\" chunk=\"Search_Chunk20.xml\" /><stem n=\"int\" chunk=\"Search_Chunk20.xml\" /><stem n=\"dim\" chunk=\"Search_Chunk20.xml\" /><stem n=\"length\" chunk=\"Search_Chunk20.xml\" /><stem n=\"4x5\" chunk=\"Search_Chunk20.xml\" /><stem n=\"cast\" chunk=\"Search_Chunk20.xml\" /><stem n=\"dereferenc\" chunk=\"Search_Chunk20.xml\" /><stem n=\"helper\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltimetadatadump\" chunk=\"Search_Chunk20.xml\" /><stem n=\"pretti\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltimetadatadatabas\" chunk=\"Search_Chunk20.xml\" /><stem n=\"prototyp\" chunk=\"Search_Chunk20.xml\" /><stem n=\"linkag\" chunk=\"Search_Chunk20.xml\" /><stem n=\"runtim\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_api\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lt_iocstream\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_openmrsidimagefil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_openmrsidimagestream\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_openjp2imagefil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_openjp2imagestream\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_opennitfimagefil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_closeimag\" chunk=\"Search_Chunk20.xml\" /><stem n=\"denot\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lticimageh\" chunk=\"Search_Chunk20.xml\" /><stem n=\"calcul\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_getdimsatmag\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lt_int32\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_getwidth\" chunk=\"Search_Chunk20.xml\" /><stem n=\"const\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_decod\" chunk=\"Search_Chunk20.xml\" /><stem n=\"xxxxxxxxxxxxxxxxxxxxxx\" chunk=\"Search_Chunk20.xml\" /><stem n=\"doubl\" chunk=\"Search_Chunk20.xml\" /><stem n=\"xupperleft\" chunk=\"Search_Chunk20.xml\" /><stem n=\"yupperleft\" chunk=\"Search_Chunk20.xml\" /><stem n=\"approxim\" chunk=\"Search_Chunk20.xml\" /><stem n=\"argument\" chunk=\"Search_Chunk20.xml\" /><stem n=\"exact\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_getnummetadatarecord\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_metadatarecord\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ltic_getmetadatarecord\" chunk=\"Search_Chunk20.xml\" /><stem n=\"mimic\" chunk=\"Search_Chunk20.xml\" /><stem n=\"counterpart\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lt_iocallbackstreamcr\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lt_iocstreamopen\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lt_iocstreamread\" chunk=\"Search_Chunk20.xml\" /><stem n=\"switch\" chunk=\"Search_Chunk20.xml\" /><stem n=\"mrsidinfo\" chunk=\"Search_Chunk20.xml\" /><stem n=\"mrsiddecod\" chunk=\"Search_Chunk20.xml\" /><stem n=\"mrsidview\" chunk=\"Search_Chunk20.xml\" /><stem n=\"mrsidencod\" chunk=\"Search_Chunk20.xml\" /><stem n=\"mrsidoptim\" chunk=\"Search_Chunk20.xml\" /><stem n=\"mrsidtil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"short\" chunk=\"Search_Chunk20.xml\" /><stem n=\"v\" chunk=\"Search_Chunk20.xml\" /><stem n=\"credit\" chunk=\"Search_Chunk20.xml\" /><stem n=\"quiet\" chunk=\"Search_Chunk20.xml\" /><stem n=\"logfil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"log\" chunk=\"Search_Chunk20.xml\" /><stem n=\"stdout\" chunk=\"Search_Chunk20.xml\" /><stem n=\"meter\" chunk=\"Search_Chunk20.xml\" /><stem n=\"none\" chunk=\"Search_Chunk20.xml\" /><stem n=\"|\" chunk=\"Search_Chunk20.xml\" /><stem n=\"timer\" chunk=\"Search_Chunk20.xml\" /><stem n=\"variabl\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lt_nitf_imagenum\" chunk=\"Search_Chunk20.xml\" /><stem n=\"inputformat\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tif\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ras\" chunk=\"Search_Chunk20.xml\" /><stem n=\"jpg\" chunk=\"Search_Chunk20.xml\" /><stem n=\"doq\" chunk=\"Search_Chunk20.xml\" /><stem n=\"doq_nc\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lan\" chunk=\"Search_Chunk20.xml\" /><stem n=\"img\" chunk=\"Search_Chunk20.xml\" /><stem n=\"mos\" chunk=\"Search_Chunk20.xml\" /><stem n=\"cralpha\" chunk=\"Search_Chunk20.xml\" /><stem n=\"crwithalpha\" chunk=\"Search_Chunk20.xml\" /><stem n=\"meta\" chunk=\"Search_Chunk20.xml\" /><stem n=\"wf\" chunk=\"Search_Chunk20.xml\" /><stem n=\"worldfil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"projectdim\" chunk=\"Search_Chunk20.xml\" /><stem n=\"inputfil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"gmljp2\" chunk=\"Search_Chunk20.xml\" /><stem n=\"schema\" chunk=\"Search_Chunk20.xml\" /><stem n=\"prof\" chunk=\"Search_Chunk20.xml\" /><stem n=\"genprofil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ignorewf\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ignoreworldfil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"iignor\" chunk=\"Search_Chunk20.xml\" /><stem n=\"dump\" chunk=\"Search_Chunk20.xml\" /><stem n=\"aoi\" chunk=\"Search_Chunk20.xml\" /><stem n=\"info\" chunk=\"Search_Chunk20.xml\" /><stem n=\"foo\" chunk=\"Search_Chunk20.xml\" /><stem n=\"outputfil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"outputformat\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tifg\" chunk=\"Search_Chunk20.xml\" /><stem n=\"j\" chunk=\"Search_Chunk20.xml\" /><stem n=\"numthread\" chunk=\"Search_Chunk20.xml\" /><stem n=\"watermarkfil\" chunk=\"Search_Chunk20.xml\" /><stem n=\"watermarkposit\" chunk=\"Search_Chunk20.xml\" /><stem n=\"center_left\" chunk=\"Search_Chunk20.xml\" /><stem n=\"center_right\" chunk=\"Search_Chunk20.xml\" /><stem n=\"upper_left\" chunk=\"Search_Chunk20.xml\" /><stem n=\"upper_cent\" chunk=\"Search_Chunk20.xml\" /><stem n=\"upper_right\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lower_left\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lower_cent\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lower_right\" chunk=\"Search_Chunk20.xml\" /><stem n=\"drmin\" chunk=\"Search_Chunk20.xml\" /><stem n=\"dynrangemin\" chunk=\"Search_Chunk20.xml\" /><stem n=\"drmax\" chunk=\"Search_Chunk20.xml\" /><stem n=\"dynrangemax\" chunk=\"Search_Chunk20.xml\" /><stem n=\"drauto\" chunk=\"Search_Chunk20.xml\" /><stem n=\"autodynrang\" chunk=\"Search_Chunk20.xml\" /><stem n=\"sh\" chunk=\"Search_Chunk20.xml\" /><stem n=\"stripheight\" chunk=\"Search_Chunk20.xml\" /><stem n=\"bgc\" chunk=\"Search_Chunk20.xml\" /><stem n=\"backgroundcolor\" chunk=\"Search_Chunk20.xml\" /><stem n=\"tpc\" chunk=\"Search_Chunk20.xml\" /><stem n=\"transparencycolor\" chunk=\"Search_Chunk20.xml\" /><stem n=\"pwd\" chunk=\"Search_Chunk20.xml\" /><stem n=\"password\" chunk=\"Search_Chunk20.xml\" /><stem n=\"bandlist\" chunk=\"Search_Chunk20.xml\" /><stem n=\"comma\" chunk=\"Search_Chunk20.xml\" /><stem n=\"qualitylay\" chunk=\"Search_Chunk20.xml\" /><stem n=\"prec\" chunk=\"Search_Chunk20.xml\" /><stem n=\"ulxi\" chunk=\"Search_Chunk20.xml\" /><stem n=\"float0\" chunk=\"Search_Chunk20.xml\" /><stem n=\"float1\" chunk=\"Search_Chunk20.xml\" /><stem n=\"lrxi\" chunk=\"Search_Chunk20.xml\" /><stem n=\"cxi\" chunk=\"Search_Chunk20.xml\" /><stem n=\"wh\" chunk=\"Search_Chunk21.xml\" /><stem n=\"coord\" chunk=\"Search_Chunk21.xml\" /><stem n=\"coordspac\" chunk=\"Search_Chunk21.xml\" /><stem n=\"50x50\" chunk=\"Search_Chunk21.xml\" /><stem n=\"quarter\" chunk=\"Search_Chunk21.xml\" /><stem n=\"let\" chunk=\"Search_Chunk21.xml\" /><stem n=\"outsid\" chunk=\"Search_Chunk21.xml\" /><stem n=\"occupi\" chunk=\"Search_Chunk21.xml\" /><stem n=\"think\" chunk=\"Search_Chunk21.xml\" /><stem n=\"equival\" chunk=\"Search_Chunk21.xml\" /><stem n=\"49\" chunk=\"Search_Chunk21.xml\" /><stem n=\"25\" chunk=\"Search_Chunk21.xml\" /><stem n=\"strong\" chunk=\"Search_Chunk21.xml\" /><stem n=\"encourag\" chunk=\"Search_Chunk21.xml\" /><stem n=\"understand\" chunk=\"Search_Chunk21.xml\" /><stem n=\"materi\" chunk=\"Search_Chunk21.xml\" /><stem n=\"25x25\" chunk=\"Search_Chunk21.xml\" /><stem n=\"modulo\" chunk=\"Search_Chunk21.xml\" /><stem n=\"off\" chunk=\"Search_Chunk21.xml\" /><stem n=\"24\" chunk=\"Search_Chunk21.xml\" /><stem n=\"straight\" chunk=\"Search_Chunk21.xml\" /><stem n=\"forward\" chunk=\"Search_Chunk21.xml\" /><stem n=\"say\" chunk=\"Search_Chunk21.xml\" /><stem n=\"second\" chunk=\"Search_Chunk21.xml\" /><stem n=\"realli\" chunk=\"Search_Chunk21.xml\" /><stem n=\"variat\" chunk=\"Search_Chunk21.xml\" /><stem n=\"recal\" chunk=\"Search_Chunk21.xml\" /><stem n=\"happen\" chunk=\"Search_Chunk21.xml\" /><stem n=\"125\" chunk=\"Search_Chunk21.xml\" /><stem n=\"125x125\" chunk=\"Search_Chunk21.xml\" /><stem n=\"edg\" chunk=\"Search_Chunk21.xml\" /><stem n=\"could\" chunk=\"Search_Chunk21.xml\" /><stem n=\"argu\" chunk=\"Search_Chunk21.xml\" /><stem n=\"bug\" chunk=\"Search_Chunk21.xml\" /><stem n=\"nice\" chunk=\"Search_Chunk21.xml\" /><stem n=\"arbitrarili\" chunk=\"Search_Chunk21.xml\" /><stem n=\"along\" chunk=\"Search_Chunk21.xml\" /><stem n=\"stock\" chunk=\"Search_Chunk21.xml\" /><stem n=\"32x32\" chunk=\"Search_Chunk21.xml\" /><stem n=\"icon\" chunk=\"Search_Chunk21.xml\" /><stem n=\"they\'d\" chunk=\"Search_Chunk21.xml\" /><stem n=\"1x1\" chunk=\"Search_Chunk21.xml\" /><stem n=\"prefer\" chunk=\"Search_Chunk21.xml\" /><stem n=\"32929\" chunk=\"Search_Chunk21.xml\" /><stem n=\"28292\" chunk=\"Search_Chunk21.xml\" /><stem n=\"0005\" chunk=\"Search_Chunk21.xml\" /><stem n=\"accomod\" chunk=\"Search_Chunk21.xml\" /><stem n=\"100\" chunk=\"Search_Chunk21.xml\" /><stem n=\"1000\" chunk=\"Search_Chunk21.xml\" /><stem n=\"500\" chunk=\"Search_Chunk21.xml\" /><stem n=\"conclud\" chunk=\"Search_Chunk21.xml\" /><stem n=\"group\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ul\" chunk=\"Search_Chunk21.xml\" /><stem n=\"pictur\" chunk=\"Search_Chunk21.xml\" /><stem n=\"99\" chunk=\"Search_Chunk21.xml\" /><stem n=\"1090\" chunk=\"Search_Chunk21.xml\" /><stem n=\"445\" chunk=\"Search_Chunk21.xml\" /><stem n=\"250\" chunk=\"Search_Chunk21.xml\" /><stem n=\"590\" chunk=\"Search_Chunk21.xml\" /><stem n=\"195\" chunk=\"Search_Chunk21.xml\" /><stem n=\"350\" chunk=\"Search_Chunk21.xml\" /><stem n=\"75\" chunk=\"Search_Chunk21.xml\" /><stem n=\"quadrant\" chunk=\"Search_Chunk21.xml\" /><stem n=\"shift\" chunk=\"Search_Chunk21.xml\" /><stem n=\"+\" chunk=\"Search_Chunk21.xml\" /><stem n=\"drag\" chunk=\"Search_Chunk21.xml\" /><stem n=\"drop\" chunk=\"Search_Chunk21.xml\" /><stem n=\"menu\" chunk=\"Search_Chunk21.xml\" /><stem n=\"item\" chunk=\"Search_Chunk21.xml\" /><stem n=\"overrid\" chunk=\"Search_Chunk21.xml\" /><stem n=\"negat\" chunk=\"Search_Chunk21.xml\" /><stem n=\"behavior\" chunk=\"Search_Chunk21.xml\" /><stem n=\"inquir\" chunk=\"Search_Chunk21.xml\" /><stem n=\"recomput\" chunk=\"Search_Chunk21.xml\" /><stem n=\"loop\" chunk=\"Search_Chunk21.xml\" /><stem n=\"min_length\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ipow\" chunk=\"Search_Chunk21.xml\" /><stem n=\"n+1\" chunk=\"Search_Chunk21.xml\" /><stem n=\"break\" chunk=\"Search_Chunk21.xml\" /><stem n=\"4089\" chunk=\"Search_Chunk21.xml\" /><stem n=\"2041\" chunk=\"Search_Chunk21.xml\" /><stem n=\"57\" chunk=\"Search_Chunk21.xml\" /><stem n=\"mg2writerparam\" chunk=\"Search_Chunk21.xml\" /><stem n=\"clamp\" chunk=\"Search_Chunk21.xml\" /><stem n=\"equat\" chunk=\"Search_Chunk21.xml\" /><stem n=\"factor\" chunk=\"Search_Chunk21.xml\" /><stem n=\"fall\" chunk=\"Search_Chunk21.xml\" /><stem n=\"minwh\" chunk=\"Search_Chunk21.xml\" /><stem n=\"min\" chunk=\"Search_Chunk21.xml\" /><stem n=\"++n\" chunk=\"Search_Chunk21.xml\" /><stem n=\"mg3writerparam\" chunk=\"Search_Chunk21.xml\" /><stem n=\"mg4writerparam\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ident\" chunk=\"Search_Chunk21.xml\" /><stem n=\"jp2writerparam\" chunk=\"Search_Chunk21.xml\" /><stem n=\"512x512\" chunk=\"Search_Chunk21.xml\" /><stem n=\"obtain\" chunk=\"Search_Chunk21.xml\" /><stem n=\"256x256\" chunk=\"Search_Chunk21.xml\" /><stem n=\"16x16\" chunk=\"Search_Chunk21.xml\" /><stem n=\"8x8\" chunk=\"Search_Chunk21.xml\" /><stem n=\"guidelin\" chunk=\"Search_Chunk21.xml\" /><stem n=\"expect\" chunk=\"Search_Chunk21.xml\" /><stem n=\"adher\" chunk=\"Search_Chunk21.xml\" /><stem n=\"syntact\" chunk=\"Search_Chunk21.xml\" /><stem n=\"practic\" chunk=\"Search_Chunk21.xml\" /><stem n=\"histor\" chunk=\"Search_Chunk21.xml\" /><stem n=\"deviat\" chunk=\"Search_Chunk21.xml\" /><stem n=\"78\" chunk=\"Search_Chunk21.xml\" /><stem n=\"column\" chunk=\"Search_Chunk21.xml\" /><stem n=\"wordwrap\" chunk=\"Search_Chunk21.xml\" /><stem n=\"tab\" chunk=\"Search_Chunk21.xml\" /><stem n=\"namespac\" chunk=\"Search_Chunk21.xml\" /><stem n=\"surround\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_begin_namespac\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_end_namespac\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_use_namespac\" chunk=\"Search_Chunk21.xml\" /><stem n=\"warn\" chunk=\"Search_Chunk21.xml\" /><stem n=\"win32\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_compiler_m\" chunk=\"Search_Chunk21.xml\" /><stem n=\"pragma\" chunk=\"Search_Chunk21.xml\" /><stem n=\"push\" chunk=\"Search_Chunk21.xml\" /><stem n=\"endif\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ppop\" chunk=\"Search_Chunk21.xml\" /><stem n=\"spell\" chunk=\"Search_Chunk21.xml\" /><stem n=\"camelcas\" chunk=\"Search_Chunk21.xml\" /><stem n=\"upperleftpo\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getupperleft\" chunk=\"Search_Chunk21.xml\" /><stem n=\"m_\" chunk=\"Search_Chunk21.xml\" /><stem n=\"m_xposit\" chunk=\"Search_Chunk21.xml\" /><stem n=\"s_\" chunk=\"Search_Chunk21.xml\" /><stem n=\"s_twopi\" chunk=\"Search_Chunk21.xml\" /><stem n=\"capit\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_uint8\" chunk=\"Search_Chunk21.xml\" /><stem n=\"uppercas\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lti_datatype_uint8\" chunk=\"Search_Chunk21.xml\" /><stem n=\"typedef\'d\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lead\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lti_geocoord\" chunk=\"Search_Chunk21.xml\" /><stem n=\"match\" chunk=\"Search_Chunk21.xml\" /><stem n=\"mg4imagewrit\" chunk=\"Search_Chunk21.xml\" /><stem n=\"precaut\" chunk=\"Search_Chunk21.xml\" /><stem n=\"invalid\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_sts_uninit\" chunk=\"Search_Chunk21.xml\" /><stem n=\"spare\" chunk=\"Search_Chunk21.xml\" /><stem n=\"burden\" chunk=\"Search_Chunk21.xml\" /><stem n=\"prone\" chunk=\"Search_Chunk21.xml\" /><stem n=\"altern\" chunk=\"Search_Chunk21.xml\" /><stem n=\"idiom\" chunk=\"Search_Chunk21.xml\" /><stem n=\"sts\" chunk=\"Search_Chunk21.xml\" /><stem n=\"bar\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_success\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_sts_success\" chunk=\"Search_Chunk21.xml\" /><stem n=\"hardwir\" chunk=\"Search_Chunk21.xml\" /><stem n=\"downstream\" chunk=\"Search_Chunk21.xml\" /><stem n=\"owner\" chunk=\"Search_Chunk21.xml\" /><stem n=\"doesn\'t\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltimagestag\" chunk=\"Search_Chunk21.xml\" /><stem n=\"mixin\" chunk=\"Search_Chunk21.xml\" /><stem n=\"accessor\" chunk=\"Search_Chunk21.xml\" /><stem n=\"whenev\" chunk=\"Search_Chunk21.xml\" /><stem n=\"reassign\" chunk=\"Search_Chunk21.xml\" /><stem n=\"null\" chunk=\"Search_Chunk21.xml\" /><stem n=\"exclud\" chunk=\"Search_Chunk21.xml\" /><stem n=\"clarifi\" chunk=\"Search_Chunk21.xml\" /><stem n=\"intent\" chunk=\"Search_Chunk21.xml\" /><stem n=\"disabl\" chunk=\"Search_Chunk21.xml\" /><stem n=\"assign\" chunk=\"Search_Chunk21.xml\" /><stem n=\"privat\" chunk=\"Search_Chunk21.xml\" /><stem n=\"warrant\" chunk=\"Search_Chunk21.xml\" /><stem n=\"inlin\" chunk=\"Search_Chunk21.xml\" /><stem n=\"bloat\" chunk=\"Search_Chunk21.xml\" /><stem n=\"modul\" chunk=\"Search_Chunk21.xml\" /><stem n=\"though\" chunk=\"Search_Chunk21.xml\" /><stem n=\"global\" chunk=\"Search_Chunk21.xml\" /><stem n=\"singleton\" chunk=\"Search_Chunk21.xml\" /><stem n=\"threadsafeti\" chunk=\"Search_Chunk21.xml\" /><stem n=\"safe\" chunk=\"Search_Chunk21.xml\" /><stem n=\"multithread\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lock\" chunk=\"Search_Chunk21.xml\" /><stem n=\"guarante\" chunk=\"Search_Chunk21.xml\" /><stem n=\"serial\" chunk=\"Search_Chunk21.xml\" /><stem n=\"assert\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_assert\" chunk=\"Search_Chunk21.xml\" /><stem n=\"liber\" chunk=\"Search_Chunk21.xml\" /><stem n=\"handler\" chunk=\"Search_Chunk21.xml\" /><stem n=\"discourag\" chunk=\"Search_Chunk21.xml\" /><stem n=\"hand\" chunk=\"Search_Chunk21.xml\" /><stem n=\"justifi\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getwidth\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getheight\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lti_imagefilt\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lti_imagestageoverrid\" chunk=\"Search_Chunk21.xml\" /><stem n=\"mycropfilt\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridedimens\" chunk=\"Search_Chunk21.xml\" /><stem n=\"lt_uint32\" chunk=\"Search_Chunk21.xml\" /><stem n=\"newwidth\" chunk=\"Search_Chunk21.xml\" /><stem n=\"newheight\" chunk=\"Search_Chunk21.xml\" /><stem n=\"setdimens\" chunk=\"Search_Chunk21.xml\" /><stem n=\"myfilt\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridexxx\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverrideyyy\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioveridezzz\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridemetadata\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getmetadata\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridepixelprop\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getpixelprop\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getmindynamicrang\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getmaxdynamicrang\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridenodatapixel\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getnodatapixel\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getbackgroundpixel\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridegeocoord\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getgeocoord\" chunk=\"Search_Chunk21.xml\" /><stem n=\"isgeocoordimplicit\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridemagnif\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getminmagnif\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getmaxmagnif\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverrideisselectivedata\" chunk=\"Search_Chunk21.xml\" /><stem n=\"isselect\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridestripheight\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getstripheight\" chunk=\"Search_Chunk21.xml\" /><stem n=\"setstripheight\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridedeleg\" chunk=\"Search_Chunk21.xml\" /><stem n=\"setprogressdeleg\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getprogressdeleg\" chunk=\"Search_Chunk21.xml\" /><stem n=\"setinterruptdeleg\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getinterruptdeleg\" chunk=\"Search_Chunk21.xml\" /><stem n=\"ltioverridepixellookupt\" chunk=\"Search_Chunk21.xml\" /><stem n=\"getpixellookupt\" chunk=\"Search_Chunk21.xml\" /><stem n=\"classnam\" chunk=\"Search_Chunk21.xml\" /><stem n=\"thumb\" chunk=\"Search_Chunk21.xml\" /><stem n=\"createimagestag\" chunk=\"Search_Chunk21.xml\" /><stem n=\"aliv\" chunk=\"Search_Chunk21.xml\" /><stem n=\"myimagefilt\" chunk=\"Search_Chunk21.xml\" /><stem n=\"reus\" chunk=\"Search_Chunk21.xml\" /><stem n=\"someth\" chunk=\"Search_Chunk21.xml\" /><stem n=\"+1\" chunk=\"Search_Chunk21.xml\" /><stem n=\"eleventh\" chunk=\"Search_Chunk21.xml\" /><stem n=\"prior\" chunk=\"Search_Chunk21.xml\" /><stem n=\"undefin\" chunk=\"Search_Chunk21.xml\" /><stem n=\"behalf\" chunk=\"Search_Chunk21.xml\" /><stem n=\"eof\" chunk=\"Search_Chunk21.xml\" /><stem n=\"flag\" chunk=\"Search_Chunk22.xml\" /><stem n=\"fals\" chunk=\"Search_Chunk22.xml\" /><stem n=\"dealloc\" chunk=\"Search_Chunk22.xml\" /><stem n=\"restor\" chunk=\"Search_Chunk22.xml\" /><stem n=\"strict\" chunk=\"Search_Chunk22.xml\" /><stem n=\"speak\" chunk=\"Search_Chunk22.xml\" /><stem n=\"destructor\" chunk=\"Search_Chunk22.xml\" /><stem n=\"bad\" chunk=\"Search_Chunk22.xml\" /><stem n=\"len\" chunk=\"Search_Chunk22.xml\" /><stem n=\"remain\" chunk=\"Search_Chunk22.xml\" /><stem n=\"desir\" chunk=\"Search_Chunk22.xml\" /><stem n=\"occur\" chunk=\"Search_Chunk22.xml\" /><stem n=\"getlasterror\" chunk=\"Search_Chunk22.xml\" /><stem n=\"reset\" chunk=\"Search_Chunk22.xml\" /><stem n=\"mere\" chunk=\"Search_Chunk22.xml\" /><stem n=\"duplic\" chunk=\"Search_Chunk22.xml\" /><stem n=\"newli\" chunk=\"Search_Chunk22.xml\" /><stem n=\"fail\" chunk=\"Search_Chunk22.xml\" /><stem n=\"minim\" chunk=\"Search_Chunk22.xml\" /><stem n=\"lt_sts_failur\" chunk=\"Search_Chunk22.xml\" /><stem n=\"wb\" chunk=\"Search_Chunk22.xml\" /><stem n=\"r+\" chunk=\"Search_Chunk22.xml\" /><stem n=\"notion\" chunk=\"Search_Chunk22.xml\" /><stem n=\"fill\" chunk=\"Search_Chunk22.xml\" /><stem n=\"auxilliari\" chunk=\"Search_Chunk22.xml\" /><stem n=\"georefer\" chunk=\"Search_Chunk22.xml\" /><stem n=\"pertain\" chunk=\"Search_Chunk22.xml\" /><stem n=\"charact\" chunk=\"Search_Chunk22.xml\" /><stem n=\"bainbridg\" chunk=\"Search_Chunk22.xml\" /><stem n=\"tfw\" chunk=\"Search_Chunk22.xml\" /><stem n=\"madison\" chunk=\"Search_Chunk22.xml\" /><stem n=\"sdw\" chunk=\"Search_Chunk22.xml\" /><stem n=\"trail\" chunk=\"Search_Chunk22.xml\" /><stem n=\"whitespac\" chunk=\"Search_Chunk22.xml\" /><stem n=\"unit\" chunk=\"Search_Chunk22.xml\" /><stem n=\"ignor\" chunk=\"Search_Chunk22.xml\" /><stem n=\"wari\" chunk=\"Search_Chunk22.xml\" /><stem n=\"roundoff\" chunk=\"Search_Chunk22.xml\" /><stem n=\"imprecis\" chunk=\"Search_Chunk22.xml\" /><stem n=\"scanf\" chunk=\"Search_Chunk22.xml\" /><stem n=\"printf\" chunk=\"Search_Chunk22.xml\" /><stem n=\"20000000\" chunk=\"Search_Chunk22.xml\" /><stem n=\"00000000\" chunk=\"Search_Chunk22.xml\" /><stem n=\"780\" chunk=\"Search_Chunk22.xml\" /><stem n=\"10000000\" chunk=\"Search_Chunk22.xml\" /><stem n=\"219\" chunk=\"Search_Chunk22.xml\" /><stem n=\"90000000\" chunk=\"Search_Chunk22.xml\" /><stem n=\"interleav\" chunk=\"Search_Chunk22.xml\" /><stem n=\"edit\" chunk=\"Search_Chunk22.xml\" /><stem n=\"denomin\" chunk=\"Search_Chunk22.xml\" /><stem n=\"keyword\" chunk=\"Search_Chunk22.xml\" /><stem n=\"hdr\" chunk=\"Search_Chunk22.xml\" /><stem n=\"insensit\" chunk=\"Search_Chunk22.xml\" /><stem n=\"preced\" chunk=\"Search_Chunk22.xml\" /><stem n=\"comment\" chunk=\"Search_Chunk22.xml\" /><stem n=\"bandgapbyt\" chunk=\"Search_Chunk22.xml\" /><stem n=\"bandrowbyt\" chunk=\"Search_Chunk22.xml\" /><stem n=\"nband\" chunk=\"Search_Chunk22.xml\" /><stem n=\"byte_ord\" chunk=\"Search_Chunk22.xml\" /><stem n=\"interpret\" chunk=\"Search_Chunk22.xml\" /><stem n=\"motorola\" chunk=\"Search_Chunk22.xml\" /><stem n=\"m\" chunk=\"Search_Chunk22.xml\" /><stem n=\"bigendian\" chunk=\"Search_Chunk22.xml\" /><stem n=\"littleendian\" chunk=\"Search_Chunk22.xml\" /><stem n=\"na\" chunk=\"Search_Chunk22.xml\" /><stem n=\"byteord\" chunk=\"Search_Chunk22.xml\" /><stem n=\"grey\" chunk=\"Search_Chunk22.xml\" /><stem n=\"gray\" chunk=\"Search_Chunk22.xml\" /><stem n=\"col\" chunk=\"Search_Chunk22.xml\" /><stem n=\"ncol\" chunk=\"Search_Chunk22.xml\" /><stem n=\"u8\" chunk=\"Search_Chunk22.xml\" /><stem n=\"u16\" chunk=\"Search_Chunk22.xml\" /><stem n=\"f32\" chunk=\"Search_Chunk22.xml\" /><stem n=\"dynamicrangelevel\" chunk=\"Search_Chunk22.xml\" /><stem n=\"midpoint\" chunk=\"Search_Chunk22.xml\" /><stem n=\"dynamicrangemax\" chunk=\"Search_Chunk22.xml\" /><stem n=\"dynamicrangemin\" chunk=\"Search_Chunk22.xml\" /><stem n=\"dynamicrangewindow\" chunk=\"Search_Chunk22.xml\" /><stem n=\"e_squar\" chunk=\"Search_Chunk22.xml\" /><stem n=\"sphere\" chunk=\"Search_Chunk22.xml\" /><stem n=\"eccentr\" chunk=\"Search_Chunk22.xml\" /><stem n=\"squar\" chunk=\"Search_Chunk22.xml\" /><stem n=\"map_unit\" chunk=\"Search_Chunk22.xml\" /><stem n=\"measur\" chunk=\"Search_Chunk22.xml\" /><stem n=\"65535\" chunk=\"Search_Chunk22.xml\" /><stem n=\"nbit\" chunk=\"Search_Chunk22.xml\" /><stem n=\"2^31\" chunk=\"Search_Chunk22.xml\" /><stem n=\"nrow\" chunk=\"Search_Chunk22.xml\" /><stem n=\"pixel_height\" chunk=\"Search_Chunk22.xml\" /><stem n=\"ydim\" chunk=\"Search_Chunk22.xml\" /><stem n=\"pixel_width\" chunk=\"Search_Chunk22.xml\" /><stem n=\"xdim\" chunk=\"Search_Chunk22.xml\" /><stem n=\"projection_nam\" chunk=\"Search_Chunk22.xml\" /><stem n=\"projection_paramet\" chunk=\"Search_Chunk22.xml\" /><stem n=\"projection_zon\" chunk=\"Search_Chunk22.xml\" /><stem n=\"zone\" chunk=\"Search_Chunk22.xml\" /><stem n=\"int32\" chunk=\"Search_Chunk22.xml\" /><stem n=\"radius\" chunk=\"Search_Chunk22.xml\" /><stem n=\"semi_major_axi\" chunk=\"Search_Chunk22.xml\" /><stem n=\"semimajor\" chunk=\"Search_Chunk22.xml\" /><stem n=\"axi\" chunk=\"Search_Chunk22.xml\" /><stem n=\"semi_minor_axi\" chunk=\"Search_Chunk22.xml\" /><stem n=\"semiminor\" chunk=\"Search_Chunk22.xml\" /><stem n=\"skipbyt\" chunk=\"Search_Chunk22.xml\" /><stem n=\"skip\" chunk=\"Search_Chunk22.xml\" /><stem n=\"spheroid_nam\" chunk=\"Search_Chunk22.xml\" /><stem n=\"totalrowbyt\" chunk=\"Search_Chunk22.xml\" /><stem n=\"ul_x_coordin\" chunk=\"Search_Chunk22.xml\" /><stem n=\"ulxmap\" chunk=\"Search_Chunk22.xml\" /><stem n=\"ul_y_coordin\" chunk=\"Search_Chunk22.xml\" /><stem n=\"ulymap\" chunk=\"Search_Chunk22.xml\" /><stem n=\"upperleft\" chunk=\"Search_Chunk22.xml\" /><stem n=\"wordlength\" chunk=\"Search_Chunk22.xml\" /><stem n=\"overridden\" chunk=\"Search_Chunk22.xml\" /><stem n=\"colorspacelayout\" chunk=\"Search_Chunk22.xml\" /><stem n=\"640x480\" chunk=\"Search_Chunk22.xml\" /><stem n=\"480\" chunk=\"Search_Chunk22.xml\" /><stem n=\"640\" chunk=\"Search_Chunk22.xml\" /><stem n=\"vendor\" chunk=\"Search_Chunk22.xml\" /><stem n=\"geotiffmetadata\" chunk=\"Search_Chunk22.xml\" /><stem n=\"box\" chunk=\"Search_Chunk22.xml\" /><stem n=\"30\" chunk=\"Search_Chunk22.xml\" /><stem n=\"michael\" chunk=\"Search_Chunk22.xml\" /><stem n=\"p\" chunk=\"Search_Chunk22.xml\" /><stem n=\"gerlek\" chunk=\"Search_Chunk22.xml\" /><stem n=\"editor\" chunk=\"Search_Chunk22.xml\" /><stem n=\"mpg\" chunk=\"Search_Chunk22.xml\" /><stem n=\"dot\" chunk=\"Search_Chunk22.xml\" /><stem n=\"inc\" chunk=\"Search_Chunk22.xml\" /><stem n=\"1008\" chunk=\"Search_Chunk22.xml\" /><stem n=\"western\" chunk=\"Search_Chunk22.xml\" /><stem n=\"ave\" chunk=\"Search_Chunk22.xml\" /><stem n=\"suit\" chunk=\"Search_Chunk22.xml\" /><stem n=\"403\" chunk=\"Search_Chunk22.xml\" /><stem n=\"seattl\" chunk=\"Search_Chunk22.xml\" /><stem n=\"wa\" chunk=\"Search_Chunk22.xml\" /><stem n=\"98104\" chunk=\"Search_Chunk22.xml\" /><stem n=\"usa\" chunk=\"Search_Chunk22.xml\" /><stem n=\"editori\" chunk=\"Search_Chunk22.xml\" /><stem n=\"bracket\" chunk=\"Search_Chunk22.xml\" /><stem n=\"asid\" chunk=\"Search_Chunk22.xml\" /><stem n=\"disclaim\" chunk=\"Search_Chunk22.xml\" /><stem n=\"©\" chunk=\"Search_Chunk22.xml\" /><stem n=\"celartem\" chunk=\"Search_Chunk22.xml\" /><stem n=\"do\" chunk=\"Search_Chunk22.xml\" /><stem n=\"permiss\" chunk=\"Search_Chunk22.xml\" /><stem n=\"fee\" chunk=\"Search_Chunk22.xml\" /><stem n=\"grant\" chunk=\"Search_Chunk22.xml\" /><stem n=\"liabil\" chunk=\"Search_Chunk22.xml\" /><stem n=\"incident\" chunk=\"Search_Chunk22.xml\" /><stem n=\"indirect\" chunk=\"Search_Chunk22.xml\" /><stem n=\"consequ\" chunk=\"Search_Chunk22.xml\" /><stem n=\"damag\" chunk=\"Search_Chunk22.xml\" /><stem n=\"whatsoev\" chunk=\"Search_Chunk22.xml\" /><stem n=\"profit\" chunk=\"Search_Chunk22.xml\" /><stem n=\"advis\" chunk=\"Search_Chunk22.xml\" /><stem n=\"theori\" chunk=\"Search_Chunk22.xml\" /><stem n=\"aris\" chunk=\"Search_Chunk22.xml\" /><stem n=\"confus\" chunk=\"Search_Chunk22.xml\" /><stem n=\"peopl\" chunk=\"Search_Chunk22.xml\" /><stem n=\"worthwhil\" chunk=\"Search_Chunk22.xml\" /><stem n=\"paper\" chunk=\"Search_Chunk22.xml\" /><stem n=\"review\" chunk=\"Search_Chunk22.xml\" /><stem n=\"codifi\" chunk=\"Search_Chunk22.xml\" /><stem n=\"modif\" chunk=\"Search_Chunk22.xml\" /><stem n=\"histori\" chunk=\"Search_Chunk22.xml\" /><stem n=\"scienc\" chunk=\"Search_Chunk22.xml\" /><stem n=\"msi\" chunk=\"Search_Chunk22.xml\" /><stem n=\"geojp2\" chunk=\"Search_Chunk22.xml\" /><stem n=\"tm\" chunk=\"Search_Chunk22.xml\" /><stem n=\"asset\" chunk=\"Search_Chunk22.xml\" /><stem n=\"anyon\" chunk=\"Search_Chunk22.xml\" /><stem n=\"neither\" chunk=\"Search_Chunk22.xml\" /><stem n=\"nor\" chunk=\"Search_Chunk22.xml\" /><stem n=\"proprietari\" chunk=\"Search_Chunk22.xml\" /><stem n=\"trademark\" chunk=\"Search_Chunk22.xml\" /><stem n=\"encumb\" chunk=\"Search_Chunk22.xml\" /><stem n=\"uuid\" chunk=\"Search_Chunk22.xml\" /><stem n=\"degener\" chunk=\"Search_Chunk22.xml\" /><stem n=\"wld\" chunk=\"Search_Chunk22.xml\" /><stem n=\"presenc\" chunk=\"Search_Chunk22.xml\" /><stem n=\"compliant\" chunk=\"Search_Chunk22.xml\" /><stem n=\"codestream\" chunk=\"Search_Chunk22.xml\" /><stem n=\"geotiff_box\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xb1\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x4b\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xf8\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xbd\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x08\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x3d\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x43\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xa5\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xae\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x8c\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xd7\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xd5\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xa6\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xce\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x03\" chunk=\"Search_Chunk22.xml\" /><stem n=\"unreleas\" chunk=\"Search_Chunk22.xml\" /><stem n=\"seem\" chunk=\"Search_Chunk22.xml\" /><stem n=\"corrupt\" chunk=\"Search_Chunk22.xml\" /><stem n=\"abl\" chunk=\"Search_Chunk22.xml\" /><stem n=\"bitdepth\" chunk=\"Search_Chunk22.xml\" /><stem n=\"mayb\" chunk=\"Search_Chunk22.xml\" /><stem n=\"my\" chunk=\"Search_Chunk22.xml\" /><stem n=\"flesh\" chunk=\"Search_Chunk22.xml\" /><stem n=\"confid\" chunk=\"Search_Chunk22.xml\" /><stem n=\"publish\" chunk=\"Search_Chunk22.xml\" /><stem n=\"feel\" chunk=\"Search_Chunk22.xml\" /><stem n=\"chunk\" chunk=\"Search_Chunk22.xml\" /><stem n=\"geoposit\" chunk=\"Search_Chunk22.xml\" /><stem n=\"obsolet\" chunk=\"Search_Chunk22.xml\" /><stem n=\"world_box\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x96\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xa9\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xf1\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xdc\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x98\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x40\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x2d\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xa7\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xd6\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x8e\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x34\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x45\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x18\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x09\" chunk=\"Search_Chunk22.xml\" /><stem n=\"laid\" chunk=\"Search_Chunk22.xml\" /><stem n=\"contigu\" chunk=\"Search_Chunk22.xml\" /><stem n=\"footer\" chunk=\"Search_Chunk22.xml\" /><stem n=\"minor\" chunk=\"Search_Chunk22.xml\" /><stem n=\"anyth\" chunk=\"Search_Chunk22.xml\" /><stem n=\"13\" chunk=\"Search_Chunk22.xml\" /><stem n=\"leav\" chunk=\"Search_Chunk22.xml\" /><stem n=\"appar\" chunk=\"Search_Chunk22.xml\" /><stem n=\"21\" chunk=\"Search_Chunk22.xml\" /><stem n=\"22\" chunk=\"Search_Chunk22.xml\" /><stem n=\"29\" chunk=\"Search_Chunk22.xml\" /><stem n=\"37\" chunk=\"Search_Chunk22.xml\" /><stem n=\"38\" chunk=\"Search_Chunk22.xml\" /><stem n=\"45\" chunk=\"Search_Chunk22.xml\" /><stem n=\"46\" chunk=\"Search_Chunk22.xml\" /><stem n=\"53\" chunk=\"Search_Chunk22.xml\" /><stem n=\"institut\" chunk=\"Search_Chunk22.xml\" /><stem n=\"03\" chunk=\"Search_Chunk22.xml\" /><stem n=\"signifi\" chunk=\"Search_Chunk22.xml\" /><stem n=\"minus\" chunk=\"Search_Chunk22.xml\" /><stem n=\"unknown\" chunk=\"Search_Chunk22.xml\" /><stem n=\"come\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0xff\" chunk=\"Search_Chunk22.xml\" /><stem n=\"0x00\" chunk=\"Search_Chunk22.xml\" /><stem n=\"necessari\" chunk=\"Search_Chunk22.xml\" /><stem n=\"commentari\" chunk=\"Search_Chunk22.xml\" /><stem n=\"low\" chunk=\"Search_Chunk22.xml\" /><stem n=\"catalog\" chunk=\"Search_Chunk22.xml\" /><stem n=\"accur\" chunk=\"Search_Chunk23.xml\" /><stem n=\"utm\" chunk=\"Search_Chunk23.xml\" /><stem n=\"mgrs\" chunk=\"Search_Chunk23.xml\" /><stem n=\"wgs84\" chunk=\"Search_Chunk23.xml\" /><stem n=\"lat\" chunk=\"Search_Chunk23.xml\" /><stem n=\"decim\" chunk=\"Search_Chunk23.xml\" /><stem n=\"degre\" chunk=\"Search_Chunk23.xml\" /><stem n=\"86\" chunk=\"Search_Chunk23.xml\" /><stem n=\"ccs\" chunk=\"Search_Chunk23.xml\" /><stem n=\"colloc\" chunk=\"Search_Chunk23.xml\" /><stem n=\"iloc\" chunk=\"Search_Chunk23.xml\" /><stem n=\"ialvl\" chunk=\"Search_Chunk23.xml\" /><stem n=\"idlvl\" chunk=\"Search_Chunk23.xml\" /><stem n=\"z\" chunk=\"Search_Chunk23.xml\" /><stem n=\"lowest\" chunk=\"Search_Chunk23.xml\" /><stem n=\"attach\" chunk=\"Search_Chunk23.xml\" /><stem n=\"999\" chunk=\"Search_Chunk23.xml\" /><stem n=\"40kx40k\" chunk=\"Search_Chunk23.xml\" /><stem n=\"120\" chunk=\"Search_Chunk23.xml\" /><stem n=\"obvious\" chunk=\"Search_Chunk23.xml\" /><stem n=\"spread\" chunk=\"Search_Chunk23.xml\" /><stem n=\"far\" chunk=\"Search_Chunk23.xml\" /><stem n=\"apart\" chunk=\"Search_Chunk23.xml\" /><stem n=\"1kx1k\" chunk=\"Search_Chunk23.xml\" /><stem n=\"150\" chunk=\"Search_Chunk23.xml\" /><stem n=\"97\" chunk=\"Search_Chunk23.xml\" /><stem n=\"blocka\" chunk=\"Search_Chunk23.xml\" /><stem n=\"repeat\" chunk=\"Search_Chunk23.xml\" /><stem n=\"loc\" chunk=\"Search_Chunk23.xml\" /><stem n=\"stdi\" chunk=\"Search_Chunk23.xml\" /><stem n=\"0002\" chunk=\"Search_Chunk23.xml\" /><stem n=\"83\" chunk=\"Search_Chunk23.xml\" /><stem n=\"crses\" chunk=\"Search_Chunk23.xml\" /><stem n=\"care\" chunk=\"Search_Chunk23.xml\" /><stem n=\"reveal\" chunk=\"Search_Chunk23.xml\" /><stem n=\"absent\" chunk=\"Search_Chunk23.xml\" /><stem n=\"know\" chunk=\"Search_Chunk23.xml\" /><stem n=\"noth\" chunk=\"Search_Chunk23.xml\" /><stem n=\"empti\" chunk=\"Search_Chunk23.xml\" /><stem n=\"multipli\" chunk=\"Search_Chunk23.xml\" /><stem n=\"good\" chunk=\"Search_Chunk23.xml\" /><stem n=\"have\" chunk=\"Search_Chunk23.xml\" /><stem n=\"100k\" chunk=\"Search_Chunk23.xml\" /><stem n=\"recov\" chunk=\"Search_Chunk23.xml\" /><stem n=\"convey\" chunk=\"Search_Chunk23.xml\" /><stem n=\"supplement\" chunk=\"Search_Chunk23.xml\" /><stem n=\"evalu\" chunk=\"Search_Chunk23.xml\" /><stem n=\"bits_per_sampl\" chunk=\"Search_Chunk23.xml\" /><stem n=\"uint16\" chunk=\"Search_Chunk23.xml\" /><stem n=\"color_schem\" chunk=\"Search_Chunk23.xml\" /><stem n=\"uint32\" chunk=\"Search_Chunk23.xml\" /><stem n=\"data_typ\" chunk=\"Search_Chunk23.xml\" /><stem n=\"default_data_valu\" chunk=\"Search_Chunk23.xml\" /><stem n=\"uint8\" chunk=\"Search_Chunk23.xml\" /><stem n=\"no_data_valu\" chunk=\"Search_Chunk23.xml\" /><stem n=\"dynamic_range_window\" chunk=\"Search_Chunk23.xml\" /><stem n=\"contrast\" chunk=\"Search_Chunk23.xml\" /><stem n=\"dynamic_range_level\" chunk=\"Search_Chunk23.xml\" /><stem n=\"bright\" chunk=\"Search_Chunk23.xml\" /><stem n=\"encoding_appl\" chunk=\"Search_Chunk23.xml\" /><stem n=\"encoding_com\" chunk=\"Search_Chunk23.xml\" /><stem n=\"eom\" chunk=\"Search_Chunk23.xml\" /><stem n=\"input_file_s\" chunk=\"Search_Chunk23.xml\" /><stem n=\"input_format\" chunk=\"Search_Chunk23.xml\" /><stem n=\"input_lut\" chunk=\"Search_Chunk23.xml\" /><stem n=\"256\" chunk=\"Search_Chunk23.xml\" /><stem n=\"r\" chunk=\"Search_Chunk23.xml\" /><stem n=\"input_nam\" chunk=\"Search_Chunk23.xml\" /><stem n=\"lti_esdk_vers\" chunk=\"Search_Chunk23.xml\" /><stem n=\"quantization_scal\" chunk=\"Search_Chunk23.xml\" /><stem n=\"som\" chunk=\"Search_Chunk23.xml\" /><stem n=\"transparent_data_valu\" chunk=\"Search_Chunk23.xml\" /><stem n=\"x_resolut\" chunk=\"Search_Chunk23.xml\" /><stem n=\"xy_origin\" chunk=\"Search_Chunk23.xml\" /><stem n=\"y_resolut\" chunk=\"Search_Chunk23.xml\" /><stem n=\"rate\" chunk=\"Search_Chunk23.xml\" /><stem n=\"did\" chunk=\"Search_Chunk23.xml\" /><stem n=\"discard\" chunk=\"Search_Chunk23.xml\" /><stem n=\"interpol\" chunk=\"Search_Chunk23.xml\" /><stem n=\"decomposit\" chunk=\"Search_Chunk23.xml\" /><stem n=\"reconstruct\" chunk=\"Search_Chunk23.xml\" /><stem n=\"reorder\" chunk=\"Search_Chunk23.xml\" /><stem n=\"alter\" chunk=\"Search_Chunk23.xml\" /><stem n=\"balanc\" chunk=\"Search_Chunk23.xml\" /><stem n=\"incorpor\" chunk=\"Search_Chunk23.xml\" /><stem n=\"warp\" chunk=\"Search_Chunk23.xml\" /><stem n=\"overlaid\" chunk=\"Search_Chunk23.xml\" /><stem n=\"superimpos\" chunk=\"Search_Chunk23.xml\" /><stem n=\"vectoroverlay\" chunk=\"Search_Chunk23.xml\" /><stem n=\"overlay\" chunk=\"Search_Chunk23.xml\" /><stem n=\"vectoroverlay_lay\" chunk=\"Search_Chunk23.xml\" /><stem n=\"pos\" chunk=\"Search_Chunk23.xml\" /><stem n=\"compression_block_s\" chunk=\"Search_Chunk23.xml\" /><stem n=\"compression_gamma\" chunk=\"Search_Chunk23.xml\" /><stem n=\"compression_vers\" chunk=\"Search_Chunk23.xml\" /><stem n=\"sint32\" chunk=\"Search_Chunk23.xml\" /><stem n=\"compression_weight\" chunk=\"Search_Chunk23.xml\" /><stem n=\"creation_d\" chunk=\"Search_Chunk23.xml\" /><stem n=\"compression_nlev\" chunk=\"Search_Chunk23.xml\" /><stem n=\"statist\" chunk=\"Search_Chunk23.xml\" /><stem n=\"averag\" chunk=\"Search_Chunk23.xml\" /><stem n=\"standard_devi\" chunk=\"Search_Chunk23.xml\" /><stem n=\"target_compression_ratio\" chunk=\"Search_Chunk23.xml\" /><stem n=\"erda\" chunk=\"Search_Chunk23.xml\" /><stem n=\"usg\" chunk=\"Search_Chunk23.xml\" /><stem n=\"yres\" chunk=\"Search_Chunk23.xml\" /><stem n=\"hereaft\" chunk=\"Search_Chunk23.xml\" /><stem n=\"cartesian\" chunk=\"Search_Chunk23.xml\" /><stem n=\"school\" chunk=\"Search_Chunk23.xml\" /><stem n=\"algebra\" chunk=\"Search_Chunk23.xml\" /><stem n=\"+ydim\" chunk=\"Search_Chunk23.xml\" /><stem n=\"decreas\" chunk=\"Search_Chunk23.xml\" /><stem n=\"479\" chunk=\"Search_Chunk23.xml\" /><stem n=\"640w\" chunk=\"Search_Chunk23.xml\" /><stem n=\"480h\" chunk=\"Search_Chunk23.xml\" /><stem n=\"getyr\" chunk=\"Search_Chunk23.xml\" /><stem n=\"pixelspixel\" chunk=\"Search_Chunk23.xml\" /><stem n=\"bound\" chunk=\"Search_Chunk23.xml\" /><stem n=\"render\" chunk=\"Search_Chunk23.xml\" /><stem n=\"exceed\" chunk=\"Search_Chunk23.xml\" /><stem n=\"bitmask\" chunk=\"Search_Chunk23.xml\" /><stem n=\"clip\" chunk=\"Search_Chunk23.xml\" /><stem n=\"blend\" chunk=\"Search_Chunk23.xml\" /><stem n=\"correl\" chunk=\"Search_Chunk23.xml\" /><stem n=\"lie\" chunk=\"Search_Chunk23.xml\" /><stem n=\"overlap\" chunk=\"Search_Chunk23.xml\" /><stem n=\"treatment\" chunk=\"Search_Chunk23.xml\" /><stem n=\"lot\" chunk=\"Search_Chunk23.xml\" /><stem n=\"bigger\" chunk=\"Search_Chunk23.xml\" /><stem n=\"legitim\" chunk=\"Search_Chunk23.xml\" /><stem n=\"compani\" chunk=\"Search_Chunk23.xml\" /><stem n=\"1992\" chunk=\"Search_Chunk23.xml\" /><stem n=\"massiv\" chunk=\"Search_Chunk23.xml\" /><stem n=\"aerial\" chunk=\"Search_Chunk23.xml\" /><stem n=\"pioneer\" chunk=\"Search_Chunk23.xml\" /><stem n=\"denver\" chunk=\"Search_Chunk23.xml\" /><stem n=\"london\" chunk=\"Search_Chunk23.xml\" /><stem n=\"tokyo\" chunk=\"Search_Chunk23.xml\" /><stem n=\"divis\" chunk=\"Search_Chunk23.xml\" /><stem n=\"thank\" chunk=\"Search_Chunk23.xml\" /><stem n=\"glad\" chunk=\"Search_Chunk23.xml\" /><stem n=\"shop\" chunk=\"Search_Chunk23.xml\" /><stem n=\"explor\" chunk=\"Search_Chunk23.xml\" /><stem n=\"geoview\" chunk=\"Search_Chunk23.xml\" /><stem n=\"standalon\" chunk=\"Search_Chunk23.xml\" /><stem n=\"repositori\" chunk=\"Search_Chunk23.xml\" /><stem n=\"wms\" chunk=\"Search_Chunk23.xml\" /><stem n=\"jpip\" chunk=\"Search_Chunk23.xml\" /><stem n=\"png\" chunk=\"Search_Chunk23.xml\" /><stem n=\"categori\" chunk=\"Search_Chunk23.xml\" /><stem n=\"easi\" chunk=\"Search_Chunk23.xml\" /><stem n=\"expressview™\" chunk=\"Search_Chunk23.xml\" /><stem n=\"internet\" chunk=\"Search_Chunk23.xml\" /><stem n=\"firefox\" chunk=\"Search_Chunk23.xml\" /><stem n=\"conveni\" chunk=\"Search_Chunk23.xml\" /><stem n=\"network\" chunk=\"Search_Chunk23.xml\" /><stem n=\"ideal\" chunk=\"Search_Chunk23.xml\" /><stem n=\"compressor\" chunk=\"Search_Chunk23.xml\" /><stem n=\"compressor™\" chunk=\"Search_Chunk23.xml\" /><stem n=\"giant\" chunk=\"Search_Chunk23.xml\" /><stem n=\"cloud\" chunk=\"Search_Chunk23.xml\" /><stem n=\"90\" chunk=\"Search_Chunk23.xml\" /><stem n=\"reach\" chunk=\"Search_Chunk23.xml\" /><stem n=\"las\" chunk=\"Search_Chunk23.xml\" /><stem n=\"deliveri\" chunk=\"Search_Chunk23.xml\" /><stem n=\"stabl\" chunk=\"Search_Chunk23.xml\" /><stem n=\"exp\" chunk=\"Search_Chunk23.xml\" /><stem n=\"2009\" chunk=\"Search_Chunk23.xml\" /><stem n=\"reserv\" chunk=\"Search_Chunk23.xml\" /><stem n=\"furnish\" chunk=\"Search_Chunk23.xml\" /><stem n=\"nondisclosur\" chunk=\"Search_Chunk23.xml\" /><stem n=\"transmit\" chunk=\"Search_Chunk23.xml\" /><stem n=\"electron\" chunk=\"Search_Chunk23.xml\" /><stem n=\"photocopi\" chunk=\"Search_Chunk23.xml\" /><stem n=\"person\" chunk=\"Search_Chunk23.xml\" /><stem n=\"regist\" chunk=\"Search_Chunk23.xml\" /><stem n=\"logo\" chunk=\"Search_Chunk23.xml\" /><stem n=\"unauthor\" chunk=\"Search_Chunk23.xml\" /><stem n=\"prohibit\" chunk=\"Search_Chunk23.xml\" /><stem n=\"acknowledg\" chunk=\"Search_Chunk23.xml\" /><stem n=\"effort\" chunk=\"Search_Chunk23.xml\" /><stem n=\"avenu\" chunk=\"Search_Chunk23.xml\" /><stem n=\"washington\" chunk=\"Search_Chunk23.xml\" /><stem n=\"652\" chunk=\"Search_Chunk23.xml\" /><stem n=\"5211\" chunk=\"Search_Chunk23.xml\" /><stem n=\"phrase\" chunk=\"Search_Chunk23.xml\" /><stem n=\"acronym\" chunk=\"Search_Chunk23.xml\" /><stem n=\"spectral\" chunk=\"Search_Chunk23.xml\" /><stem n=\"weak\" chunk=\"Search_Chunk23.xml\" /><stem n=\"abbrevi\" chunk=\"Search_Chunk23.xml\" /><stem n=\"01\" chunk=\"Search_Chunk23.xml\" /><stem n=\"02\" chunk=\"Search_Chunk23.xml\" /><stem n=\"expens\" chunk=\"Search_Chunk23.xml\" /><stem n=\"nomin\" chunk=\"Search_Chunk23.xml\" /><stem n=\"mislead\" chunk=\"Search_Chunk23.xml\" /><stem n=\"50mb\" chunk=\"Search_Chunk23.xml\" /><stem n=\"10mb\" chunk=\"Search_Chunk23.xml\" /><stem n=\"5mb\" chunk=\"Search_Chunk23.xml\" /><stem n=\"1mb\" chunk=\"Search_Chunk23.xml\" /><stem n=\"max\" chunk=\"Search_Chunk23.xml\" /><stem n=\"min+1\" chunk=\"Search_Chunk23.xml\" /><stem n=\"min+max\" chunk=\"Search_Chunk23.xml\" /><stem n=\"notabl\" chunk=\"Search_Chunk23.xml\" /><stem n=\"dark\" chunk=\"Search_Chunk23.xml\" /><stem n=\"illustr\" chunk=\"Search_Chunk23.xml\" /><stem n=\"word\" chunk=\"Search_Chunk23.xml\" /><stem n=\"highest\" chunk=\"Search_Chunk23.xml\" /><stem n=\"sparc\" chunk=\"Search_Chunk23.xml\" /><stem n=\"powerpc\" chunk=\"Search_Chunk23.xml\" /><stem n=\"0x01020304\" chunk=\"Search_Chunk23.xml\" /><stem n=\"0x04\" chunk=\"Search_Chunk23.xml\" /><stem n=\"0x01\" chunk=\"Search_Chunk23.xml\" /><stem n=\"p+1\" chunk=\"Search_Chunk23.xml\" /><stem n=\"0x02\" chunk=\"Search_Chunk23.xml\" /><stem n=\"p+2\" chunk=\"Search_Chunk23.xml\" /><stem n=\"p+3\" chunk=\"Search_Chunk23.xml\" /><stem n=\"frequenc\" chunk=\"Search_Chunk23.xml\" /><stem n=\"emphasi\" chunk=\"Search_Chunk23.xml\" /><stem n=\"gamma\" chunk=\"Search_Chunk23.xml\" /><stem n=\"softer\" chunk=\"Search_Chunk23.xml\" /><stem n=\"sharp\" chunk=\"Search_Chunk23.xml\" /><stem n=\"xml\" chunk=\"Search_Chunk23.xml\" /><stem n=\"geometri\" chunk=\"Search_Chunk23.xml\" /><stem n=\"topolog\" chunk=\"Search_Chunk23.xml\" /><stem n=\"coverag\" chunk=\"Search_Chunk23.xml\" /><stem n=\"annot\" chunk=\"Search_Chunk23.xml\" /><stem n=\"k\" chunk=\"Search_Chunk23.xml\" /><stem n=\"mathemat\" chunk=\"Search_Chunk23.xml\" /><stem n=\"poor\" chunk=\"Search_Chunk23.xml\" /><stem n=\"anywher\" chunk=\"Search_Chunk23.xml\" /><stem n=\"perceiv\" chunk=\"Search_Chunk23.xml\" /><stem n=\"forth\" chunk=\"Search_Chunk23.xml\" /><stem n=\"expand\" chunk=\"Search_Chunk23.xml\" /><stem n=\"fundament\" chunk=\"Search_Chunk23.xml\" /><stem n=\"earliest\" chunk=\"Search_Chunk23.xml\" /><stem n=\"channel\" chunk=\"Search_Chunk23.xml\" /><stem n=\"seamless\" chunk=\"Search_Chunk23.xml\" /><stem n=\"ground\" chunk=\"Search_Chunk23.xml\" /><stem n=\"magnitud\" chunk=\"Search_Chunk23.xml\" /><stem n=\"intens\" chunk=\"Search_Chunk23.xml\" /><stem n=\"60\" chunk=\"Search_Chunk23.xml\" /><stem n=\"durat\" chunk=\"Search_Chunk23.xml\" /><stem n=\"neighbor\" chunk=\"Search_Chunk23.xml\" /><stem n=\"pyramid\" chunk=\"Search_Chunk23.xml\" /><stem n=\"augment\" chunk=\"Search_Chunk23.xml\" /></ents><chunkfiles><Url Source=\"Search_Chunk1.xml\" /><Url Source=\"Search_Chunk2.xml\" /><Url Source=\"Search_Chunk3.xml\" /><Url Source=\"Search_Chunk4.xml\" /><Url Source=\"Search_Chunk5.xml\" /><Url Source=\"Search_Chunk6.xml\" /><Url Source=\"Search_Chunk7.xml\" /><Url Source=\"Search_Chunk8.xml\" /><Url Source=\"Search_Chunk9.xml\" /><Url Source=\"Search_Chunk10.xml\" /><Url Source=\"Search_Chunk11.xml\" /><Url Source=\"Search_Chunk12.xml\" /><Url Source=\"Search_Chunk13.xml\" /><Url Source=\"Search_Chunk14.xml\" /><Url Source=\"Search_Chunk15.xml\" /><Url Source=\"Search_Chunk16.xml\" /><Url Source=\"Search_Chunk17.xml\" /><Url Source=\"Search_Chunk18.xml\" /><Url Source=\"Search_Chunk19.xml\" /><Url Source=\"Search_Chunk20.xml\" /><Url Source=\"Search_Chunk21.xml\" /><Url Source=\"Search_Chunk22.xml\" /><Url Source=\"Search_Chunk23.xml\" /></chunkfiles></index>';
CMCXmlParser._FilePathToXmlStringMap.Add('Search', xmlSearchData);
