#!/bin/sh
PACKAGE="GeoExpress"

BIN_PERM=555
MAN_PERM=444
PROFILES_PERM=644
ROOTONLY="y"

# Detect the Operating System

if [ `uname` != "Linux" ]
then
   echo "unsupported platform!"
   exit 1
fi

if [ ! -f "geoCmdLine.tar" ]
then
   echo "geoCmdLine.tar file missing.  Aborting Installation..."
   exit 1
fi
# Enforce root-only
eval `id | sed -e "s/uid/MYUID/" \
               -e "s/(/; MYNAME=/" \
               -e "s/).*$/; export MYNAME MYUID/"`
if test "$ROOTONLY" = "y"; then
  echo "Verifying that user has administrative privileges ...";
  if test $MYUID -ne 0 -o ! "$MYNAME" = "root"; then
    echo "Must be root" <<END

You must be root to run this script.

END
    echo "User not logged in as root.  Aborting installation.";
    exit 1
  fi
  echo " yes";
  umask 0022;
fi
ME=`basename $0`

# writes a shell-appropriate, environment-variable-setting command to
# $PREFIXDIR/GeoExpressEnvSetup.sh
write_env_var() {
   varname=$1   
   varval=$2                              
   case $SHELL in
   */bash|*/sh|*/ksh)
      echo "$varname=$varval" | cat >> $PREFIXDIR/GeoExpressEnvSetup.sh
      echo "export $varname" | cat >> $PREFIXDIR/GeoExpressEnvSetup.sh
   ;;
   */csh|*/tcsh)
      echo "setenv $varname $varval" | cat >> $PREFIXDIR/GeoExpressEnvSetup.sh
   ;;
   */*)
      echo $varname not set
   esac
}

# Some systems do not have "line"
line() {
   read temp
   echo $temp
}

# echo a line without a terminator
echon() {   # arguments to echo...
   if [ "x`echo -n t`" = "x-n t" ]
   then
      echo "${*}\c"
   else
      echo -n "$*"
   fi
}

# get a yes/no response from the user
y_n() {   # default "message"
   export Y_N
   Y_N=
   while [ -z "$Y_N" ]; do
      echon "$2 "
      if [ "x$1" = 'xy' ]
      then
         echon "(Y/n) ? "
      else
         echon "(y/N) ? "
      fi
      V=`line`
      if [ -z "$V" ]
      then
         V="$1"
      fi
      case "$V" in
      y*|Y*)   Y_N=y;;
      n*|N*)   Y_N=n;;
      *)   echo "Please answer either yes or no";;
      esac
   done
}

getdir() {   # default "message" optional
   export DIR
   if [ -n "$3" ]
   then
      y_n n "Should I $2"
      if [ "x$Y_N" = 'xn' ]
      then
         DIR=
      return
      fi
   fi
   DIR=$1
   while true; do
      echon "Where do I ${2}? [${DIR}]: "
      V=`line`
      if [ -n "$V" ]
      then
         DIR=`echo $V | sed -e s+~+$HOME+`
      fi
      if [ ! -d "$DIR" ]
      then
         mkdir -p "$DIR"
      fi
      if [ -w "$DIR" ]
      then
         DIR="`(cd "$DIR"; pwd)`"
         break
      else
         echo "$ME: $DIR is not writable"
         echo
      fi
   done
}

#
# Ask the user where to install everything
#
echo
echo "This is $PACKAGE for Linux"
echo
echo
echo "This software is covered by a license agreement."
echon "Please hit ENTER and read it now."
line
more LICENSE.txt
echo
y_n n "Do you accept the terms of the license agreement"
if [ "x$Y_N" = 'xn' ]; then
   echo
   echo "$PACKAGE has not been installed.  The installation will now exit."
   echo
   exit 1
fi
y_n n "Would you like to install this package now?"
if [ "x$Y_N" = 'xn' ]; then
   echo "You may run $0 again later to complete the installation."
   exit 0
fi
echo
echo "You will be prompted for the locations to install the"
echo "software. This install script will make any required"
echo "directories."
echo
getdir /usr/local/LizardTech/$PACKAGE "install prefix"
PREFIXDIR=$DIR

echo extracting geoCmdLine.tar
cat geoCmdLine.tar | (cd "$PREFIXDIR";tar xvf -)

#
# Ask the user whether to enable anonymous application usage
#
echo
echo "Help us deliver the best solutions by sharing anonymous application usage with us."
echo
echo
echo "By accepting, you'll help us gather important information that will guide us toward future quality and feature improvements. The information gathered is anonymous but helps us greatly understand your solution needs."
echo
echo
echo "You can always change your mind at any time and discontinue sharing information. "
echo
echo
echo "For more information about how we use your information and to opt-out in the future please visit our help article page:"
echo "https://www.lizardtech.com/support/lizardtech-product-improvements"
echo
echo
y_n y "I agree to share anonymous application usage data."
if [ "x$Y_N" = 'xy' ]; then
   echo "RecordRuntimeData=1" > "$PREFIXDIR/etc/ruiPref.txt"
else
   echo "RecordRuntimeData=0" > "$PREFIXDIR/etc/ruiPref.txt"
fi


#
# validate serial number
#
while true; do
   echo
   echo "Please enter your serial number for $PACKAGE.  Leave blank for trial."
   echo
   SERIALNUMBER=`line`
   if [ -n "$SERIALNUMBER" ]
   then
      (cd "$PREFIXDIR";./tools/GEXConfigUtil $SERIALNUMBER)
      if [ $? -ge 100 -a $? -le 103 ]
      then
         echo "SerialNumber=$SERIALNUMBER" | cat > "$PREFIXDIR/bin/lic_pref"
         break;
      else
        echo "Invalid serial number.  Please make sure you entered your serial number correctly and try again."
      fi
   else
      break;
   fi
done

#
# add the trial license code
#
echo "*D UONsDMNb7qaUH4Ij7C4FfxGAWDOaMfommq7Q7U0e3t3ZBKRM3f0nMW0:nNtN82zaLOyxcMKClhCfnbJOOwDPEC3twpx1lHPh8Q0omOzyy3n33Uo4HMYaY0T2KN:CRDm8TWfm#" >> "$PREFIXDIR/bin/lservrc"

#
# rainbow (version 8) must be initialized for time-sensitive licenses to function properly
#

(cd "$PREFIXDIR";./tools/ltlsinit)

echo
echo "You will also need to obtain a security code for $PACKAGE when running it for the first time."
echo "You may wish to install the License Server to take advantage of Floating Licensing."
echo
y_n n "Would you like to install the License Server now?"
if [ "x$Y_N" = 'xy' ]; then
   if [ -d LICSERV ]; then
     (cd LICSERV; sh install.sh)
   fi
fi

if [ -f "$PREFIXDIR/GeoExpressEnvSetup.sh" ]
then
   mv "$PREFIXDIR/GeoExpressEnvSetup.sh" "$PREFIXDIR/GeoExpressEnvSetup.sh.bak"
   echo created a backup of your environment file $PREFIXDIR/GeoExpressEnvSetup.sh
fi    
touch "$PREFIXDIR/GeoExpressEnvSetup.sh" 

echo
echo "This product requires the Express Cartridge Manager, ECM."
echo
y_n n "Would you like to install ECM now?"
if [ "x$Y_N" = 'xy' ]; then
   if [ -d ECM ]; then
     (INSTALLINGGEX=$PREFIXDIR/GeoExpressEnvSetup.sh; export INSTALLINGGEX; cd ECM; sh install.sh)
   fi
fi

# write_env_var writes the commands to $PREFIXDIR/GeoExpressEnvSetup.sh
write_env_var LD_LIBRARY_PATH \$LD_LIBRARY_PATH:$PREFIXDIR/bin
write_env_var PATH \$PATH:$PREFIXDIR/bin

echo 
echo 
echo "Installation complete."
echo $PACKAGE has been installed in $PREFIXDIR.
echo 
echo "To run it, you will need to set the following environment variables."
echo "To do this, please 'source' $PREFIXDIR/GeoExpressEnvSetup.sh): "
echo
cat $PREFIXDIR/GeoExpressEnvSetup.sh

echo

exit 0

