#!/bin/sh
PACKAGE="License Server and Tools for GeoExpress [(c) LizardTech 2010]"

ME=`basename $0`

# Some systems do not have "line"
line() {
	read temp
	echo $temp
}

# echo a line without a terminator
echon() {	# arguments to echo...
	if [ "x`echo -n t`" = "x-n t" ]
	then
		echo "${*}\c"
	else
		echo -n "$*"
	fi
}

# get a yes/no response from the user
y_n() {	# default "message"
	export Y_N
	Y_N=
	while [ -z "$Y_N" ]; do
		echon "$2 "
		if [ "x$1" = 'xy' ]
		then
			echon "(Y/n) ? "
		else
			echon "(y/N) ? "
		fi
		V=`line`
		if [ -z "$V" ]
		then
			V="$1"
		fi
		case "$V" in
		y*|Y*)	Y_N=y;;
		n*|N*)	Y_N=n;;
		*)	echo "Please answer either yes or no";;
		esac
	done
}

getdir() {	# default "message" optional
	export DIR
	if [ -n "$3" ]
	then
		y_n n "Should I $2"
		if [ "x$Y_N" = 'xn' ]
		then
			DIR=
		return
		fi
	fi
	DIR=$1
	while true; do
      echo "Please enter an absolute path."
		echon "Where do I ${2}? [${DIR}]: "
		V=`line`
		if [ -n "$V" ]
		then
			DIR=`echo $V | sed -e s+~+$HOME+`
		fi
      if `echo "$DIR" | grep "^/" >> /dev/null`
      then
		   if [ ! -d "$DIR" ]
         then
            mkdir -p "$DIR"
		   fi
		   if [ -w "$DIR" ]
		   then
            DIR="`(cd "$DIR"; pwd)`"
		   	break
		   else
		   	echo "$ME: $DIR is not writable"
		   	echo
		   fi
      fi
	done
}

#
# Ask the user where to install everything
#
echo
echo "This is $PACKAGE"
echo
echo
echo "This software is covered by a license agreement."
echon "Please hit ENTER and read it now."
line
more LICENSE.txt
echo
y_n n "Do you accept the terms of the license agreement"
if [ "x$Y_N" = 'xn' ]; then
	echo
	echo "Please delete this software package NOW"
	echo
	exit 1
fi

y_n n "Would you like to install this package now?"
if [ "x$Y_N" = 'xn' ]; then
	echo "You may run $0 again later to complete the installation."
	exit 0
fi
echo
echo "You will be prompted for the locations to install the"
echo "software. This install script will make any required"
echo "directories."
echo
echo "The License Server must be installed on a local drive."
echo
getdir /usr/local/LizardTech/LicenseServer "install prefix"
PREFIXDIR=$DIR

cat LicenseServer.tar | (cd "$PREFIXDIR" ; tar xvf -)

echo
echo "The LizardTech License Server has been installed at $PREFIXDIR"
echo
echo "As required, run 'lserv' to start the License Server (this script will do this now)."
echo "Refer to README.txt for setup instructions for Solaris and Linux"
echo "including how to obtain and install licenses for this server."
echo
(cd "$PREFIXDIR/licenseserver";./lserv)








