#!/bin/sh
PACKAGE="Express Cartridge Manager [(c) LizardTech 2010]"
BIN_PERM=555

APPNAME=`basename $0`
i=`dirname ${0}`
ROOT=`(cd ${i}; pwd)`

. "${ROOT}/functions.sh"

#
# Ask the user where to install everything
#
showText "${PACKAGE}" <<END
END

showLicense "${ROOT}/LICENSE.txt"

promptYN "Would you like to install this package now?"
if [ "${YN}" = "n" ]; then
	echo "You may run ${ROOT}/${APPNAME} again later to complete the installation."
	exit 0
fi

showText <<END

You will be prompted for the locations to install the
software. This install script will make any required
directories.

The Express Cartridge Manager must be installed on a local drive.
END

promptDIR "Enter install location:" /usr/local/LizardTech/ECM
PREFIXDIR=$DIR
DBDIR="${PREFIXDIR}/db"

cd "${PREFIXDIR}"
tar xvf "${ROOT}/UsageMeter.tar"

LT_UMDB_PATH=${DBDIR}
export LT_UMDB_PATH
bin/umadmin -install
if [ ${?} -ne 0 ]
then
   echo "Could not configure installed Cartridge Manager (umadmin -install failed)"
   exit 1
fi

# Set up environment variables

if [ -f "$PREFIXDIR/UsageMeterEnvSetup.sh" ]
then
   mv "$PREFIXDIR/UsageMeterEnvSetup.sh" "$PREFIXDIR/UsageMeterEnvSetup.sh.bak"
   echo created a backup of your environment file $PREFIXDIR/UsageMeterEnvSetup.sh
fi    

# write_env_var writes the commands to $PREFIXDIR/UsageMeterEnvSetup.sh
write_env_var LT_UMDB_PATH $DBDIR

if [ -f "$INSTALLINGGEX" ]
then
  cat $PREFIXDIR/UsageMeterEnvSetup.sh >> $INSTALLINGGEX
  exit 0
fi
echo
echo "You will need to set the LT_UMDB_PATH environment variable to"
echo "$LT_UMDB_PATH."
echo
echo "Try this (or 'source' directly from $PREFIXDIR/UsageMeterEnvSetup.sh): "
cat $PREFIXDIR/UsageMeterEnvSetup.sh


echo
echo "Installation complete"

exit 0


