#!/bin/sh

echon() {
  # arguments to echo...
  if [ "x`echo -n t`" = "x-n t" ]
  then
    echo "${*}\c"
  else
    echo -n "$*"
  fi
}


showText() {
  if test -z "${1}"
  then
    echo " "; cat
  else
    echo " "; echo " [ ${1} ] "; echo " " ; cat
  fi
}

showWarning() {
  echo " "; echo "****[ ${1} ]****"; echo " "; cat
}

promptYN() {
  YN=""
  while test -z "${YN}"
  do
    echon "${1} (y/n) "
    read YN
    if test -z "${YN}"
    then
      echo "You must answer y or n"
    else
      YN=`echo "${YN}" | tr A-Z a-z | cut -b1`
      if test "${YN}" != "y" -a "${YN}" != "n"
      then
        echo "Please answer with y, n, yes, or no"
        YN=""
      fi
    fi
  done
}

showLicense() {
  echo "This software is covered by a license agreement."
  echon "Please hit ENTER and read it now."
  read DUMMY
  more < ${1}
  promptYN "Have you read and accepted the terms of this license?"
  if test "${YN}" != "y"
  then
    echo "Installation cancelled - exiting now."
    exit 1
  fi
}


promptDIR() {
  while true
  do
    echon "${1} [${2}]: "
    read DIR
    if test -z "${DIR}"
    then
      DIR="${2}"
    fi
    DIR=`echo ${DIR} | sed -e s+~+${HOME}+`
    if test ! -d "${DIR}"
    then
      mkdir -p "${DIR}"
    fi
    if test -w "${DIR}"
    then
      DIR=`cd "${DIR}"; pwd`
      return
    else
      echo "${APPNAME}: ${DIR} is not writable"
      echo
    fi
  done
}

# writes a shell-appropriate, environment-variable-setting command to
# $PREFIXDIR/UsageMeterEnvSetup.sh
write_env_var() {
   varname=$1   
   varval=$2                              
   case $SHELL in
   */bash|*/sh|*/ksh)
      echo "$varname=$varval" | cat >> $PREFIXDIR/UsageMeterEnvSetup.sh
      echo "export $varname" | cat >> $PREFIXDIR/UsageMeterEnvSetup.sh
   ;;
   */csh|*/tcsh)
      echo "setenv $varname $varval" | cat >> $PREFIXDIR/UsageMeterEnvSetup.sh
   ;;
   */*)
      echo $varname not set
   esac
}
