#!/bin/sh
PACKAGE="Express Cartridge Manager Server [(c) LizardTech 2004]"
BIN_PERM=555

APPNAME=`basename $0`
i=`dirname ${0}`
ROOT=`(cd ${i}; pwd)`

. "${ROOT}/functions.sh"

#
# Ask the user where to install everything
#
showText "${PACKAGE}" <<END
END

showLicense "${ROOT}/LICENSE.txt"

promptYN "Would you like to install this package now?"
if [ "${YN}" = "n" ]; then
	echo "You may run ${0} again later to complete the installation."
	exit 0
fi

showText <<END
The Express Cartridge Manager Server uses the Express Cartridge Manager.
END

promptYN "Is the ECM Installed on this computer?"
if [ "${YN}" = "n" ]; then
showText <<END

You will be prompted for the locations to install the
software. This install script will make any required
directories.

The Express Cartridge Manager must be installed on a local drive.
END

promptDIR "Enter install location:" /usr/local/LizardTech/ECM
PREFIXDIR=$DIR
else
  while true
  do
    promptDIR "Enter ECM location:" /usr/local/LizardTech/ECM
    PREFIXDIR=$DIR

    if [ -f ${PREFIXDIR}/db/upack.dat -a -f ${PREFIXDIR}/db/rsvp.dat ]
    then
      break
    else
      echo "${PREFIXDIR} is not a valid ECM instalation"
    fi
  done
fi

cd "${PREFIXDIR}"
tar xvf "${ROOT}/UsageMeterServer.tar"

LT_UMDB_PATH="${PREFIXDIR}/db"
export LT_UMDB_PATH
bin/umadmin -install
if [ ${?} -ne 0 ]
then
   echo "Could not configure installed Cartridge Manager (umadmin -install failed)"
   exit 1
fi

if [ `uname` = "SunOS" ]
then
   INITDIR=/etc/init.d
elif [ `uname` = "Linux" ]
then
   INITDIR=/etc/rc.d/init.d
fi

if [ ! -w ${INITDIR} ]
then
  showWarning "${INITDIR} is not writable" << END
Please re-run ${0} as a user that has write permissions 
to ${INITDIR}.
END
  exit 1
fi

sed -e "s+REPLACE_ECM_HOME+${PREFIXDIR}+g" ${PREFIXDIR}/etc/ltumsd > ${INITDIR}/ltumsd

rm ${PREFIXDIR}/etc/ltumsd
chmod 755 ${INITDIR}/ltumsd
${INITDIR}/ltumsd start

mksymlink() {
  if [ -f ${2} ]
  then
    rm -f ${2}
  fi
  ln -s ${1} ${2}
  if [ ${?} -ne 0 ]
  then
    echo "Could not create symbolic link for ${2}."
    exit 1
  fi
}

if [ `uname` = "SunOS" ]
then
  mksymlink ${INITDIR}/ltumsd /etc/rc3.d/S99ltumsd
  mksymlink ${INITDIR}/ltumsd /etc/rc2.d/K01ltumsd
  mksymlink ${INITDIR}/ltumsd /etc/rc1.d/K01ltumsd
  mksymlink ${INITDIR}/ltumsd /etc/rc0.d/K01ltumsd
elif [ `uname` = "Linux" ]
then
  /sbin/chkconfig --add ltumsd
fi


