package com.lizardtech.rasterexample;

import android.content.res.AssetManager;
import android.os.Environment;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MainActivity extends AppCompatActivity {

    // Used to load the 'native-lib' library on application startup.
    static {
        System.loadLibrary("native-lib");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        copyAssets();

        // Call the various SDK tests and report the results
        StringBuilder testResults = new StringBuilder();
        testResults.append(String.format("UserTest returned: %d\n", UserTest()));
        testResults.append(String.format("DecodeJP2ToBBB returned: %d\n", DecodeJP2ToBBB()));
        testResults.append(String.format("DecodeJP2ToJPG returned: %d\n", DecodeJP2ToJPG()));
        testResults.append(String.format("DecodeJP2ToMemory returned: %d\n", DecodeJP2ToMemory()));
        testResults.append(String.format("DecodeMrSIDBandSelection returned: %d\n", DecodeMrSIDBandSelection()));
        testResults.append(String.format("DecodeMrSIDLidar returned: %d\n", DecodeMrSIDLidar()));
        testResults.append(String.format("DecodeMrSIDToMemory returned: %d\n", DecodeMrSIDToMemory()));
        testResults.append(String.format("DecodeMrSIDToRaw returned: %d\n", DecodeMrSIDToRaw()));
        testResults.append(String.format("DecodeMrSIDToTIFF returned: %d\n", DecodeMrSIDToTIFF()));
        testResults.append(String.format("DecodeNITFToBBB returned: %d\n", DecodeNITFToBBB()));
        testResults.append(String.format("DerivedImageFilter returned: %d\n", DerivedImageFilter()));
        testResults.append(String.format("DerivedImageReader returned: %d\n", DerivedImageReader()));
        testResults.append(String.format("DerivedImageWriter returned: %d\n", DerivedImageWriter()));
        testResults.append(String.format("DerivedStream returned: %d\n", DerivedStream()));
        testResults.append(String.format("GeoScene returned: %d\n", GeoScene()));
        testResults.append(String.format("ImageInfo returned: %d\n", ImageInfo()));
        testResults.append(String.format("InterruptDelegate returned: %d\n", InterruptDelegate()));
        testResults.append(String.format("MetadataDump returned: %d\n", MetadataDump()));
        testResults.append(String.format("Pipeline returned: %d\n", Pipeline()));
        testResults.append(String.format("ProgressDelegate returned: %d\n", ProgressDelegate()));
        testResults.append(String.format("SceneBuffer returned: %d\n", SceneBuffer()));
        testResults.append(String.format("UsingCInterface returned: %d\n", UsingCInterface()));
        testResults.append(String.format("UsingCStream returned: %d\n", UsingCStream()));
        testResults.append(String.format("UsingStreams returned: %d\n", UsingStreams()));
        testResults.append(String.format("ErrorHandling returned: %d\n", ErrorHandling()));
        testResults.append("See LogCat for any non-zero returns\n");

        TextView  tv = new TextView(this);
        try {
            tv.setText(testResults.toString());
        } catch (Exception e) {
            e.printStackTrace();
            tv.setText(e.getMessage());
        }
        setContentView(tv);
    }

    private void copyAssets() {
        File outDir = new File(Environment.getExternalStorageDirectory(), "LTRasterExamples");
        if(new File(outDir, "out").mkdirs()) {
            outDir.deleteOnExit();
        }
        else
            Log.e("tag", "Failed to create LTRasterExamples directory " + outDir);

        setUserPath(outDir.getAbsolutePath());

        AssetManager assetManager = getAssets();
        String[] files = null;
        try {
            files = assetManager.list("");
        } catch (IOException e) {
            Log.e("tag", "Failed to get asset file list.", e);
        }
        for (String filename : files) {
            InputStream in = null;
            OutputStream out = null;
            try {
                in = assetManager.open(filename);

                File outFile = new File(outDir, filename);
                if(!outFile.exists()) {
                    out = new FileOutputStream(outFile);
                    copyFile(in, out);
                    in.close();
                    in = null;
                    out.flush();
                    out.close();
                    out = null;
                }
            } catch (IOException e) {
                Log.e("tag", "Failed to copy asset file: " + filename, e);
            }
        }
    }

    private void copyFile(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int read;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    /**
     * A native method that is implemented by the 'native-lib' native library,
     * which is packaged with this application.
     */
    public native void setUserPath(String path);
    public native int UserTest();
    public native int DecodeJP2ToBBB();
    public native int DecodeJP2ToJPG();
    public native int DecodeJP2ToMemory();
    public native int DecodeMrSIDBandSelection();
    public native int DecodeMrSIDLidar();
    public native int DecodeMrSIDToMemory();
    public native int DecodeMrSIDToRaw();
    public native int DecodeMrSIDToTIFF();
    public native int DecodeNITFToBBB();
    public native int DerivedImageFilter();
    public native int DerivedImageReader();
    public native int DerivedImageWriter();
    public native int DerivedStream();
    public native int ErrorHandling();
    public native int GeoScene();
    public native int ImageInfo();
    public native int InterruptDelegate();
    public native int MetadataDump();
    public native int Pipeline();
    public native int ProgressDelegate();
    public native int SceneBuffer();
    public native int UsingCInterface();
    public native int UsingCStream();
    public native int UsingStreams();
}
