#include <jni.h>
#include <string.h>
#include "main.h"
#include "lt_utilStatusStrings.h"

static char* rootPath;

extern "C"
const char *INPUT_PATH(const char *filename) {
    static char fullpath[1024];
    strcpy(fullpath, rootPath);
    strcat(fullpath, "/");
    strcat(fullpath, filename);
    return fullpath;
}

extern "C"
const char *OUTPUT_PATH(const char *filename) {
    static char fullpath[1024];
    strcpy(fullpath, rootPath);
    strcat(fullpath, "/out/");
    strcat(fullpath, filename);
    return fullpath;
}

#define JNI2TEST(f) \
extern "C" JNIEXPORT jint JNICALL \
Java_com_lizardtech_rasterexample_MainActivity_##f( JNIEnv* env, jobject thiz ) \
{ return f(); }

extern "C" JNIEXPORT void JNICALL
Java_com_lizardtech_rasterexample_MainActivity_setUserPath(JNIEnv *env, jobject instance,
                                                           jstring path_) {
    const char *path = env->GetStringUTFChars(path_, 0);
    static char p[1024];
    strcpy(p, path);
    rootPath = p;
    env->ReleaseStringUTFChars(path_, path);
}

jint JNI_OnLoad(JavaVM* vm, void* reserved)
{
    JNIEnv* env;
    if (vm->GetEnv(reinterpret_cast<void**>(&env), JNI_VERSION_1_6) != JNI_OK) {
        return -1;
    }

    if (!LT_SUCCESS(initializeStatusStrings())) {
        return -1;
    }

    return JNI_VERSION_1_6;
}

JNI2TEST(UserTest)
JNI2TEST(DecodeJP2ToBBB)
JNI2TEST(DecodeJP2ToJPG)
JNI2TEST(DecodeJP2ToMemory)
JNI2TEST(DecodeMrSIDBandSelection)
JNI2TEST(DecodeMrSIDLidar)
JNI2TEST(DecodeMrSIDToMemory)
JNI2TEST(DecodeMrSIDToRaw)
JNI2TEST(DecodeMrSIDToTIFF)
JNI2TEST(DecodeNITFToBBB)
JNI2TEST(DerivedImageFilter)
JNI2TEST(DerivedImageReader)
JNI2TEST(DerivedImageWriter)
JNI2TEST(DerivedStream)
JNI2TEST(ErrorHandling)
JNI2TEST(GeoScene)
JNI2TEST(ImageInfo)
JNI2TEST(InterruptDelegate)
JNI2TEST(MetadataDump)
JNI2TEST(Pipeline)
JNI2TEST(ProgressDelegate)
JNI2TEST(SceneBuffer)
JNI2TEST(UsingCInterface)
JNI2TEST(UsingCStream)
JNI2TEST(UsingStreams)

