package com.lizardtech.studio;

import android.content.res.AssetManager;
import android.os.Environment;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MainActivity extends AppCompatActivity {

    // Used to load the 'native-lib' library on application startup.
    static {
        System.loadLibrary("native-lib");
    }

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        copyAssets();

        // Call the various SDK tests and report the results
        boolean allPassed = true;
        StringBuilder testResults = new StringBuilder();

        try {
            testResults.append("Ran UserTutorial_iterator\n"); UserTutorial_iterator();
            testResults.append("Ran UserTutorial_read\n"); UserTutorial_read();
            testResults.append("Ran DumpMG4Info\n"); DumpMG4Info();
            testResults.append("Ran IterateOverPoints\n"); IterateOverPoints();
            testResults.append("Ran DecodeMG4ToTXT\n"); DecodeMG4ToTXT();
            testResults.append("Ran DecodeMrSIDRaster\n"); DecodeMrSIDRaster();
            testResults.append("Ran UserTest\n"); UserTest();
        } catch (Exception e) {
            allPassed = false;
            testResults.append("Exception:\n");
            testResults.append("  " + e.getMessage() + "\n");
        }

        if (allPassed == true) {
            testResults.append("passed DSDK tests\n");
        }

        testResults.append("See LogCat for more detail\n");

        TextView  tv = new TextView(this);
        try {
            tv.setText(testResults.toString());
        } catch (Exception e) {
            e.printStackTrace();
            tv.setText(e.getMessage());
        }
        setContentView(tv);
    }
    private void copyAssets() {
        File outDir = new File(Environment.getExternalStorageDirectory(), "LTLidarExamples");
        if(new File(outDir, "out").mkdirs()) {
            outDir.deleteOnExit();
        }
        else
            Log.e("tag", "Failed to create LTRasterExamples directory " + outDir);

        setUserPath(outDir.getAbsolutePath());

        AssetManager assetManager = getAssets();
        String[] files = null;
        try {
            files = assetManager.list("");
        } catch (IOException e) {
            Log.e("tag", "Failed to get asset file list.", e);
        }
        for (String filename : files) {
            InputStream in = null;
            OutputStream out = null;
            try {
                in = assetManager.open(filename);

                File outFile = new File(outDir, filename);
                if(!outFile.exists()) {
                    out = new FileOutputStream(outFile);
                    copyFile(in, out);
                    in.close();
                    in = null;
                    out.flush();
                    out.close();
                    out = null;
                }
            } catch (IOException e) {
                Log.e("tag", "Failed to copy asset file: " + filename, e);
            }
        }
    }

    private void copyFile(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int read;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    /**
     * A native method that is implemented by the 'native-lib' native library,
     * which is packaged with this application.
     */
    public native void setUserPath(String path);

    public native void UserTutorial_iterator();
    public native void UserTutorial_read();
    public native void DumpMG4Info();
    public native void IterateOverPoints();
    public native void DecodeMG4ToTXT();
    public native void DecodeMrSIDRaster();
    public native void UserTest();

}
