#include <jni.h>
#include <string>
#include <sstream>
#include <cstring>
#include "main.h"

using namespace std;

static char* rootPath;

const char *INPUT_PATH(const char *filename) {
static char fullpath[1024];
strcpy(fullpath, rootPath);
strcat(fullpath, "/");
strcat(fullpath, filename);
return fullpath;
}

const char *OUTPUT_PATH(const char *filename) {
static char fullpath[1024];
strcpy(fullpath, rootPath);
strcat(fullpath, "/out/");
strcat(fullpath, filename);
return fullpath;
}

#define JNI2TEST(f, fn) \
extern "C" JNIEXPORT void JNICALL \
Java_com_lizardtech_studio_MainActivity_##fn( JNIEnv* env, jobject thiz ) \
{ \
	try { f(); } \
	catch(Error &e) { \
		ostringstream message("Error: "); message << \
		e.filename() << ":" << \
		e.line() << ":" << \
		e.function() << ": " << \
		e.what() << "\n"; \
		jclass Exception = env->FindClass("java/lang/Exception"); \
		env->ThrowNew(Exception, message.str().c_str()); \
	} \
	catch(exception &e) { \
		ostringstream message("std::exception: "); message << e.what() << "\n"; \
		jclass Exception = env->FindClass("java/lang/Exception"); \
		env->ThrowNew(Exception, message.str().c_str()); \
	} \
	catch(...) { \
		jclass Exception = env->FindClass("java/lang/Exception"); \
		env->ThrowNew(Exception, "unknown exception\n"); \
	} \
}

jint JNI_OnLoad(JavaVM* vm, void* reserved)
{
    JNIEnv* env;
    if (vm->GetEnv(reinterpret_cast<void**>(&env), JNI_VERSION_1_6) != JNI_OK) {
        return -1;
    }

    return JNI_VERSION_1_6;
}


extern "C" JNIEXPORT void JNICALL
Java_com_lizardtech_studio_MainActivity_setUserPath(JNIEnv *env, jobject instance, jstring path_) {
    const char *path = env->GetStringUTFChars(path_, 0);
    static char p[1024];
    strcpy(p, path);
    rootPath = p;
    env->ReleaseStringUTFChars(path_, path);
}

JNI2TEST(UserTutorial_iterator, UserTutorial_1iterator)
JNI2TEST(UserTutorial_read, UserTutorial_1read)
JNI2TEST(DumpMG4Info, DumpMG4Info)
JNI2TEST(IterateOverPoints, IterateOverPoints)
JNI2TEST(DecodeMG4ToTXT, DecodeMG4ToTXT)
JNI2TEST(DecodeMrSIDRaster, DecodeMrSIDRaster)
JNI2TEST(UserTest, UserTest)
