var xmlSearchData = "";
xmlSearchData += '<?xml version=\"1.0\" encoding=\"utf-8\"?><index PreMerged=\"false\" SearchType=\"Stem\" NGramSize=\"1\"><urls><Url Source=\"../Content/Introduction.htm\" Title=\"Introduction\" Abstract=\"Thank you for using LizardTech® products. This is the documentation for the MrSID® Decode Software Development Kit (SDK) for LiDAR data.&#xA;The SDK provides a framework for extracting LiDAR data from MrSID Generation 4 (MG4™) files. LiDAR data is becoming increasingly important to many aspects of ...\" /><Url Source=\"../Content/SDK_contents.htm\" Title=\"SDK Contents\" Abstract=\"The contents of the MrSID Decode SDK include the following: Documentation Cover documentation The fileREADME.txt in the top-level directory and the file CHANGES.txt in the doc directory contain information about late changes to the SDK. License In the top-level directory, the file LICENSE.pdf ...\" /><Url Source=\"../Content/Architecture_and_Design.htm\" Title=\"Architecture and Design\" Abstract=\"This section provides an overview of the architecture and some insight into the design philosophy of LizardTech\'s MrSID Decode SDK. Basic Terminology Point – A location in three-dimensional (3D) space with non-optional attributes (X,Y,Z) and optional attributes such as scan angle, pulse intensity, ...\" /><Url Source=\"../Content/Getting_Started.htm\" Title=\"Getting Started\" Abstract=\"This chapter provides some preliminary information to get you started using the MrSID Decode SDK. The code examples (see  &quot;Code Examples&quot; ) should give you enough information to determine what level of SDK&#160;support your own application will require. Click any link below for more information: System ...\" /><Url Source=\"../Content/System_Requirements.htm\" Title=\"System Requirements\" Abstract=\"The MrSID SDK is a set of C++ libraries that must be used in conjunction with the specific development environment for your platform. The supported configurations are listed below. For optimal performance, verify that your system meets the following minimum recommended hardware requirements: 2 GHz ...\" /><Url Source=\"../Content/Installation.htm\" Title=\"Installation\" Abstract=\"Installation No specific installation is required to use the MrSID Decode SDK beyond copying the SDK contents from the media provided (CD, ISO CD image, archive from FTP site, etc.) to your local computer.\" /><Url Source=\"../Content/Technical_Support.htm\" Title=\"Technical Support\" Abstract=\"Most technical issues can be resolved using the various resources you have available. In addition to the product documentation and the README file, LizardTech offers a knowledge base and product updates on the LizardTech website.&#xA; Knowledge Base  http://www.lizardtech.com/support/kb/ The LizardTech ...\" /><Url Source=\"../Content/The_SDK_Classes.htm\" Title=\"The SDK Classes\" Abstract=\"This chapter describes the important classes of the MrSID Decode SDK. Click any link below for more information. The PointSource Class The PointWriter Class The Buffer Management Classes The PointIterator Class Text Point Readers and Writers The MG4PointReader Class The Support Classes The Metadata ...\" /><Url Source=\"../Content/The_PointSource_Class.htm\" Title=\"The PointSource Class\" Abstract=\"The PointSource class is the root class for accessing LiDAR data. Following is a description of each of the methods. Methods for Accessing Properties Number of Points To access the number of points, call PointSource::getNumPoints(). Channels A channel is all the values for a given attribute. For ...\" /><Url Source=\"../Content/The_PointWriter_Class.htm\" Title=\"The PointWriter Class\" Abstract=\"The PointWriter class is the base class for writing LiDAR data to files. Following is a description of each of the methods. Methods for Setting Up and Writing the Output File Metadata By default the writers to not copy in the metadata from the point source. It is the responsibility of the ...\" /><Url Source=\"../Content/The_Buffer_Management_Classes.htm\" Title=\"The Buffer Management Classes\" Abstract=\"When extracting points we use the PointData class to pass around parts of the point cloud among functions. This class is a group of ChannelData classes for the channels that are to be extracted. The ChannelInfo Class A channel is all the values for a given attribute. For example, the X channel is ...\" /><Url Source=\"../Content/The_PointIterator_Class.htm\" Title=\"The PointInterator Class\" Abstract=\"The PointIterator class is the primary class for accessing the point data in a LiDAR file. To create an iterator, call PointSource::createIterator(). The PointIterator class only has one public method, getNextPoints(), which extracts points out of the point cloud. For each time you call ...\" /><Url Source=\"../Content/Text_Point_Readers_and_Writers.htm\" Title=\"Text Point Readers and Writers\" Abstract=\"The simplest and most flexible way of storing LiDAR data is using column delineated text (ASCII)&#160;files.  The TXTPointReader Class This is a concrete implementation of the PointSource class for reading text files. The TXTPointWriter Class This is a concrete implementation of the PointWriter class for ...\" /><Url Source=\"../Content/The_MG4PointReader_Class.htm\" Title=\"The MG4PointReader Class\" Abstract=\"The MG4PointReader class is the class that you will use to enable your application to read LiDAR-based MG4 files. MG4PointReader is a concrete implementation of the PointSource class (see  &quot;The PointSource Class&quot; ).  Opening an MG4 File There are two methods of opening an MG4 file: init() with an IO ...\" /><Url Source=\"../Content/The_Support_Classes.htm\" Title=\"The Support Classes\" Abstract=\"The MrSID Decode SDK&#160;includes several supporting classes, however, you will probably only need to engage the IO&#160;classes and the Bounds class. The IO&#160;Classes The SDK&#160;provides an abstract mechanism for reading and writing data. These mechanism constitute the IO class. The IO&#160;class provides methods for ...\" /><Url Source=\"../Content/The_Metadata_Class.htm\" Title=\"The Metadata Class\" Abstract=\"The Metadata class is a container for storing metadata about the point cloud. It is a key-value pair container that you can use to store strings, arrays of floating point values and raw binary data (BLOBs). Each key-value pair has the following properties: key name description  (optional)  data type ...\" /><Url Source=\"../Content/Code_Examples.htm\" Title=\"Code Examples\" Abstract=\"The MrSID Decode SDK&#160;includes code samples that demonstrate the use of the SDK\'s different interfaces. The following C++ (.cpp)&#160;files are located in your examples/src directory. Below, we walk through the UserTutorial.cpp example. The following code opens an MG4 file: FileIO *file = ...\" /><Url Source=\"../Content/MrSID_Decode_SDK_Command_Line_Tools.htm\" Title=\"MrSID Decode SDK Command Line Tools\" Abstract=\"The MrSID Decode  SDK includes several command line tools you may find useful for decompressing MrSID&#160;Generation 4 (MG4) files or viewing information about MG4, LAS or text LiDAR files. These tools are located in the      bin directory. Click any link below for more information. Viewing File ...\" /><Url Source=\"../Content/Decompressing_MG4_Files.htm\" Title=\"Decompressing MG4 Files\" Abstract=\"The MrSID Decode  SDK&#160;includes a command line tool called lidardecode. Located in the bin directory, lidardecode enables you to decompress MG4 files to LAS or text files. Usage The only required parameters are -inputFile (or -i), which specifies the input file name, and -outputFile (or -o), which ...\" /><Url Source=\"../Content/Viewing_File_Information.htm\" Title=\"Viewing File Information\" Abstract=\"The MrSID Decode  SDK&#160;includes a command line tool called lidarinfo. Located in the       bin directory, lidardinfo enables you to view the information in LAS or TXT files in text form. Usage The only required parameter for LAS files is -inputFile (or -i), which specifies the input file name. Text ...\" /><Url Source=\"../Content/Appendix_Company_and_Product_Information.htm\" Title=\"Appendix: Company and Product Information\" Abstract=\"This chapter contains information about LizardTech and its products as well as copyrights, trademarks and other information pertaining to this LizardTech software.&#xA;&#xA; Click any link below for more information About LizardTech  Other LizardTech Products MrSID and Patents\" /><Url Source=\"../Content/About_LizardTech_and_LizardTech_Products.htm\" Title=\"About LizardTech and LizardTech Products\" Abstract=\"About LizardTech Since 1992, LizardTech has delivered state-of-the-art software products for managing and distributing massive, high-resolution geospatial data such as aerial and satellite imagery and LiDAR data. LizardTech pioneered the MrSID® technology, a powerful wavelet-based image encoder, ...\" /><Url Source=\"../Content/Other_LizardTech_Products.htm\" Title=\"Other LizardTech Products\" Abstract=\"We at LizardTech are glad to have you creating products that support our software. We’re confident that you will find the LizardTech LiDAR Decode SDK to be everything you need to build support for MrSID&#160;Generation 4 into your products. While you’re “in the shop&quot;, explore LizardTech’s other great ...\" /><Url Source=\"../Content/Printed_Copyright_Page.htm\" Title=\"Printed Copyright Page\" Abstract=\"Copyright © 2009–2015 Celartem, Inc., doing business as LizardTech. All rights reserved. Information in this document is subject to change without notice. The software described in this document is furnished under a license agreement or nondisclosure agreement. The software may be used or copied ...\" /><Url Source=\"../Content/MrSID_and_Patents.htm\" Title=\"MrSID and Patents\" Abstract=\"MrSID and Patents This software is protected by patents and patents pending.\" /></urls><ents><stem n=\"introduct\" chunk=\"Search_Chunk1.xml\" /><stem n=\"thank\" chunk=\"Search_Chunk1.xml\" /><stem n=\"use\" chunk=\"Search_Chunk1.xml\" /><stem n=\"lizardtech\" chunk=\"Search_Chunk1.xml\" /><stem n=\"®\" chunk=\"Search_Chunk1.xml\" /><stem n=\"product\" chunk=\"Search_Chunk1.xml\" /><stem n=\"document\" chunk=\"Search_Chunk1.xml\" /><stem n=\"mrsid\" chunk=\"Search_Chunk1.xml\" /><stem n=\"decod\" chunk=\"Search_Chunk1.xml\" /><stem n=\"softwar\" chunk=\"Search_Chunk1.xml\" /><stem n=\"develop\" chunk=\"Search_Chunk1.xml\" /><stem n=\"kit\" chunk=\"Search_Chunk1.xml\" /><stem n=\"sdk\" chunk=\"Search_Chunk1.xml\" /><stem n=\"lidar\" chunk=\"Search_Chunk1.xml\" /><stem n=\"data\" chunk=\"Search_Chunk1.xml\" /><stem n=\"provid\" chunk=\"Search_Chunk1.xml\" /><stem n=\"framework\" chunk=\"Search_Chunk1.xml\" /><stem n=\"extract\" chunk=\"Search_Chunk1.xml\" /><stem n=\"generat\" chunk=\"Search_Chunk1.xml\" /><stem n=\"4\" chunk=\"Search_Chunk1.xml\" /><stem n=\"mg4™\" chunk=\"Search_Chunk1.xml\" /><stem n=\"file\" chunk=\"Search_Chunk1.xml\" /><stem n=\"becom\" chunk=\"Search_Chunk1.xml\" /><stem n=\"increas\" chunk=\"Search_Chunk1.xml\" /><stem n=\"import\" chunk=\"Search_Chunk1.xml\" /><stem n=\"aspect\" chunk=\"Search_Chunk1.xml\" /><stem n=\"busi\" chunk=\"Search_Chunk1.xml\" /><stem n=\"industri\" chunk=\"Search_Chunk1.xml\" /><stem n=\"govern\" chunk=\"Search_Chunk1.xml\" /><stem n=\"enorm\" chunk=\"Search_Chunk1.xml\" /><stem n=\"quantiti\" chunk=\"Search_Chunk1.xml\" /><stem n=\"involv\" chunk=\"Search_Chunk1.xml\" /><stem n=\"hinder\" chunk=\"Search_Chunk1.xml\" /><stem n=\"storag\" chunk=\"Search_Chunk1.xml\" /><stem n=\"bandwidth\" chunk=\"Search_Chunk1.xml\" /><stem n=\"constraint\" chunk=\"Search_Chunk1.xml\" /><stem n=\"technolog\" chunk=\"Search_Chunk1.xml\" /><stem n=\"solv\" chunk=\"Search_Chunk1.xml\" /><stem n=\"problem\" chunk=\"Search_Chunk1.xml\" /><stem n=\"lay\" chunk=\"Search_Chunk1.xml\" /><stem n=\"groundwork\" chunk=\"Search_Chunk1.xml\" /><stem n=\"truli\" chunk=\"Search_Chunk1.xml\" /><stem n=\"dynam\" chunk=\"Search_Chunk1.xml\" /><stem n=\"access\" chunk=\"Search_Chunk1.xml\" /><stem n=\"lossless\" chunk=\"Search_Chunk1.xml\" /><stem n=\"compress\" chunk=\"Search_Chunk1.xml\" /><stem n=\"compressor\" chunk=\"Search_Chunk1.xml\" /><stem n=\"enabl\" chunk=\"Search_Chunk1.xml\" /><stem n=\"user\" chunk=\"Search_Chunk1.xml\" /><stem n=\"turn\" chunk=\"Search_Chunk1.xml\" /><stem n=\"giant\" chunk=\"Search_Chunk1.xml\" /><stem n=\"point\" chunk=\"Search_Chunk1.xml\" /><stem n=\"cloud\" chunk=\"Search_Chunk1.xml\" /><stem n=\"set\" chunk=\"Search_Chunk1.xml\" /><stem n=\"effici\" chunk=\"Search_Chunk1.xml\" /><stem n=\"retain\" chunk=\"Search_Chunk1.xml\" /><stem n=\"100\" chunk=\"Search_Chunk1.xml\" /><stem n=\"percent\" chunk=\"Search_Chunk1.xml\" /><stem n=\"raw\" chunk=\"Search_Chunk1.xml\" /><stem n=\"just\" chunk=\"Search_Chunk1.xml\" /><stem n=\"25\" chunk=\"Search_Chunk1.xml\" /><stem n=\"less\" chunk=\"Search_Chunk1.xml\" /><stem n=\"origin\" chunk=\"Search_Chunk2.xml\" /><stem n=\"size\" chunk=\"Search_Chunk2.xml\" /><stem n=\"if\" chunk=\"Search_Chunk2.xml\" /><stem n=\"requir\" chunk=\"Search_Chunk2.xml\" /><stem n=\"critic\" chunk=\"Search_Chunk2.xml\" /><stem n=\"reduc\" chunk=\"Search_Chunk2.xml\" /><stem n=\"90\" chunk=\"Search_Chunk2.xml\" /><stem n=\"choos\" chunk=\"Search_Chunk2.xml\" /><stem n=\"higher\" chunk=\"Search_Chunk2.xml\" /><stem n=\"ratio\" chunk=\"Search_Chunk2.xml\" /><stem n=\"let\" chunk=\"Search_Chunk2.xml\" /><stem n=\"select\" chunk=\"Search_Chunk2.xml\" /><stem n=\"best\" chunk=\"Search_Chunk2.xml\" /><stem n=\"way\" chunk=\"Search_Chunk2.xml\" /><stem n=\"reach\" chunk=\"Search_Chunk2.xml\" /><stem n=\"desir\" chunk=\"Search_Chunk2.xml\" /><stem n=\"lossi\" chunk=\"Search_Chunk2.xml\" /><stem n=\"foundat\" chunk=\"Search_Chunk2.xml\" /><stem n=\"robust\" chunk=\"Search_Chunk2.xml\" /><stem n=\"toolkit\" chunk=\"Search_Chunk2.xml\" /><stem n=\"suitabl\" chunk=\"Search_Chunk2.xml\" /><stem n=\"complex\" chunk=\"Search_Chunk2.xml\" /><stem n=\"applic\" chunk=\"Search_Chunk2.xml\" /><stem n=\"need\" chunk=\"Search_Chunk2.xml\" /><stem n=\"format\" chunk=\"Search_Chunk2.xml\" /><stem n=\"support\" chunk=\"Search_Chunk2.xml\" /><stem n=\"raster\" chunk=\"Search_Chunk2.xml\" /><stem n=\"well\" chunk=\"Search_Chunk2.xml\" /><stem n=\"separ\" chunk=\"Search_Chunk2.xml\" /><stem n=\"tool\" chunk=\"Search_Chunk2.xml\" /><stem n=\"librari\" chunk=\"Search_Chunk2.xml\" /><stem n=\"avail\" chunk=\"Search_Chunk2.xml\" /><stem n=\"instal\" chunk=\"Search_Chunk2.xml\" /><stem n=\"integr\" chunk=\"Search_Chunk2.xml\" /><stem n=\"encod\" chunk=\"Search_Chunk2.xml\" /><stem n=\"mg4\" chunk=\"Search_Chunk2.xml\" /><stem n=\"standard\" chunk=\"Search_Chunk2.xml\" /><stem n=\"trust\" chunk=\"Search_Chunk2.xml\" /><stem n=\"geospati\" chunk=\"Search_Chunk2.xml\" /><stem n=\"profession\" chunk=\"Search_Chunk2.xml\" /><stem n=\"sinc\" chunk=\"Search_Chunk2.xml\" /><stem n=\"1992\" chunk=\"Search_Chunk2.xml\" /><stem n=\"virtual\" chunk=\"Search_Chunk2.xml\" /><stem n=\"gis\" chunk=\"Search_Chunk2.xml\" /><stem n=\"releas\" chunk=\"Search_Chunk2.xml\" /><stem n=\"unveil\" chunk=\"Search_Chunk2.xml\" /><stem n=\"new\" chunk=\"Search_Chunk2.xml\" /><stem n=\"improv\" chunk=\"Search_Chunk2.xml\" /><stem n=\"version\" chunk=\"Search_Chunk2.xml\" /><stem n=\"view\" chunk=\"Search_Chunk2.xml\" /><stem n=\"quick\" chunk=\"Search_Chunk2.xml\" /><stem n=\"click\" chunk=\"Search_Chunk2.xml\" /><stem n=\"ani\" chunk=\"Search_Chunk2.xml\" /><stem n=\"link\" chunk=\"Search_Chunk2.xml\" /><stem n=\"below\" chunk=\"Search_Chunk2.xml\" /><stem n=\"inform\" chunk=\"Search_Chunk2.xml\" /><stem n=\"content\" chunk=\"Search_Chunk2.xml\" /><stem n=\"architectur\" chunk=\"Search_Chunk2.xml\" /><stem n=\"design\" chunk=\"Search_Chunk2.xml\" /><stem n=\"follow\" chunk=\"Search_Chunk2.xml\" /><stem n=\"cover\" chunk=\"Search_Chunk2.xml\" /><stem n=\"readm\" chunk=\"Search_Chunk2.xml\" /><stem n=\"txt\" chunk=\"Search_Chunk2.xml\" /><stem n=\"top\" chunk=\"Search_Chunk2.xml\" /><stem n=\"level\" chunk=\"Search_Chunk2.xml\" /><stem n=\"directori\" chunk=\"Search_Chunk2.xml\" /><stem n=\"chang\" chunk=\"Search_Chunk2.xml\" /><stem n=\"doc\" chunk=\"Search_Chunk2.xml\" /><stem n=\"contain\" chunk=\"Search_Chunk2.xml\" /><stem n=\"licens\" chunk=\"Search_Chunk2.xml\" /><stem n=\"pdf\" chunk=\"Search_Chunk2.xml\" /><stem n=\"complet\" chunk=\"Search_Chunk2.xml\" /><stem n=\"manual\" chunk=\"Search_Chunk2.xml\" /><stem n=\"usermanu\" chunk=\"Search_Chunk2.xml\" /><stem n=\"index\" chunk=\"Search_Chunk2.xml\" /><stem n=\"html\" chunk=\"Search_Chunk2.xml\" /><stem n=\"refer\" chunk=\"Search_Chunk2.xml\" /><stem n=\"detail\" chunk=\"Search_Chunk2.xml\" /><stem n=\"class\" chunk=\"Search_Chunk2.xml\" /><stem n=\"method\" chunk=\"Search_Chunk2.xml\" /><stem n=\"referencemanu\" chunk=\"Search_Chunk2.xml\" /><stem n=\"copyright\" chunk=\"Search_Chunk2.xml\" /><stem n=\"trademark\" chunk=\"Search_Chunk2.xml\" /><stem n=\"credit\" chunk=\"Search_Chunk2.xml\" /><stem n=\"acknowledg\" chunk=\"Search_Chunk2.xml\" /><stem n=\"copyrights_trademarks_and_credit\" chunk=\"Search_Chunk2.xml\" /><stem n=\"header\" chunk=\"Search_Chunk2.xml\" /><stem n=\"locat\" chunk=\"Search_Chunk2.xml\" /><stem n=\"subdirectori\" chunk=\"Search_Chunk2.xml\" /><stem n=\"full\" chunk=\"Search_Chunk2.xml\" /><stem n=\"lib\" chunk=\"Search_Chunk2.xml\" /><stem n=\"sampl\" chunk=\"Search_Chunk2.xml\" /><stem n=\"command\" chunk=\"Search_Chunk2.xml\" /><stem n=\"line\" chunk=\"Search_Chunk2.xml\" /><stem n=\"bin\" chunk=\"Search_Chunk2.xml\" /><stem n=\"aid\" chunk=\"Search_Chunk2.xml\" /><stem n=\"debug\" chunk=\"Search_Chunk2.xml\" /><stem n=\"test\" chunk=\"Search_Chunk2.xml\" /><stem n=\"see\" chunk=\"Search_Chunk2.xml\" /><stem n=\"exampl\" chunk=\"Search_Chunk2.xml\" /><stem n=\"code\" chunk=\"Search_Chunk3.xml\" /><stem n=\"number\" chunk=\"Search_Chunk3.xml\" /><stem n=\"function\" chunk=\"Search_Chunk3.xml\" /><stem n=\"includ\" chunk=\"Search_Chunk3.xml\" /><stem n=\"src\" chunk=\"Search_Chunk3.xml\" /><stem n=\"addit\" chunk=\"Search_Chunk3.xml\" /><stem n=\"further\" chunk=\"Search_Chunk3.xml\" /><stem n=\"resourc\" chunk=\"Search_Chunk3.xml\" /><stem n=\"imag\" chunk=\"Search_Chunk3.xml\" /><stem n=\"work\" chunk=\"Search_Chunk3.xml\" /><stem n=\"http\" chunk=\"Search_Chunk3.xml\" /><stem n=\"us\" chunk=\"Search_Chunk3.xml\" /><stem n=\"com\" chunk=\"Search_Chunk3.xml\" /><stem n=\"lt_lidar_sample_data\" chunk=\"Search_Chunk3.xml\" /><stem n=\"zip\" chunk=\"Search_Chunk3.xml\" /><stem n=\"languag\" chunk=\"Search_Chunk3.xml\" /><stem n=\"bind\" chunk=\"Search_Chunk3.xml\" /><stem n=\"swig\" chunk=\"Search_Chunk3.xml\" /><stem n=\"ad\" chunk=\"Search_Chunk3.xml\" /><stem n=\"experiment\" chunk=\"Search_Chunk3.xml\" /><stem n=\"c\" chunk=\"Search_Chunk3.xml\" /><stem n=\"python\" chunk=\"Search_Chunk3.xml\" /><stem n=\"rubi\" chunk=\"Search_Chunk3.xml\" /><stem n=\"contribut\" chunk=\"Search_Chunk3.xml\" /><stem n=\"pleas\" chunk=\"Search_Chunk3.xml\" /><stem n=\"section\" chunk=\"Search_Chunk3.xml\" /><stem n=\"overview\" chunk=\"Search_Chunk3.xml\" /><stem n=\"insight\" chunk=\"Search_Chunk3.xml\" /><stem n=\"philosophi\" chunk=\"Search_Chunk3.xml\" /><stem n=\"basic\" chunk=\"Search_Chunk3.xml\" /><stem n=\"terminolog\" chunk=\"Search_Chunk3.xml\" /><stem n=\"three\" chunk=\"Search_Chunk3.xml\" /><stem n=\"dimension\" chunk=\"Search_Chunk3.xml\" /><stem n=\"3d\" chunk=\"Search_Chunk3.xml\" /><stem n=\"space\" chunk=\"Search_Chunk3.xml\" /><stem n=\"option\" chunk=\"Search_Chunk3.xml\" /><stem n=\"attribut\" chunk=\"Search_Chunk3.xml\" /><stem n=\"x\" chunk=\"Search_Chunk3.xml\" /><stem n=\"y\" chunk=\"Search_Chunk3.xml\" /><stem n=\"z\" chunk=\"Search_Chunk3.xml\" /><stem n=\"scan\" chunk=\"Search_Chunk3.xml\" /><stem n=\"angl\" chunk=\"Search_Chunk3.xml\" /><stem n=\"puls\" chunk=\"Search_Chunk3.xml\" /><stem n=\"intens\" chunk=\"Search_Chunk3.xml\" /><stem n=\"color\" chunk=\"Search_Chunk3.xml\" /><stem n=\"channel\" chunk=\"Search_Chunk3.xml\" /><stem n=\"valu\" chunk=\"Search_Chunk3.xml\" /><stem n=\"given\" chunk=\"Search_Chunk3.xml\" /><stem n=\"hierarchi\" chunk=\"Search_Chunk3.xml\" /><stem n=\"around\" chunk=\"Search_Chunk3.xml\" /><stem n=\"two\" chunk=\"Search_Chunk3.xml\" /><stem n=\"major\" chunk=\"Search_Chunk3.xml\" /><stem n=\"object\" chunk=\"Search_Chunk3.xml\" /><stem n=\"sourc\" chunk=\"Search_Chunk3.xml\" /><stem n=\"destin\" chunk=\"Search_Chunk3.xml\" /><stem n=\"deriv\" chunk=\"Search_Chunk3.xml\" /><stem n=\"pointsourc\" chunk=\"Search_Chunk3.xml\" /><stem n=\"pointwrit\" chunk=\"Search_Chunk3.xml\" /><stem n=\"deal\" chunk=\"Search_Chunk3.xml\" /><stem n=\"main\" chunk=\"Search_Chunk3.xml\" /><stem n=\"interest\" chunk=\"Search_Chunk3.xml\" /><stem n=\"subclass\" chunk=\"Search_Chunk3.xml\" /><stem n=\"mg4pointread\" chunk=\"Search_Chunk3.xml\" /><stem n=\"type\" chunk=\"Search_Chunk3.xml\" /><stem n=\"first\" chunk=\"Search_Chunk3.xml\" /><stem n=\"get\" chunk=\"Search_Chunk3.xml\" /><stem n=\"properti\" chunk=\"Search_Chunk3.xml\" /><stem n=\"itself\" chunk=\"Search_Chunk3.xml\" /><stem n=\"either\" chunk=\"Search_Chunk3.xml\" /><stem n=\"entir\" chunk=\"Search_Chunk3.xml\" /><stem n=\"subset\" chunk=\"Search_Chunk3.xml\" /><stem n=\"thereof\" chunk=\"Search_Chunk3.xml\" /><stem n=\"specifi\" chunk=\"Search_Chunk3.xml\" /><stem n=\"region\" chunk=\"Search_Chunk3.xml\" /><stem n=\"must\" chunk=\"Search_Chunk3.xml\" /><stem n=\"wish\" chunk=\"Search_Chunk3.xml\" /><stem n=\"call\" chunk=\"Search_Chunk3.xml\" /><stem n=\"bound\" chunk=\"Search_Chunk3.xml\" /><stem n=\"box\" chunk=\"Search_Chunk3.xml\" /><stem n=\"huge_v\" chunk=\"Search_Chunk3.xml\" /><stem n=\"infin\" chunk=\"Search_Chunk3.xml\" /><stem n=\"+huge_v\" chunk=\"Search_Chunk3.xml\" /><stem n=\"+infin\" chunk=\"Search_Chunk3.xml\" /><stem n=\"rang\" chunk=\"Search_Chunk3.xml\" /><stem n=\"general\" chunk=\"Search_Chunk3.xml\" /><stem n=\"defin\" chunk=\"Search_Chunk3.xml\" /><stem n=\"far\" chunk=\"Search_Chunk3.xml\" /><stem n=\"so\" chunk=\"Search_Chunk3.xml\" /><stem n=\"fraction\" chunk=\"Search_Chunk3.xml\" /><stem n=\"want\" chunk=\"Search_Chunk3.xml\" /><stem n=\"everi\" chunk=\"Search_Chunk3.xml\" /><stem n=\"20th\" chunk=\"Search_Chunk3.xml\" /><stem n=\"0\" chunk=\"Search_Chunk3.xml\" /><stem n=\"05\" chunk=\"Search_Chunk3.xml\" /><stem n=\"1\" chunk=\"Search_Chunk3.xml\" /><stem n=\"20\" chunk=\"Search_Chunk3.xml\" /><stem n=\"buffer\" chunk=\"Search_Chunk3.xml\" /><stem n=\"pointdata\" chunk=\"Search_Chunk3.xml\" /><stem n=\"pass\" chunk=\"Search_Chunk3.xml\" /><stem n=\"part\" chunk=\"Search_Chunk3.xml\" /><stem n=\"group\" chunk=\"Search_Chunk3.xml\" /><stem n=\"manag\" chunk=\"Search_Chunk3.xml\" /><stem n=\"program\" chunk=\"Search_Chunk3.xml\" /><stem n=\"memori\" chunk=\"Search_Chunk3.xml\" /><stem n=\"model\" chunk=\"Search_Chunk3.xml\" /><stem n=\"alloc\" chunk=\"Search_Chunk3.xml\" /><stem n=\"initi\" chunk=\"Search_Chunk3.xml\" /><stem n=\"mean\" chunk=\"Search_Chunk4.xml\" /><stem n=\"constructor\" chunk=\"Search_Chunk4.xml\" /><stem n=\"take\" chunk=\"Search_Chunk4.xml\" /><stem n=\"argument\" chunk=\"Search_Chunk4.xml\" /><stem n=\"one\" chunk=\"Search_Chunk4.xml\" /><stem n=\"init\" chunk=\"Search_Chunk4.xml\" /><stem n=\"make\" chunk=\"Search_Chunk4.xml\" /><stem n=\"easier\" chunk=\"Search_Chunk4.xml\" /><stem n=\"except\" chunk=\"Search_Chunk4.xml\" /><stem n=\"chain\" chunk=\"Search_Chunk4.xml\" /><stem n=\"count\" chunk=\"Search_Chunk4.xml\" /><stem n=\"long\" chunk=\"Search_Chunk4.xml\" /><stem n=\"unknown\" chunk=\"Search_Chunk4.xml\" /><stem n=\"life\" chunk=\"Search_Chunk4.xml\" /><stem n=\"span\" chunk=\"Search_Chunk4.xml\" /><stem n=\"base\" chunk=\"Search_Chunk4.xml\" /><stem n=\"increment\" chunk=\"Search_Chunk4.xml\" /><stem n=\"decrement\" chunk=\"Search_Chunk4.xml\" /><stem n=\"counter\" chunk=\"Search_Chunk4.xml\" /><stem n=\"start\" chunk=\"Search_Chunk4.xml\" /><stem n=\"creat\" chunk=\"Search_Chunk4.xml\" /><stem n=\"respons\" chunk=\"Search_Chunk4.xml\" /><stem n=\"caller\" chunk=\"Search_Chunk4.xml\" /><stem n=\"done\" chunk=\"Search_Chunk4.xml\" /><stem n=\"pointer\" chunk=\"Search_Chunk4.xml\" /><stem n=\"goe\" chunk=\"Search_Chunk4.xml\" /><stem n=\"out\" chunk=\"Search_Chunk4.xml\" /><stem n=\"scope\" chunk=\"Search_Chunk4.xml\" /><stem n=\"time\" chunk=\"Search_Chunk4.xml\" /><stem n=\"en\" chunk=\"Search_Chunk4.xml\" /><stem n=\"wikipedia\" chunk=\"Search_Chunk4.xml\" /><stem n=\"org\" chunk=\"Search_Chunk4.xml\" /><stem n=\"wiki\" chunk=\"Search_Chunk4.xml\" /><stem n=\"reference_count\" chunk=\"Search_Chunk4.xml\" /><stem n=\"sdks\" chunk=\"Search_Chunk4.xml\" /><stem n=\"name\" chunk=\"Search_Chunk4.xml\" /><stem n=\"convent\" chunk=\"Search_Chunk4.xml\" /><stem n=\"pattern\" chunk=\"Search_Chunk4.xml\" /><stem n=\"those\" chunk=\"Search_Chunk4.xml\" /><stem n=\"thread\" chunk=\"Search_Chunk4.xml\" /><stem n=\"safeti\" chunk=\"Search_Chunk4.xml\" /><stem n=\"safe\" chunk=\"Search_Chunk4.xml\" /><stem n=\"onc\" chunk=\"Search_Chunk4.xml\" /><stem n=\"instanc\" chunk=\"Search_Chunk4.xml\" /><stem n=\"state\" chunk=\"Search_Chunk4.xml\" /><stem n=\"specif\" chunk=\"Search_Chunk4.xml\" /><stem n=\"store\" chunk=\"Search_Chunk4.xml\" /><stem n=\"pointiter\" chunk=\"Search_Chunk4.xml\" /><stem n=\"quantiz\" chunk=\"Search_Chunk4.xml\" /><stem n=\"float\" chunk=\"Search_Chunk4.xml\" /><stem n=\"convert\" chunk=\"Search_Chunk4.xml\" /><stem n=\"integ\" chunk=\"Search_Chunk4.xml\" /><stem n=\"facilit\" chunk=\"Search_Chunk4.xml\" /><stem n=\"wavelet\" chunk=\"Search_Chunk4.xml\" /><stem n=\"las\" chunk=\"Search_Chunk4.xml\" /><stem n=\"transform\" chunk=\"Search_Chunk4.xml\" /><stem n=\"achiev\" chunk=\"Search_Chunk4.xml\" /><stem n=\"result\" chunk=\"Search_Chunk4.xml\" /><stem n=\"even\" chunk=\"Search_Chunk4.xml\" /><stem n=\"do\" chunk=\"Search_Chunk4.xml\" /><stem n=\"error\" chunk=\"Search_Chunk4.xml\" /><stem n=\"analysi\" chunk=\"Search_Chunk4.xml\" /><stem n=\"factor\" chunk=\"Search_Chunk4.xml\" /><stem n=\"scale\" chunk=\"Search_Chunk4.xml\" /><stem n=\"calcul\" chunk=\"Search_Chunk4.xml\" /><stem n=\"convers\" chunk=\"Search_Chunk4.xml\" /><stem n=\"+\" chunk=\"Search_Chunk4.xml\" /><stem n=\"offset\" chunk=\"Search_Chunk4.xml\" /><stem n=\"floor\" chunk=\"Search_Chunk4.xml\" /><stem n=\"5\" chunk=\"Search_Chunk4.xml\" /><stem n=\"go\" chunk=\"Search_Chunk4.xml\" /><stem n=\"back\" chunk=\"Search_Chunk4.xml\" /><stem n=\"again\" chunk=\"Search_Chunk4.xml\" /><stem n=\"abov\" chunk=\"Search_Chunk4.xml\" /><stem n=\"stabil\" chunk=\"Search_Chunk4.xml\" /><stem n=\"minim\" chunk=\"Search_Chunk4.xml\" /><stem n=\"chapter\" chunk=\"Search_Chunk4.xml\" /><stem n=\"preliminari\" chunk=\"Search_Chunk4.xml\" /><stem n=\"should\" chunk=\"Search_Chunk4.xml\" /><stem n=\"give\" chunk=\"Search_Chunk4.xml\" /><stem n=\"enough\" chunk=\"Search_Chunk4.xml\" /><stem n=\"determin\" chunk=\"Search_Chunk4.xml\" /><stem n=\"what\" chunk=\"Search_Chunk4.xml\" /><stem n=\"own\" chunk=\"Search_Chunk4.xml\" /><stem n=\"will\" chunk=\"Search_Chunk4.xml\" /><stem n=\"system\" chunk=\"Search_Chunk4.xml\" /><stem n=\"technic\" chunk=\"Search_Chunk4.xml\" /><stem n=\"c++\" chunk=\"Search_Chunk4.xml\" /><stem n=\"conjunct\" chunk=\"Search_Chunk4.xml\" /><stem n=\"environ\" chunk=\"Search_Chunk4.xml\" /><stem n=\"platform\" chunk=\"Search_Chunk4.xml\" /><stem n=\"configur\" chunk=\"Search_Chunk4.xml\" /><stem n=\"list\" chunk=\"Search_Chunk4.xml\" /><stem n=\"optim\" chunk=\"Search_Chunk4.xml\" /><stem n=\"perform\" chunk=\"Search_Chunk4.xml\" /><stem n=\"verifi\" chunk=\"Search_Chunk4.xml\" /><stem n=\"meet\" chunk=\"Search_Chunk4.xml\" /><stem n=\"minimum\" chunk=\"Search_Chunk4.xml\" /><stem n=\"recommend\" chunk=\"Search_Chunk4.xml\" /><stem n=\"hardwar\" chunk=\"Search_Chunk4.xml\" /><stem n=\"2\" chunk=\"Search_Chunk4.xml\" /><stem n=\"ghz\" chunk=\"Search_Chunk4.xml\" /><stem n=\"processor\" chunk=\"Search_Chunk4.xml\" /><stem n=\"gb\" chunk=\"Search_Chunk4.xml\" /><stem n=\"ram\" chunk=\"Search_Chunk4.xml\" /><stem n=\"contact\" chunk=\"Search_Chunk4.xml\" /><stem n=\"distribut\" chunk=\"Search_Chunk4.xml\" /><stem n=\"window\" chunk=\"Search_Chunk4.xml\" /><stem n=\"target\" chunk=\"Search_Chunk4.xml\" /><stem n=\"visual\" chunk=\"Search_Chunk4.xml\" /><stem n=\"studio\" chunk=\"Search_Chunk4.xml\" /><stem n=\"2013\" chunk=\"Search_Chunk4.xml\" /><stem n=\"server\" chunk=\"Search_Chunk4.xml\" /><stem n=\"2008\" chunk=\"Search_Chunk4.xml\" /><stem n=\"newer\" chunk=\"Search_Chunk4.xml\" /><stem n=\"32\" chunk=\"Search_Chunk4.xml\" /><stem n=\"bit\" chunk=\"Search_Chunk4.xml\" /><stem n=\"vista\" chunk=\"Search_Chunk4.xml\" /><stem n=\"7\" chunk=\"Search_Chunk4.xml\" /><stem n=\"8\" chunk=\"Search_Chunk4.xml\" /><stem n=\"2003\" chunk=\"Search_Chunk4.xml\" /><stem n=\"12\" chunk=\"Search_Chunk4.xml\" /><stem n=\"vc12\" chunk=\"Search_Chunk4.xml\" /><stem n=\"64\" chunk=\"Search_Chunk4.xml\" /><stem n=\"2015\" chunk=\"Search_Chunk4.xml\" /><stem n=\"10\" chunk=\"Search_Chunk4.xml\" /><stem n=\"14\" chunk=\"Search_Chunk4.xml\" /><stem n=\"vc14\" chunk=\"Search_Chunk4.xml\" /><stem n=\"linux\" chunk=\"Search_Chunk4.xml\" /><stem n=\"gcc\" chunk=\"Search_Chunk4.xml\" /><stem n=\"rhel\" chunk=\"Search_Chunk4.xml\" /><stem n=\"6\" chunk=\"Search_Chunk4.xml\" /><stem n=\"3\" chunk=\"Search_Chunk4.xml\" /><stem n=\"cento\" chunk=\"Search_Chunk4.xml\" /><stem n=\"red\" chunk=\"Search_Chunk4.xml\" /><stem n=\"hat\" chunk=\"Search_Chunk4.xml\" /><stem n=\"built\" chunk=\"Search_Chunk4.xml\" /><stem n=\"toolset\" chunk=\"Search_Chunk4.xml\" /><stem n=\"enterpris\" chunk=\"Search_Chunk4.xml\" /><stem n=\"execut\" chunk=\"Search_Chunk4.xml\" /><stem n=\"compil\" chunk=\"Search_Chunk4.xml\" /><stem n=\"collect\" chunk=\"Search_Chunk4.xml\" /><stem n=\"macintosh\" chunk=\"Search_Chunk4.xml\" /><stem n=\"clang\" chunk=\"Search_Chunk4.xml\" /><stem n=\"xcode\" chunk=\"Search_Chunk4.xml\" /><stem n=\"mac\" chunk=\"Search_Chunk4.xml\" /><stem n=\"os\" chunk=\"Search_Chunk4.xml\" /><stem n=\"11\" chunk=\"Search_Chunk4.xml\" /><stem n=\"maco\" chunk=\"Search_Chunk4.xml\" /><stem n=\"univers\" chunk=\"Search_Chunk4.xml\" /><stem n=\"darwin\" chunk=\"Search_Chunk4.xml\" /><stem n=\"15\" chunk=\"Search_Chunk4.xml\" /><stem n=\"16\" chunk=\"Search_Chunk4.xml\" /><stem n=\"io\" chunk=\"Search_Chunk4.xml\" /><stem n=\"armv7\" chunk=\"Search_Chunk4.xml\" /><stem n=\"arm64\" chunk=\"Search_Chunk4.xml\" /><stem n=\"x86\" chunk=\"Search_Chunk4.xml\" /><stem n=\"simul\" chunk=\"Search_Chunk4.xml\" /><stem n=\"android\" chunk=\"Search_Chunk5.xml\" /><stem n=\"ndk\" chunk=\"Search_Chunk5.xml\" /><stem n=\"13b\" chunk=\"Search_Chunk5.xml\" /><stem n=\"ubuntu\" chunk=\"Search_Chunk5.xml\" /><stem n=\"desktop\" chunk=\"Search_Chunk5.xml\" /><stem n=\"04\" chunk=\"Search_Chunk5.xml\" /><stem n=\"api\" chunk=\"Search_Chunk5.xml\" /><stem n=\"armeabi\" chunk=\"Search_Chunk5.xml\" /><stem n=\"v7a\" chunk=\"Search_Chunk5.xml\" /><stem n=\"v8a\" chunk=\"Search_Chunk5.xml\" /><stem n=\"x86_64\" chunk=\"Search_Chunk5.xml\" /><stem n=\"9\" chunk=\"Search_Chunk5.xml\" /><stem n=\"beyond\" chunk=\"Search_Chunk5.xml\" /><stem n=\"copi\" chunk=\"Search_Chunk5.xml\" /><stem n=\"media\" chunk=\"Search_Chunk5.xml\" /><stem n=\"cd\" chunk=\"Search_Chunk5.xml\" /><stem n=\"iso\" chunk=\"Search_Chunk5.xml\" /><stem n=\"archiv\" chunk=\"Search_Chunk5.xml\" /><stem n=\"ftp\" chunk=\"Search_Chunk5.xml\" /><stem n=\"site\" chunk=\"Search_Chunk5.xml\" /><stem n=\"etc\" chunk=\"Search_Chunk5.xml\" /><stem n=\"local\" chunk=\"Search_Chunk5.xml\" /><stem n=\"comput\" chunk=\"Search_Chunk5.xml\" /><stem n=\"issu\" chunk=\"Search_Chunk5.xml\" /><stem n=\"resolv\" chunk=\"Search_Chunk5.xml\" /><stem n=\"various\" chunk=\"Search_Chunk5.xml\" /><stem n=\"offer\" chunk=\"Search_Chunk5.xml\" /><stem n=\"knowledg\" chunk=\"Search_Chunk5.xml\" /><stem n=\"updat\" chunk=\"Search_Chunk5.xml\" /><stem n=\"websit\" chunk=\"Search_Chunk5.xml\" /><stem n=\"www\" chunk=\"Search_Chunk5.xml\" /><stem n=\"kb\" chunk=\"Search_Chunk5.xml\" /><stem n=\"articl\" chunk=\"Search_Chunk5.xml\" /><stem n=\"known\" chunk=\"Search_Chunk5.xml\" /><stem n=\"usag\" chunk=\"Search_Chunk5.xml\" /><stem n=\"frequent\" chunk=\"Search_Chunk5.xml\" /><stem n=\"within\" chunk=\"Search_Chunk5.xml\" /><stem n=\"download\" chunk=\"Search_Chunk5.xml\" /><stem n=\"note\" chunk=\"Search_Chunk5.xml\" /><stem n=\"email\" chunk=\"Search_Chunk5.xml\" /><stem n=\"communiti\" chunk=\"Search_Chunk5.xml\" /><stem n=\"forum\" chunk=\"Search_Chunk5.xml\" /><stem n=\"place\" chunk=\"Search_Chunk5.xml\" /><stem n=\"engag\" chunk=\"Search_Chunk5.xml\" /><stem n=\"intellig\" chunk=\"Search_Chunk5.xml\" /><stem n=\"discours\" chunk=\"Search_Chunk5.xml\" /><stem n=\"ask\" chunk=\"Search_Chunk5.xml\" /><stem n=\"question\" chunk=\"Search_Chunk5.xml\" /><stem n=\"answer\" chunk=\"Search_Chunk5.xml\" /><stem n=\"share\" chunk=\"Search_Chunk5.xml\" /><stem n=\"tip\" chunk=\"Search_Chunk5.xml\" /><stem n=\"custom\" chunk=\"Search_Chunk5.xml\" /><stem n=\"world\" chunk=\"Search_Chunk5.xml\" /><stem n=\"viewer\" chunk=\"Search_Chunk5.xml\" /><stem n=\"cost\" chunk=\"Search_Chunk5.xml\" /><stem n=\"plan\" chunk=\"Search_Chunk5.xml\" /><stem n=\"purchas\" chunk=\"Search_Chunk5.xml\" /><stem n=\"php\" chunk=\"Search_Chunk5.xml\" /><stem n=\"protect\" chunk=\"Search_Chunk5.xml\" /><stem n=\"invest\" chunk=\"Search_Chunk5.xml\" /><stem n=\"particip\" chunk=\"Search_Chunk5.xml\" /><stem n=\"lizarttech\" chunk=\"Search_Chunk5.xml\" /><stem n=\"offic\" chunk=\"Search_Chunk5.xml\" /><stem n=\"visit\" chunk=\"Search_Chunk5.xml\" /><stem n=\"url\" chunk=\"Search_Chunk5.xml\" /><stem n=\"activ\" chunk=\"Search_Chunk5.xml\" /><stem n=\"page\" chunk=\"Search_Chunk5.xml\" /><stem n=\"form\" chunk=\"Search_Chunk5.xml\" /><stem n=\"assist\" chunk=\"Search_Chunk5.xml\" /><stem n=\"emerg\" chunk=\"Search_Chunk5.xml\" /><stem n=\"206\" chunk=\"Search_Chunk5.xml\" /><stem n=\"902\" chunk=\"Search_Chunk5.xml\" /><stem n=\"2845\" chunk=\"Search_Chunk5.xml\" /><stem n=\"hour\" chunk=\"Search_Chunk5.xml\" /><stem n=\"am\" chunk=\"Search_Chunk5.xml\" /><stem n=\"pm\" chunk=\"Search_Chunk5.xml\" /><stem n=\"pacif\" chunk=\"Search_Chunk5.xml\" /><stem n=\"befor\" chunk=\"Search_Chunk5.xml\" /><stem n=\"run\" chunk=\"Search_Chunk5.xml\" /><stem n=\"oper\" chunk=\"Search_Chunk5.xml\" /><stem n=\"how\" chunk=\"Search_Chunk5.xml\" /><stem n=\"much\" chunk=\"Search_Chunk5.xml\" /><stem n=\"free\" chunk=\"Search_Chunk5.xml\" /><stem n=\"hard\" chunk=\"Search_Chunk5.xml\" /><stem n=\"drive\" chunk=\"Search_Chunk5.xml\" /><stem n=\"demonstr\" chunk=\"Search_Chunk5.xml\" /><stem n=\"simplifi\" chunk=\"Search_Chunk5.xml\" /><stem n=\"possibl\" chunk=\"Search_Chunk5.xml\" /><stem n=\"relev\" chunk=\"Search_Chunk5.xml\" /><stem n=\"allow\" chunk=\"Search_Chunk5.xml\" /><stem n=\"reproduc\" chunk=\"Search_Chunk5.xml\" /><stem n=\"messag\" chunk=\"Search_Chunk5.xml\" /><stem n=\"appropri\" chunk=\"Search_Chunk5.xml\" /><stem n=\"describ\" chunk=\"Search_Chunk5.xml\" /><stem n=\"text\" chunk=\"Search_Chunk5.xml\" /><stem n=\"reader\" chunk=\"Search_Chunk5.xml\" /><stem n=\"writer\" chunk=\"Search_Chunk5.xml\" /><stem n=\"metadata\" chunk=\"Search_Chunk5.xml\" /><stem n=\"root\" chunk=\"Search_Chunk5.xml\" /><stem n=\"descript\" chunk=\"Search_Chunk5.xml\" /><stem n=\"getnumpoint\" chunk=\"Search_Chunk5.xml\" /><stem n=\"getnumchannel\" chunk=\"Search_Chunk5.xml\" /><stem n=\"getpointinfo\" chunk=\"Search_Chunk5.xml\" /><stem n=\"channelinfo\" chunk=\"Search_Chunk5.xml\" /><stem n=\"pointinfo\" chunk=\"Search_Chunk5.xml\" /><stem n=\"getscal\" chunk=\"Search_Chunk5.xml\" /><stem n=\"getoffset\" chunk=\"Search_Chunk5.xml\" /><stem n=\"null\" chunk=\"Search_Chunk5.xml\" /><stem n=\"return\" chunk=\"Search_Chunk5.xml\" /><stem n=\"otherwis\" chunk=\"Search_Chunk5.xml\" /><stem n=\"array\" chunk=\"Search_Chunk5.xml\" /><stem n=\"doubl\" chunk=\"Search_Chunk5.xml\" /><stem n=\"s\" chunk=\"Search_Chunk5.xml\" /><stem n=\"repres\" chunk=\"Search_Chunk5.xml\" /><stem n=\"auxiliari\" chunk=\"Search_Chunk5.xml\" /><stem n=\"key\" chunk=\"Search_Chunk5.xml\" /><stem n=\"pair\" chunk=\"Search_Chunk5.xml\" /><stem n=\"add\" chunk=\"Search_Chunk5.xml\" /><stem n=\"string\" chunk=\"Search_Chunk5.xml\" /><stem n=\"binari\" chunk=\"Search_Chunk5.xml\" /><stem n=\"loadmetadata\" chunk=\"Search_Chunk5.xml\" /><stem n=\"classif\" chunk=\"Search_Chunk5.xml\" /><stem n=\"classid\" chunk=\"Search_Chunk5.xml\" /><stem n=\"classidnam\" chunk=\"Search_Chunk5.xml\" /><stem n=\"getnumclassidnam\" chunk=\"Search_Chunk5.xml\" /><stem n=\"getclassidnam\" chunk=\"Search_Chunk5.xml\" /><stem n=\"iter\" chunk=\"Search_Chunk5.xml\" /><stem n=\"createiter\" chunk=\"Search_Chunk5.xml\" /><stem n=\"getnextpoint\" chunk=\"Search_Chunk5.xml\" /><stem n=\"walk\" chunk=\"Search_Chunk5.xml\" /><stem n=\"pointinter\" chunk=\"Search_Chunk5.xml\" /><stem n=\"fix\" chunk=\"Search_Chunk5.xml\" /><stem n=\"simpler\" chunk=\"Search_Chunk5.xml\" /><stem n=\"versatil\" chunk=\"Search_Chunk5.xml\" /><stem n=\"read\" chunk=\"Search_Chunk5.xml\" /><stem n=\"fill\" chunk=\"Search_Chunk5.xml\" /><stem n=\"uniform\" chunk=\"Search_Chunk5.xml\" /><stem n=\"write\" chunk=\"Search_Chunk5.xml\" /><stem n=\"up\" chunk=\"Search_Chunk5.xml\" /><stem n=\"output\" chunk=\"Search_Chunk5.xml\" /><stem n=\"default\" chunk=\"Search_Chunk5.xml\" /><stem n=\"retriev\" chunk=\"Search_Chunk5.xml\" /><stem n=\"modifi\" chunk=\"Search_Chunk5.xml\" /><stem n=\"necessari\" chunk=\"Search_Chunk5.xml\" /><stem n=\"setmetadata\" chunk=\"Search_Chunk5.xml\" /><stem n=\"getmetadata\" chunk=\"Search_Chunk5.xml\" /><stem n=\"same\" chunk=\"Search_Chunk5.xml\" /><stem n=\"input\" chunk=\"Search_Chunk5.xml\" /><stem n=\"overrid\" chunk=\"Search_Chunk5.xml\" /><stem n=\"behavior\" chunk=\"Search_Chunk5.xml\" /><stem n=\"explicit\" chunk=\"Search_Chunk5.xml\" /><stem n=\"setquant\" chunk=\"Search_Chunk5.xml\" /><stem n=\"channeldata\" chunk=\"Search_Chunk5.xml\" /><stem n=\"sign\" chunk=\"Search_Chunk5.xml\" /><stem n=\"datatyp\" chunk=\"Search_Chunk5.xml\" /><stem n=\"enum\" chunk=\"Search_Chunk5.xml\" /><stem n=\"precis\" chunk=\"Search_Chunk5.xml\" /><stem n=\"handl\" chunk=\"Search_Chunk5.xml\" /><stem n=\"physic\" chunk=\"Search_Chunk5.xml\" /><stem n=\"represent\" chunk=\"Search_Chunk5.xml\" /><stem n=\"magnitud\" chunk=\"Search_Chunk5.xml\" /><stem n=\"returnnum\" chunk=\"Search_Chunk5.xml\" /><stem n=\"uniqu\" chunk=\"Search_Chunk5.xml\" /><stem n=\"sequenti\" chunk=\"Search_Chunk5.xml\" /><stem n=\"identifi\" chunk=\"Search_Chunk5.xml\" /><stem n=\"numreturn\" chunk=\"Search_Chunk5.xml\" /><stem n=\"total\" chunk=\"Search_Chunk5.xml\" /><stem n=\"scandir\" chunk=\"Search_Chunk5.xml\" /><stem n=\"direct\" chunk=\"Search_Chunk5.xml\" /><stem n=\"scanner\" chunk=\"Search_Chunk5.xml\" /><stem n=\"mirror\" chunk=\"Search_Chunk5.xml\" /><stem n=\"travel\" chunk=\"Search_Chunk5.xml\" /><stem n=\"edgeflightlin\" chunk=\"Search_Chunk5.xml\" /><stem n=\"edg\" chunk=\"Search_Chunk5.xml\" /><stem n=\"flight\" chunk=\"Search_Chunk5.xml\" /><stem n=\"last\" chunk=\"Search_Chunk5.xml\" /><stem n=\"end\" chunk=\"Search_Chunk5.xml\" /><stem n=\"move\" chunk=\"Search_Chunk5.xml\" /><stem n=\"scanangl\" chunk=\"Search_Chunk5.xml\" /><stem n=\"off\" chunk=\"Search_Chunk5.xml\" /><stem n=\"nadir\" chunk=\"Search_Chunk5.xml\" /><stem n=\"negat\" chunk=\"Search_Chunk5.xml\" /><stem n=\"port\" chunk=\"Search_Chunk5.xml\" /><stem n=\"side\" chunk=\"Search_Chunk5.xml\" /><stem n=\"plane\" chunk=\"Search_Chunk5.xml\" /><stem n=\"posit\" chunk=\"Search_Chunk5.xml\" /><stem n=\"starboard\" chunk=\"Search_Chunk5.xml\" /><stem n=\"zero\" chunk=\"Search_Chunk5.xml\" /><stem n=\"userdata\" chunk=\"Search_Chunk5.xml\" /><stem n=\"sourceid\" chunk=\"Search_Chunk5.xml\" /><stem n=\"gpstime\" chunk=\"Search_Chunk5.xml\" /><stem n=\"gps\" chunk=\"Search_Chunk5.xml\" /><stem n=\"green\" chunk=\"Search_Chunk5.xml\" /><stem n=\"blue\" chunk=\"Search_Chunk5.xml\" /><stem n=\"userdefinedchannelnam\" chunk=\"Search_Chunk5.xml\" /><stem n=\"creator\" chunk=\"Search_Chunk5.xml\" /><stem n=\"would\" chunk=\"Search_Chunk5.xml\" /><stem n=\"like\" chunk=\"Search_Chunk5.xml\" /><stem n=\"obviat\" chunk=\"Search_Chunk5.xml\" /><stem n=\"associ\" chunk=\"Search_Chunk5.xml\" /><stem n=\"length\" chunk=\"Search_Chunk5.xml\" /><stem n=\"primari\" chunk=\"Search_Chunk5.xml\" /><stem n=\"public\" chunk=\"Search_Chunk5.xml\" /><stem n=\"simplest\" chunk=\"Search_Chunk5.xml\" /><stem n=\"flexibl\" chunk=\"Search_Chunk5.xml\" /><stem n=\"column\" chunk=\"Search_Chunk5.xml\" /><stem n=\"delin\" chunk=\"Search_Chunk6.xml\" /><stem n=\"ascii\" chunk=\"Search_Chunk6.xml\" /><stem n=\"txtpointread\" chunk=\"Search_Chunk6.xml\" /><stem n=\"concret\" chunk=\"Search_Chunk6.xml\" /><stem n=\"implement\" chunk=\"Search_Chunk6.xml\" /><stem n=\"txtpointwrit\" chunk=\"Search_Chunk6.xml\" /><stem n=\"open\" chunk=\"Search_Chunk6.xml\" /><stem n=\"prefer\" chunk=\"Search_Chunk6.xml\" /><stem n=\"fileio\" chunk=\"Search_Chunk6.xml\" /><stem n=\"second\" chunk=\"Search_Chunk6.xml\" /><stem n=\"nativ\" chunk=\"Search_Chunk6.xml\" /><stem n=\"codepag\" chunk=\"Search_Chunk6.xml\" /><stem n=\"caus\" chunk=\"Search_Chunk6.xml\" /><stem n=\"can\'t\" chunk=\"Search_Chunk6.xml\" /><stem n=\"path\" chunk=\"Search_Chunk6.xml\" /><stem n=\"probabl\" chunk=\"Search_Chunk6.xml\" /><stem n=\"abstract\" chunk=\"Search_Chunk6.xml\" /><stem n=\"mechan\" chunk=\"Search_Chunk6.xml\" /><stem n=\"constitut\" chunk=\"Search_Chunk6.xml\" /><stem n=\"close\" chunk=\"Search_Chunk6.xml\" /><stem n=\"byte\" chunk=\"Search_Chunk6.xml\" /><stem n=\"differ\" chunk=\"Search_Chunk6.xml\" /><stem n=\"unix\" chunk=\"Search_Chunk6.xml\" /><stem n=\"stdio\" chunk=\"Search_Chunk6.xml\" /><stem n=\"interfac\" chunk=\"Search_Chunk6.xml\" /><stem n=\"mimic\" chunk=\"Search_Chunk6.xml\" /><stem n=\"posix\" chunk=\"Search_Chunk6.xml\" /><stem n=\"pread\" chunk=\"Search_Chunk6.xml\" /><stem n=\"pwrite\" chunk=\"Search_Chunk6.xml\" /><stem n=\"ensur\" chunk=\"Search_Chunk6.xml\" /><stem n=\"multipl\" chunk=\"Search_Chunk6.xml\" /><stem n=\"simultan\" chunk=\"Search_Chunk6.xml\" /><stem n=\"disk\" chunk=\"Search_Chunk6.xml\" /><stem n=\"interv\" chunk=\"Search_Chunk6.xml\" /><stem n=\"axe\" chunk=\"Search_Chunk6.xml\" /><stem n=\"member\" chunk=\"Search_Chunk6.xml\" /><stem n=\"variabl\" chunk=\"Search_Chunk6.xml\" /><stem n=\"min\" chunk=\"Search_Chunk6.xml\" /><stem n=\"max\" chunk=\"Search_Chunk6.xml\" /><stem n=\"conflict\" chunk=\"Search_Chunk6.xml\" /><stem n=\"macro\" chunk=\"Search_Chunk6.xml\" /><stem n=\"h\" chunk=\"Search_Chunk6.xml\" /><stem n=\"avoid\" chunk=\"Search_Chunk6.xml\" /><stem n=\"undefin\" chunk=\"Search_Chunk6.xml\" /><stem n=\"blob\" chunk=\"Search_Chunk6.xml\" /><stem n=\"real\" chunk=\"Search_Chunk6.xml\" /><stem n=\"metadatadatatyp\" chunk=\"Search_Chunk6.xml\" /><stem n=\"tabl\" chunk=\"Search_Chunk6.xml\" /><stem n=\"recogn\" chunk=\"Search_Chunk6.xml\" /><stem n=\"six\" chunk=\"Search_Chunk6.xml\" /><stem n=\"accept\" chunk=\"Search_Chunk6.xml\" /><stem n=\"seven\" chunk=\"Search_Chunk6.xml\" /><stem n=\"filesourceid\" chunk=\"Search_Chunk6.xml\" /><stem n=\"projectid\" chunk=\"Search_Chunk6.xml\" /><stem n=\"project\" chunk=\"Search_Chunk6.xml\" /><stem n=\"acquir\" chunk=\"Search_Chunk6.xml\" /><stem n=\"systemid\" chunk=\"Search_Chunk6.xml\" /><stem n=\"generatingsoftwar\" chunk=\"Search_Chunk6.xml\" /><stem n=\"filecreationd\" chunk=\"Search_Chunk6.xml\" /><stem n=\"date\" chunk=\"Search_Chunk6.xml\" /><stem n=\"yyyi\" chunk=\"Search_Chunk6.xml\" /><stem n=\"mm\" chunk=\"Search_Chunk6.xml\" /><stem n=\"dd\" chunk=\"Search_Chunk6.xml\" /><stem n=\"pointrecordsbyreturncount\" chunk=\"Search_Chunk6.xml\" /><stem n=\"per\" chunk=\"Search_Chunk6.xml\" /><stem n=\"precompressionpointcount\" chunk=\"Search_Chunk6.xml\" /><stem n=\"decim\" chunk=\"Search_Chunk6.xml\" /><stem n=\"las_boundingbox\" chunk=\"Search_Chunk6.xml\" /><stem n=\"vlr\" chunk=\"Search_Chunk6.xml\" /><stem n=\"id\" chunk=\"Search_Chunk6.xml\" /><stem n=\"record\" chunk=\"Search_Chunk6.xml\" /><stem n=\"unrecogn\" chunk=\"Search_Chunk6.xml\" /><stem n=\"vlrs\" chunk=\"Search_Chunk6.xml\" /><stem n=\"cpp\" chunk=\"Search_Chunk6.xml\" /><stem n=\"usertutori\" chunk=\"Search_Chunk6.xml\" /><stem n=\"dumpmg4info\" chunk=\"Search_Chunk6.xml\" /><stem n=\"display\" chunk=\"Search_Chunk6.xml\" /><stem n=\"decodemg4totxt\" chunk=\"Search_Chunk6.xml\" /><stem n=\"iterateoverpoint\" chunk=\"Search_Chunk6.xml\" /><stem n=\"usertest\" chunk=\"Search_Chunk6.xml\" /><stem n=\"explor\" chunk=\"Search_Chunk6.xml\" /><stem n=\"tetons_200k\" chunk=\"Search_Chunk6.xml\" /><stem n=\"sid\" chunk=\"Search_Chunk6.xml\" /><stem n=\"r\" chunk=\"Search_Chunk6.xml\" /><stem n=\"now\" chunk=\"Search_Chunk6.xml\" /><stem n=\"count_typ\" chunk=\"Search_Chunk6.xml\" /><stem n=\"numpoint\" chunk=\"Search_Chunk6.xml\" /><stem n=\"size_t\" chunk=\"Search_Chunk6.xml\" /><stem n=\"numchannel\" chunk=\"Search_Chunk6.xml\" /><stem n=\"const\" chunk=\"Search_Chunk6.xml\" /><stem n=\"printf\" chunk=\"Search_Chunk6.xml\" /><stem n=\"lld\" chunk=\"Search_Chunk6.xml\" /><stem n=\"n\" chunk=\"Search_Chunk6.xml\" /><stem n=\"lu\" chunk=\"Search_Chunk6.xml\" /><stem n=\"i\" chunk=\"Search_Chunk6.xml\" /><stem n=\"getchannel\" chunk=\"Search_Chunk6.xml\" /><stem n=\"getnam\" chunk=\"Search_Chunk6.xml\" /><stem n=\"1000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"whole\" chunk=\"Search_Chunk6.xml\" /><stem n=\"getbound\" chunk=\"Search_Chunk6.xml\" /><stem n=\"while\" chunk=\"Search_Chunk6.xml\" /><stem n=\"thing\" chunk=\"Search_Chunk6.xml\" /><stem n=\"chunk\" chunk=\"Search_Chunk6.xml\" /><stem n=\"000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"case\" chunk=\"Search_Chunk6.xml\" /><stem n=\"channel_name_x\" chunk=\"Search_Chunk6.xml\" /><stem n=\"channel_name_i\" chunk=\"Search_Chunk6.xml\" /><stem n=\"channel_name_z\" chunk=\"Search_Chunk6.xml\" /><stem n=\"10000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"huge\" chunk=\"Search_Chunk6.xml\" /><stem n=\"we\'ll\" chunk=\"Search_Chunk6.xml\" /><stem n=\"littl\" chunk=\"Search_Chunk6.xml\" /><stem n=\"houseclean\" chunk=\"Search_Chunk6.xml\" /><stem n=\"you\'r\" chunk=\"Search_Chunk6.xml\" /><stem n=\"find\" chunk=\"Search_Chunk6.xml\" /><stem n=\"decompress\" chunk=\"Search_Chunk6.xml\" /><stem n=\"lidardecod\" chunk=\"Search_Chunk6.xml\" /><stem n=\"paramet\" chunk=\"Search_Chunk6.xml\" /><stem n=\"inputfil\" chunk=\"Search_Chunk6.xml\" /><stem n=\"outputfil\" chunk=\"Search_Chunk6.xml\" /><stem n=\"o\" chunk=\"Search_Chunk6.xml\" /><stem n=\"outputformat\" chunk=\"Search_Chunk6.xml\" /><stem n=\"extens\" chunk=\"Search_Chunk6.xml\" /><stem n=\"append\" chunk=\"Search_Chunk6.xml\" /><stem n=\"suffix\" chunk=\"Search_Chunk6.xml\" /><stem n=\"switch\" chunk=\"Search_Chunk6.xml\" /><stem n=\"order\" chunk=\"Search_Chunk6.xml\" /><stem n=\"syntax\" chunk=\"Search_Chunk6.xml\" /><stem n=\"bear\" chunk=\"Search_Chunk6.xml\" /><stem n=\"concaten\" chunk=\"Search_Chunk6.xml\" /><stem n=\"las10\" chunk=\"Search_Chunk6.xml\" /><stem n=\"las11\" chunk=\"Search_Chunk6.xml\" /><stem n=\"las12\" chunk=\"Search_Chunk6.xml\" /><stem n=\"subsampl\" chunk=\"Search_Chunk6.xml\" /><stem n=\"unsign\" chunk=\"Search_Chunk6.xml\" /><stem n=\"tell\" chunk=\"Search_Chunk6.xml\" /><stem n=\"th\" chunk=\"Search_Chunk6.xml\" /><stem n=\"half\" chunk=\"Search_Chunk6.xml\" /><stem n=\"third\" chunk=\"Search_Chunk6.xml\" /><stem n=\"crop\" chunk=\"Search_Chunk6.xml\" /><stem n=\"float0\" chunk=\"Search_Chunk6.xml\" /><stem n=\"float1\" chunk=\"Search_Chunk6.xml\" /><stem n=\"float2\" chunk=\"Search_Chunk6.xml\" /><stem n=\"float3\" chunk=\"Search_Chunk6.xml\" /><stem n=\"float4\" chunk=\"Search_Chunk6.xml\" /><stem n=\"float5\" chunk=\"Search_Chunk6.xml\" /><stem n=\"coordin\" chunk=\"Search_Chunk6.xml\" /><stem n=\"inf\" chunk=\"Search_Chunk6.xml\" /><stem n=\"+inf\" chunk=\"Search_Chunk6.xml\" /><stem n=\"maximum\" chunk=\"Search_Chunk6.xml\" /><stem n=\"of\" chunk=\"Search_Chunk6.xml\" /><stem n=\"outfield\" chunk=\"Search_Chunk6.xml\" /><stem n=\"ofld\" chunk=\"Search_Chunk6.xml\" /><stem n=\"particular\" chunk=\"Search_Chunk6.xml\" /><stem n=\"field\" chunk=\"Search_Chunk6.xml\" /><stem n=\"d\" chunk=\"Search_Chunk6.xml\" /><stem n=\"e\" chunk=\"Search_Chunk6.xml\" /><stem n=\"p\" chunk=\"Search_Chunk6.xml\" /><stem n=\"u\" chunk=\"Search_Chunk6.xml\" /><stem n=\"t\" chunk=\"Search_Chunk6.xml\" /><stem n=\"g\" chunk=\"Search_Chunk6.xml\" /><stem n=\"b\" chunk=\"Search_Chunk6.xml\" /><stem n=\"sc\" chunk=\"Search_Chunk6.xml\" /><stem n=\"001\" chunk=\"Search_Chunk6.xml\" /><stem n=\"short\" chunk=\"Search_Chunk6.xml\" /><stem n=\"help\" chunk=\"Search_Chunk6.xml\" /><stem n=\"v\" chunk=\"Search_Chunk6.xml\" /><stem n=\"verbos\" chunk=\"Search_Chunk6.xml\" /><stem n=\"exp_d2_1\" chunk=\"Search_Chunk6.xml\" /><stem n=\"localtestimag\" chunk=\"Search_Chunk6.xml\" /><stem n=\"produc\" chunk=\"Search_Chunk6.xml\" /><stem n=\"previous\" chunk=\"Search_Chunk6.xml\" /><stem n=\"exp_d2_2\" chunk=\"Search_Chunk6.xml\" /><stem n=\"xyz\" chunk=\"Search_Chunk6.xml\" /><stem n=\"limit\" chunk=\"Search_Chunk6.xml\" /><stem n=\"four\" chunk=\"Search_Chunk6.xml\" /><stem n=\"txyz\" chunk=\"Search_Chunk6.xml\" /><stem n=\"lidarinfo\" chunk=\"Search_Chunk6.xml\" /><stem n=\"lidardinfo\" chunk=\"Search_Chunk6.xml\" /><stem n=\"pars\" chunk=\"Search_Chunk6.xml\" /><stem n=\"valid\" chunk=\"Search_Chunk6.xml\" /><stem n=\"skip\" chunk=\"Search_Chunk6.xml\" /><stem n=\"five\" chunk=\"Search_Chunk6.xml\" /><stem n=\"tsxyz\" chunk=\"Search_Chunk6.xml\" /><stem n=\"correct\" chunk=\"Search_Chunk6.xml\" /><stem n=\"label\" chunk=\"Search_Chunk6.xml\" /><stem n=\"m\" chunk=\"Search_Chunk6.xml\" /><stem n=\"extent\" chunk=\"Search_Chunk6.xml\" /><stem n=\"instead\" chunk=\"Search_Chunk6.xml\" /><stem n=\"report\" chunk=\"Search_Chunk6.xml\" /><stem n=\"skiphead\" chunk=\"Search_Chunk6.xml\" /><stem n=\"histogram\" chunk=\"Search_Chunk6.xml\" /><stem n=\"lakeroosevelt_2\" chunk=\"Search_Chunk6.xml\" /><stem n=\"info\" chunk=\"Search_Chunk6.xml\" /><stem n=\"3144893399\" chunk=\"Search_Chunk6.xml\" /><stem n=\"408841\" chunk=\"Search_Chunk6.xml\" /><stem n=\"780000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"5370276\" chunk=\"Search_Chunk6.xml\" /><stem n=\"770000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"391\" chunk=\"Search_Chunk6.xml\" /><stem n=\"350000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"447234\" chunk=\"Search_Chunk6.xml\" /><stem n=\"600000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"5422959\" chunk=\"Search_Chunk6.xml\" /><stem n=\"680000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"1188\" chunk=\"Search_Chunk6.xml\" /><stem n=\"890000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"spatial\" chunk=\"Search_Chunk6.xml\" /><stem n=\"none\" chunk=\"Search_Chunk6.xml\" /><stem n=\"appendix\" chunk=\"Search_Chunk6.xml\" /><stem n=\"compani\" chunk=\"Search_Chunk6.xml\" /><stem n=\"pertain\" chunk=\"Search_Chunk6.xml\" /><stem n=\"patent\" chunk=\"Search_Chunk6.xml\" /><stem n=\"deliv\" chunk=\"Search_Chunk6.xml\" /><stem n=\"art\" chunk=\"Search_Chunk6.xml\" /><stem n=\"massiv\" chunk=\"Search_Chunk6.xml\" /><stem n=\"high\" chunk=\"Search_Chunk6.xml\" /><stem n=\"resolut\" chunk=\"Search_Chunk6.xml\" /><stem n=\"aerial\" chunk=\"Search_Chunk6.xml\" /><stem n=\"satellit\" chunk=\"Search_Chunk6.xml\" /><stem n=\"imageri\" chunk=\"Search_Chunk6.xml\" /><stem n=\"pioneer\" chunk=\"Search_Chunk6.xml\" /><stem n=\"power\" chunk=\"Search_Chunk6.xml\" /><stem n=\"seattl\" chunk=\"Search_Chunk6.xml\" /><stem n=\"denver\" chunk=\"Search_Chunk6.xml\" /><stem n=\"london\" chunk=\"Search_Chunk6.xml\" /><stem n=\"tokyo\" chunk=\"Search_Chunk6.xml\" /><stem n=\"divis\" chunk=\"Search_Chunk6.xml\" /><stem n=\"celartem\" chunk=\"Search_Chunk6.xml\" /><stem n=\"inc\" chunk=\"Search_Chunk6.xml\" /><stem n=\"glad\" chunk=\"Search_Chunk6.xml\" /><stem n=\"our\" chunk=\"Search_Chunk6.xml\" /><stem n=\"re\" chunk=\"Search_Chunk6.xml\" /><stem n=\"confid\" chunk=\"Search_Chunk6.xml\" /><stem n=\"everyth\" chunk=\"Search_Chunk6.xml\" /><stem n=\"build\" chunk=\"Search_Chunk6.xml\" /><stem n=\"shop\" chunk=\"Search_Chunk6.xml\" /><stem n=\"great\" chunk=\"Search_Chunk6.xml\" /><stem n=\"geoview\" chunk=\"Search_Chunk6.xml\" /><stem n=\"export\" chunk=\"Search_Chunk6.xml\" /><stem n=\"jpeg\" chunk=\"Search_Chunk6.xml\" /><stem n=\"2000\" chunk=\"Search_Chunk6.xml\" /><stem n=\"layer\" chunk=\"Search_Chunk6.xml\" /><stem n=\"standalon\" chunk=\"Search_Chunk6.xml\" /><stem n=\"vector\" chunk=\"Search_Chunk6.xml\" /><stem n=\"overlay\" chunk=\"Search_Chunk7.xml\" /><stem n=\"combin\" chunk=\"Search_Chunk7.xml\" /><stem n=\"vari\" chunk=\"Search_Chunk7.xml\" /><stem n=\"repositori\" chunk=\"Search_Chunk7.xml\" /><stem n=\"express\" chunk=\"Search_Chunk7.xml\" /><stem n=\"catalog\" chunk=\"Search_Chunk7.xml\" /><stem n=\"wms\" chunk=\"Search_Chunk7.xml\" /><stem n=\"jpip\" chunk=\"Search_Chunk7.xml\" /><stem n=\"wide\" chunk=\"Search_Chunk7.xml\" /><stem n=\"geotiff\" chunk=\"Search_Chunk7.xml\" /><stem n=\"png\" chunk=\"Search_Chunk7.xml\" /><stem n=\"it\" chunk=\"Search_Chunk7.xml\" /><stem n=\"categori\" chunk=\"Search_Chunk7.xml\" /><stem n=\"expressview\" chunk=\"Search_Chunk7.xml\" /><stem n=\"browser\" chunk=\"Search_Chunk7.xml\" /><stem n=\"plug\" chunk=\"Search_Chunk7.xml\" /><stem n=\"fast\" chunk=\"Search_Chunk7.xml\" /><stem n=\"easi\" chunk=\"Search_Chunk7.xml\" /><stem n=\"larg\" chunk=\"Search_Chunk7.xml\" /><stem n=\"expressview™\" chunk=\"Search_Chunk7.xml\" /><stem n=\"navig\" chunk=\"Search_Chunk7.xml\" /><stem n=\"print\" chunk=\"Search_Chunk7.xml\" /><stem n=\"internet\" chunk=\"Search_Chunk7.xml\" /><stem n=\"firefox\" chunk=\"Search_Chunk7.xml\" /><stem n=\"save\" chunk=\"Search_Chunk7.xml\" /><stem n=\"portion\" chunk=\"Search_Chunk7.xml\" /><stem n=\"easili\" chunk=\"Search_Chunk7.xml\" /><stem n=\"individu\" chunk=\"Search_Chunk7.xml\" /><stem n=\"conveni\" chunk=\"Search_Chunk7.xml\" /><stem n=\"network\" chunk=\"Search_Chunk7.xml\" /><stem n=\"geoexpress\" chunk=\"Search_Chunk7.xml\" /><stem n=\"manipul\" chunk=\"Search_Chunk7.xml\" /><stem n=\"reproject\" chunk=\"Search_Chunk7.xml\" /><stem n=\"balanc\" chunk=\"Search_Chunk7.xml\" /><stem n=\"mosaick\" chunk=\"Search_Chunk7.xml\" /><stem n=\"choic\" chunk=\"Search_Chunk7.xml\" /><stem n=\"ideal\" chunk=\"Search_Chunk7.xml\" /><stem n=\"center\" chunk=\"Search_Chunk7.xml\" /><stem n=\"workflow\" chunk=\"Search_Chunk7.xml\" /><stem n=\"geo\" chunk=\"Search_Chunk7.xml\" /><stem n=\"compressor™\" chunk=\"Search_Chunk7.xml\" /><stem n=\"dataset\" chunk=\"Search_Chunk7.xml\" /><stem n=\"unlik\" chunk=\"Search_Chunk7.xml\" /><stem n=\"deliveri\" chunk=\"Search_Chunk7.xml\" /><stem n=\"solut\" chunk=\"Search_Chunk7.xml\" /><stem n=\"devic\" chunk=\"Search_Chunk7.xml\" /><stem n=\"faster\" chunk=\"Search_Chunk7.xml\" /><stem n=\"low\" chunk=\"Search_Chunk7.xml\" /><stem n=\"connect\" chunk=\"Search_Chunk7.xml\" /><stem n=\"stabl\" chunk=\"Search_Chunk7.xml\" /><stem n=\"exp\" chunk=\"Search_Chunk7.xml\" /><stem n=\"©\" chunk=\"Search_Chunk7.xml\" /><stem n=\"2009\" chunk=\"Search_Chunk7.xml\" /><stem n=\"right\" chunk=\"Search_Chunk7.xml\" /><stem n=\"reserv\" chunk=\"Search_Chunk7.xml\" /><stem n=\"subject\" chunk=\"Search_Chunk7.xml\" /><stem n=\"without\" chunk=\"Search_Chunk7.xml\" /><stem n=\"notic\" chunk=\"Search_Chunk7.xml\" /><stem n=\"furnish\" chunk=\"Search_Chunk7.xml\" /><stem n=\"agreement\" chunk=\"Search_Chunk7.xml\" /><stem n=\"nondisclosur\" chunk=\"Search_Chunk7.xml\" /><stem n=\"accord\" chunk=\"Search_Chunk7.xml\" /><stem n=\"term\" chunk=\"Search_Chunk7.xml\" /><stem n=\"transmit\" chunk=\"Search_Chunk7.xml\" /><stem n=\"electron\" chunk=\"Search_Chunk7.xml\" /><stem n=\"photocopi\" chunk=\"Search_Chunk7.xml\" /><stem n=\"purpos\" chunk=\"Search_Chunk7.xml\" /><stem n=\"person\" chunk=\"Search_Chunk7.xml\" /><stem n=\"written\" chunk=\"Search_Chunk7.xml\" /><stem n=\"permiss\" chunk=\"Search_Chunk7.xml\" /><stem n=\"regist\" chunk=\"Search_Chunk7.xml\" /><stem n=\"unit\" chunk=\"Search_Chunk7.xml\" /><stem n=\"logo\" chunk=\"Search_Chunk7.xml\" /><stem n=\"unauthor\" chunk=\"Search_Chunk7.xml\" /><stem n=\"prohibit\" chunk=\"Search_Chunk7.xml\" /><stem n=\"organ\" chunk=\"Search_Chunk7.xml\" /><stem n=\"whose\" chunk=\"Search_Chunk7.xml\" /><stem n=\"effort\" chunk=\"Search_Chunk7.xml\" /><stem n=\"automat\" chunk=\"Search_Chunk7.xml\" /><stem n=\"1008\" chunk=\"Search_Chunk7.xml\" /><stem n=\"western\" chunk=\"Search_Chunk7.xml\" /><stem n=\"avenu\" chunk=\"Search_Chunk7.xml\" /><stem n=\"suit\" chunk=\"Search_Chunk7.xml\" /><stem n=\"403\" chunk=\"Search_Chunk7.xml\" /><stem n=\"washington\" chunk=\"Search_Chunk7.xml\" /><stem n=\"usa\" chunk=\"Search_Chunk7.xml\" /><stem n=\"98104\" chunk=\"Search_Chunk7.xml\" /><stem n=\"652\" chunk=\"Search_Chunk7.xml\" /><stem n=\"5211\" chunk=\"Search_Chunk7.xml\" /><stem n=\"pend\" chunk=\"Search_Chunk7.xml\" /></ents><chunkfiles><Url Source=\"Search_Chunk1.xml\" /><Url Source=\"Search_Chunk2.xml\" /><Url Source=\"Search_Chunk3.xml\" /><Url Source=\"Search_Chunk4.xml\" /><Url Source=\"Search_Chunk5.xml\" /><Url Source=\"Search_Chunk6.xml\" /><Url Source=\"Search_Chunk7.xml\" /></chunkfiles></index>';
CMCXmlParser._FilePathToXmlStringMap.Add('Search', xmlSearchData);
